package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.DatePickerDialog;
import android.content.Intent;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.listener.OnBottomReachedListener;
import com.b2lmobitech.fieldcloudplus.service.adapter.TicketHistoryAdapter;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ReportHistoryActivity extends AppCompatActivity implements OnItemClickListener,OnBottomReachedListener{

    RecyclerView recyclerView;
    TextView errorText;
    TicketHistoryAdapter adapter;
    int count;
    String date="";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_reporthistory);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Report History");


        getTicketsCount();


    }

    private void getTicketsCount(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("date", date);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.GET_REPORTHISTORY, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    count=new JSONObject(response).getInt("count");
                    errorText.setText("No Reports Found");
                    errorText.setVisibility(count==0?View.VISIBLE: View.GONE);
                    setEmptyAdapter();
                    getTickets();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setEmptyAdapter(){
        adapter=new TicketHistoryAdapter(this,new JSONArray());
        recyclerView.setAdapter(adapter);
    }

    private void getTickets(){
        Preference preference=Preference.getInstance(this);

        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("date", date);
        if(adapter.getItemCount()<count){
            params.put("start",(adapter.getItemCount())+"");
        }else{
            return;
        }
        MyRequestQueue.getInstance(this).addToQueue(SERVICEURL.GET_REPORTHISTORY, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    setAdapter(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAdapter(JSONObject jsonObject) throws JSONException {
        Parcelable parcelable=recyclerView.getLayoutManager().onSaveInstanceState();
        JSONArray jsonArray=adapter.getJsonArray();
        JSONArray listArray=jsonObject.getJSONArray("tickets");
        try {
            for(int i=0; i<listArray.length(); i++){
                jsonArray.put(listArray.getJSONObject(i));
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if(listArray.length()!=0) {
            adapter = new TicketHistoryAdapter(this, jsonArray);
            recyclerView.setAdapter(adapter);
            recyclerView.getLayoutManager().onRestoreInstanceState(parcelable);
        }
    }

    @Override
    public void itemClicked(int position) {
        try {
            JSONObject jsonObject=adapter.getJsonArray().getJSONObject(position);
            Intent intent=new Intent(getApplicationContext(),ReportInfoActivity.class);
            intent.putExtra("ticket",jsonObject.getString("ticketnumber"));
            intent.putExtra("company",jsonObject.getString("cname"));
            startActivity(intent);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBottomReached(int position) {
        if(position+1<count){
            getTickets();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.service_tickethistory, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.date:
                selectDate();
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void selectDate(){
        final Calendar myCalendar=Calendar.getInstance();

        final DatePickerDialog.OnDateSetListener listenr = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                myCalendar.set(Calendar.YEAR, year);
                myCalendar.set(Calendar.MONTH, monthOfYear);
                myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                date=sdf.format(myCalendar.getTime());
                getTicketsCount();
            }

        };
        DatePickerDialog datePicker =  new DatePickerDialog(this, listenr, myCalendar
                .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                myCalendar.get(Calendar.DAY_OF_MONTH));
        datePicker.show();
    }


}
