package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.bumptech.glide.Glide;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class ReportInfoActivity extends AppCompatActivity {

    String ticket,company;
    LinearLayout detailsLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_reportinfo);
        detailsLayout=findViewById(R.id.detailsLayout);
        ticket=getIntent().getStringExtra("ticket");
        company=getIntent().getStringExtra("company");

        getSupportActionBar().setTitle("Report Details");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getReportInfo();

    }

    private void getReportInfo(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", company);
        params.put("ticket",ticket);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.GET_REPORTINFO, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getInfo(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void getInfo(JSONObject json) throws JSONException, ParseException {
        JSONObject jsonObject=json.getJSONArray("ticket").getJSONObject(0);
        addView("Customer Name",jsonObject.getString("customername"));
        addView("Facility Name",jsonObject.getString("companyname"));
        addView("Address",jsonObject.getString("location"));
        addView("Mobile",jsonObject.getString("atmphonenumber"));
        addView("Customer Type",jsonObject.getString("customertype"));
        addView("Reason",jsonObject.getString("questionorcallreason"));
        addView("Created On", DateUtils.getNormalDatetime(jsonObject.getString("createddateandtime")));
        addView("Assigned On", DateUtils.getNormalDatetime(jsonObject.getString("assigneddateandtime")));
        addView("Completed On", DateUtils.getNormalDatetime(jsonObject.getString("dateandtime")));
        addView("Completed Location",jsonObject.getString("workdonelocation"));
        addView("Status",jsonObject.getString("workstatus"));
        if(!jsonObject.getString("workreportdetails").isEmpty()) {
            addView("Details", jsonObject.getString("workreportdetails"));
        }
        addView("Worked Hours",jsonObject.getString("working_hours"));

        if(json.getJSONArray("spares").length()!=0){
            addLinkView(json.getJSONArray("spares"));
        }
        addView("Spares Charge",jsonObject.getString("sparesamount"));
        addView("Service Charge",jsonObject.getString("servicecharge"));
        addView("Total Charge",jsonObject.getString("amountreceived"));
        addImageView("Bill Image",jsonObject.getString("billimagepath"));
        addImageView("Status Image",jsonObject.getString("imagepath"));
        addView("Signaturer",jsonObject.getString("nameofsignature"));
        addImageView("Signature",jsonObject.getString("signaturepath"));
    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.row_ticket,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        detailsLayout.addView(view);
    }

    private void addImageView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.row_ticket_image,null);
        TextView keyText=view.findViewById(R.id.keyText);
        ImageView imageView=view.findViewById(R.id.imageView);
        Glide.with(this)
                .load(SERVICEURL.IMAGE+pair)
                .into(imageView);
        keyText.setText(key);
        detailsLayout.addView(view);
    }

    private void addLinkView(final JSONArray jsonArray){
        View view=getLayoutInflater().inflate(R.layout.row_ticekt_link,null);
        TextView keyText=view.findViewById(R.id.keyText);
        keyText.setText("Spares List");
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(getApplicationContext(),SelectSpareActivity.class);
                intent.putExtra("add",false);
                intent.putExtra("json",jsonArray.toString());
                startActivity(intent);
            }
        });
        detailsLayout.addView(view);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
