package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.ItemTouchHelper;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.service.adapter.SpareAdapter;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class SelectSpareActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    TextView errorText;
    private final int REQUEST_CODE=2;
    JSONArray jsonArray=new JSONArray();
    ArrayList<JSONObject> arrayList=new ArrayList<>();
    ArrayList<String> sparesList=new ArrayList<>();

    boolean add;
    SpareAdapter spareAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_select_spare);
        getSupportActionBar().setTitle("Spares");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        add=getIntent().getBooleanExtra("add",true);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);

        try {
            jsonArray=new JSONArray(getIntent().getStringExtra("json"));
            sparesList=getIntent().getStringArrayListExtra("spares");
            arrayList= JSONUtils.fromJSONArray(jsonArray);
            setAdapter();
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if(add){
           addSwipeDelete();
        }

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        //processImage(resultCode,requestCode);
        if (requestCode == REQUEST_CODE && resultCode == RESULT_OK) {
                try {
                    JSONObject jsonObject=new JSONObject(data.getStringExtra("json"));
                    arrayList.add(jsonObject);
                    setAdapter();
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }
    }

    private void setAdapter(){
        Parcelable parcelable=recyclerView.getLayoutManager().onSaveInstanceState();
        spareAdapter=new SpareAdapter(this,arrayList);
        recyclerView.setAdapter(spareAdapter);
        recyclerView.getLayoutManager().onRestoreInstanceState(parcelable);

        if(arrayList.size()==0){
            errorText.setText("No Spares Added");
            errorText.setVisibility(View.VISIBLE);
        }else{
            errorText.setVisibility(View.GONE);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.service_spare, menu);
        MenuItem addSapre=menu.findItem(R.id.addSapre);
        addSapre.setVisible(add);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.addSapre:
                Intent intent=new Intent(getApplicationContext(),AddSpareActivity.class);
                intent.putExtra("json",JSONUtils.fromArrayList(arrayList).toString());
                intent.putStringArrayListExtra("spares",sparesList);
                startActivityForResult(intent,REQUEST_CODE);
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void itemClicked(int position) {

    }

    @Override
    public void onBackPressed() {
        if(add) {
            try {
                setResult();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }else{
            finish();
        }
    }

    private void setResult() throws JSONException {
        int total=0;
        JSONArray jsonArray=spareAdapter.getJsonArray();
        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            total=total+jsonObject.getInt("total");
        }
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("total",total);
        jsonObject.put("list",jsonArray);
        setResult(Activity.RESULT_OK,new Intent().putExtra("json",jsonObject.toString()));

        finish();
    }

    private void addSwipeDelete(){
        ItemTouchHelper.SimpleCallback simpleCallback = new ItemTouchHelper.SimpleCallback(0, ItemTouchHelper.LEFT | ItemTouchHelper.RIGHT) {
            @Override
            public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
                return false;
            }

            public static final float ALPHA_FULL = 1.0f;

            public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {

                if (actionState == ItemTouchHelper.ACTION_STATE_SWIPE) {

                    View itemView = viewHolder.itemView;

                    Paint p = new Paint();
                    Bitmap icon;

                    if (dX > 0) {

                        //color : left side (swiping towards right)
                        p.setARGB(255, 255, 0, 0);
                        c.drawRect((float) itemView.getLeft(), (float) itemView.getTop(), dX,
                                (float) itemView.getBottom(), p);

                        // icon : left side (swiping towards right)
                        icon = BitmapFactory.decodeResource(getApplicationContext().getResources(), R.drawable.ic_delete_white);
                        c.drawBitmap(icon,
                                (float) itemView.getLeft() + convertDpToPx(16),
                                (float) itemView.getTop() + ((float) itemView.getBottom() - (float) itemView.getTop() - icon.getHeight())/2,
                                p);
                    }

                    // Fade out the view when it is swiped out of the parent
                    final float alpha = ALPHA_FULL - Math.abs(dX) / (float) viewHolder.itemView.getWidth();
                    viewHolder.itemView.setAlpha(alpha);
                    viewHolder.itemView.setTranslationX(dX);

                } else {
                    super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
                }
            }

            private int convertDpToPx(int dp){
                return Math.round(dp * (getResources().getDisplayMetrics().xdpi / DisplayMetrics.DENSITY_DEFAULT));
            }
            @Override
            public void onSwiped(final RecyclerView.ViewHolder viewHolder, int direction) {
                final int position = viewHolder.getAdapterPosition(); //swiped position

                if (direction == ItemTouchHelper.RIGHT) { //swipe left
                    spareAdapter.removeItem(position);
                    //arrayList.remove(position);
                    setAdapter();
                }
            }
        };
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper(simpleCallback);
        itemTouchHelper.attachToRecyclerView(recyclerView);
    }

}
