package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.util.Log;
import android.view.MenuItem;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.adapter.ServiceCombinationAdapter;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;

import org.json.JSONArray;
import org.json.JSONException;

public class ServiceCombinationActivity extends AppCompatActivity implements OnItemClickListener {

    RecyclerView recyclerView;
    TextView errorText;
    String id,date,assignid,lat,lon;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_service_combination);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Service");

        id=getIntent().getStringExtra("id");
        date=getIntent().getStringExtra("date");
        assignid=getIntent().getStringExtra("assignid");
        lat=getIntent().getStringExtra("lat");
        lon=getIntent().getStringExtra("lon");
        Log.e("location", "[" + lat + "," + lon + "]");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getCategories();
    }

    private void getCategories(){
        jsonArray= ServiceDatabase.getInstance(this).getCombinations(id,date);
        if(jsonArray.length()==0){
            finish();
        }else if(jsonArray.length() == 1){
            itemClicked(0);
            finish();
        }
        ServiceCombinationAdapter serviceCombinationAdapter=new ServiceCombinationAdapter(this,jsonArray);
        recyclerView.setAdapter(serviceCombinationAdapter);
    }

    @Override
    public void itemClicked(int position) {
             Intent intent=new Intent(getApplicationContext(),CategoryActivity.class);
             intent.putExtra("id",id);
             intent.putExtra("date",date);
             intent.putExtra("lat", lat);
             intent.putExtra("lon", lon);
        try {
            intent.putExtra("assignid",jsonArray.getJSONObject(position).getString(AssignTable.ASSIGNID));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        startActivity(intent);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }


}
