package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.util.Log;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.adapter.SubCategoryAdapter;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QuestionTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SubCategoryActivity extends AppCompatActivity implements OnItemClickListener{

    RecyclerView recyclerView;
    TextView errorText;
    String id,date,cat;
    JSONArray jsonArray;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_sub_categorys);
        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Category");
        id=getIntent().getStringExtra("id");
        date=getIntent().getStringExtra("date");
        cat=getIntent().getStringExtra("cat");

        getSubCategories();
    }

    private void getSubCategories(){
        //jsonArray= ServiceDatabase.getInstance(this).getSubCategories(id,date,cat);
        SubCategoryAdapter categoryAdapter=new SubCategoryAdapter(this,jsonArray);
        Log.d("lenght",jsonArray.toString());
        recyclerView.setAdapter(categoryAdapter);
    }

    @Override
    public void itemClicked(int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            Intent intent=new Intent(getApplicationContext(),QuestionActivity.class);
            intent.putExtra("id",id);
            intent.putExtra("date",date);
            intent.putExtra("cat",jsonObject.getString(QuestionTable.CATEGORY));
            intent.putExtra("subcat",jsonObject.getString(QuestionTable.SUBCAT));
            startActivity(intent);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}
