package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Intent;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.adapter.TicketAdapter;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class TicketActivity extends AppCompatActivity implements OnItemClickListener{

    RecyclerView recyclerView;
    TextView errorText;
    TicketAdapter adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ticket);

        errorText=findViewById(R.id.errorText);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.addItemDecoration(new DividerItemDecoration(this, LinearLayoutManager.VERTICAL));
        recyclerView.setHasFixedSize(true);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Tickets");

        getTickets();
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTickets();
    }

    private void getTickets(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.GET_CORRECTIVE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    setAdapter(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAdapter(JSONObject jsonObject) throws JSONException {
        Parcelable parcelable = recyclerView.getLayoutManager().onSaveInstanceState();
        JSONArray jsonArray=jsonObject.getJSONArray("tickets");
        adapter=new TicketAdapter(this,jsonArray);
        recyclerView.setAdapter(adapter);
        errorText.setText("No Tickets Found");
        errorText.setVisibility(jsonArray.length() == 0 ? View.VISIBLE : View.GONE);
        recyclerView.getLayoutManager().onRestoreInstanceState(parcelable);
    }

    @Override
    public void itemClicked(int position) {
        try {
            JSONObject jsonObject=adapter.getJsonArray().getJSONObject(position);
            Intent intent = new Intent(getApplicationContext(), TicketInfoActivity.class);
            intent.putExtra("ticket", jsonObject.getString("ticketnumber"));
            intent.putExtra("facility", jsonObject.getString("atmid"));
            startActivity(intent);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

}
