package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Intent;
import android.os.Handler;
import com.google.android.material.tabs.TabLayout;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.TicketTable;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class TicketInfoActivity extends AppCompatActivity {

    TabLayout tabLayout;
    LinearLayout detailsLayout;
    String ticket,facility;
    private static final int CAPTURE_NUMBER=2,REQUEST=1;

    MenuItem report,accept,reject;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ticket_info);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setTitle("Ticket Details");
        ticket=getIntent().getStringExtra("ticket");
        facility=getIntent().getStringExtra("facility");
        getWidgets();
        getTicketInfo();
    }

    @Override
    protected void onResume() {
        super.onResume();

    }

    private void getTicketInfo(){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("ticket",ticket);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.GET_TICKETDETAILS, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    getInfo(new JSONObject(response));
                } catch (JSONException e) {
                    e.printStackTrace();
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getWidgets(){
        tabLayout=findViewById(R.id.tablayout);
        detailsLayout=findViewById(R.id.detailsLayout);
    }

    private void getInfo(final JSONObject jsonObject) throws JSONException, ParseException {
        final boolean isProduct = jsonObject.getString(TicketTable.CAT).isEmpty();
        checkforMenuCreated(jsonObject.getString("ticketstatus"));
        tabLayout.removeAllTabs();
        tabLayout.addTab(tabLayout.newTab().setText("Info"),true);
        if(isProduct){
            tabLayout.addTab(tabLayout.newTab().setText("Product"));
        }else{
            tabLayout.addTab(tabLayout.newTab().setText("Service"));
        }

        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                try {
                    if(tab.getPosition()==0){
                        addInfo(jsonObject);
                    }else if(isProduct){
                        addProductInfo(jsonObject);
                    }else{
                        addServiceInfo(jsonObject);
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });

        addInfo(jsonObject);
    }

    private void addInfo(JSONObject json) throws JSONException, ParseException {
       detailsLayout.removeAllViews();
       JSONObject jsonObject=json.getJSONArray("ticket").getJSONObject(0);
       addView("Ticket Number",jsonObject.getString("ticketnumber"));
       addView("Customer Name",jsonObject.getString("customername"));
       addView("Address",json.getString("atmaddress"));
       addView("Mobile",json.getString("atmphonenumber"));
       addView("Customer Type",jsonObject.getString("customertype"));
       addView("Reason",jsonObject.getString("questionorcallreason"));
       if(!jsonObject.getString("extranotes").isEmpty()) {
           addView("Notes", jsonObject.getString("extranotes"));
       }
       addView("Priority",jsonObject.getString("priority"));
       addView("Created On", DateUtils.getNormalDatetime(jsonObject.getString("createddateandtime")));
       addView("Assigned On", DateUtils.getNormalDatetime(jsonObject.getString("assigneddateandtime")));
    }

    private void addProductInfo(JSONObject jsonObject) throws JSONException {
        detailsLayout.removeAllViews();
        addView("Product",jsonObject.getString("product"));
        if(!jsonObject.getString("brand").isEmpty()) {
            addView("Brand", jsonObject.getString("brand"));
        }
        if(!jsonObject.getString("model").isEmpty()) {
            addView("Model", jsonObject.getString("model"));
        }
        if(!jsonObject.getString("serial").isEmpty()) {
            addView("Serial Number", jsonObject.getString("serial"));
        }
    }

    private void addServiceInfo(JSONObject jsonObject) throws JSONException {
        detailsLayout.removeAllViews();
        addView("Service Group",jsonObject.getString("cat"));
        if(!jsonObject.getString("subcat").isEmpty()){
            addView("Service Sub Group",jsonObject.getString("subcat"));
        }
        if(!jsonObject.getString("type").isEmpty()){
            addView("Service Type",jsonObject.getString("type"));
        }

    }

    private void addView(String key,String pair){
        View view=getLayoutInflater().inflate(R.layout.row_ticket,null);
        TextView keyText=view.findViewById(R.id.keyText);
        TextView pairText=view.findViewById(R.id.pairText);
        keyText.setText(key);
        pairText.setText(pair);
        detailsLayout.addView(view);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.service_ticket, menu);
        reject=menu.findItem(R.id.reject);
        accept=menu.findItem(R.id.accept);
        report=menu.findItem(R.id.report);

        reject.setVisible(false);
        accept.setVisible(false);
        report.setVisible(false);

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()){
            case R.id.report:
                openReport();
                break;
            case R.id.accept:
                updateTicket("accept");
                break;
            case R.id.reject:
                updateTicket("reject");
                break;
            case android.R.id.home:
                onBackPressed();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        //processImage(resultCode,requestCode);
        if(requestCode==REQUEST){
            switch (resultCode) {
                case Activity.RESULT_OK:
                    finish();
                    break;
                case Activity.RESULT_CANCELED:
                    // The user was asked to change settings, but chose not to
                    break;
                default:
                    break;
            }
        }
    }

    private void openReport(){
        Intent intent=new Intent(getApplicationContext(),ReportActivity.class);
        intent.putExtra("ticket",ticket);
        intent.putExtra("facility",facility);
        startActivityForResult(intent,REQUEST);
    }

    private void updateTicket(final String status){
        Preference preference=Preference.getInstance(this);
        Map<String, String> params = new HashMap<>();
        params.put("mail",preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("status", status);
        params.put("ticket", ticket);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.UPDATE_TICEKT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                if(status.equals("reject")){
                    finish();
                }else {
                    getTicketInfo();
                }
            }
        });

    }

    private void checkforMenuCreated(final String status){
        final Handler handler = new Handler();
        final Runnable runnable = new Runnable() {
            public void run() {
                if(report!=null){ // just remove call backs
                    handler.removeCallbacks(this);
                    try {
                        updateMenu(status);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else { // post again
                    handler.postDelayed(this, 100);
                }
            }
        };
        handler.removeCallbacks(runnable);
        handler.postDelayed(runnable, 100);
    }

    private void updateMenu(String status){
        if(status.equals("assigned")){
            accept.setVisible(true);
            reject.setVisible(true);
            report.setVisible(false);
        }else if(status.equals("underprogress")){
            report.setVisible(true);
            accept.setVisible(false);
            reject.setVisible(false);
        }

    }


}
