package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.app.NavUtils;
import androidx.core.content.FileProvider;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.task.Utility;

public class addexpense extends AppCompatActivity {
private Context mycontext;
    private Spinner ticketspinner,expensespinner;
    private ArrayList<String> expensetype,selectticket;
    private EditText desription,distancetravelled,amountclaimed,fromlocation,tolocation,location;
    private ImageView cameraButton,snapshot;
    private Button cancel,ok;
    private String selectedexpensetype="Select Expensetype",selectedticketnumber="Select Ticket",descriptiontext="",fromlocationtext="",tolocationtext="",locationtext="",claimamountvalue="0",distancevalue="0";
    private static final int CAMERA_CAPTURE_IMAGE_REQUEST_CODE = 100;
    private File imagefilepath;
    private  String picturefilename = "no data available",imageinstring="", url_insertexpense = "",registeredcompany,registeredemailid,url_get_tickets="";
    private int status =0,getsuccess=0;
    private  ProgressBar progressbar;
    private Snackbar snackBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_addexpense);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        mycontext= this;
        expensespinner = (Spinner) findViewById(R.id.expensetype);
        ticketspinner = (Spinner) findViewById(R.id.ticketnumber);
        desription = (EditText) findViewById(R.id.description);
        distancetravelled = (EditText) findViewById(R.id.distance);
        amountclaimed = (EditText) findViewById(R.id.amount);
        fromlocation = (EditText) findViewById(R.id.from);
        tolocation = (EditText) findViewById(R.id.to);
        location = (EditText) findViewById(R.id.location);
        cameraButton = (ImageView) findViewById(R.id.cameraButton);
        snapshot = (ImageView) findViewById(R.id.snapshot);
        cancel = (Button) findViewById(R.id.cancel);
        progressbar = (ProgressBar) findViewById(R.id.ticketprogressBar);
        ok = (Button) findViewById(R.id.ok);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        expensetype = new ArrayList<String>();
        expensetype.add(getResources().getString(R.string.select_conveyance_type));
        expensetype.add("Daily");
        expensetype.add("Travel");
        ArrayAdapter<String> statusAdapter = new ArrayAdapter<String>(mycontext,
                android.R.layout.simple_spinner_item, expensetype);
        statusAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        expensespinner.setAdapter(statusAdapter);

        ticketspinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedticketnumber = ticketspinner.getSelectedItem().toString();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });
        expensespinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedexpensetype = expensespinner.getSelectedItem().toString();
                if(selectedexpensetype.equalsIgnoreCase("Daily"))
                {
                    distancetravelled.setVisibility(View.GONE);
                    fromlocation.setVisibility(View.GONE);
                    tolocation.setVisibility(View.GONE);
                    location.setVisibility(View.VISIBLE);
                    ticketspinner.setVisibility(View.GONE);
                }
                else if(selectedexpensetype.equalsIgnoreCase("Travel"))
                {
                    distancetravelled.setVisibility(View.VISIBLE);
                    fromlocation.setVisibility(View.VISIBLE);
                    tolocation.setVisibility(View.VISIBLE);
                    location.setVisibility(View.GONE);
                    ticketspinner.setVisibility(View.VISIBLE);
                    if(isNetworkAvailable())
                    {
                        getTickets();
                    }else{
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content),"Please check the internet connection", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });
        cameraButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!isDeviceSupportCamera()) {
                    Toast.makeText(mycontext,
                            "Sorry! Your device doesn't support camera",
                            Toast.LENGTH_LONG).show();
                }
                else
                {
                    captureImage();
                }
            }
        });
        ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(isNetworkAvailable())
                {
                    if(selectedexpensetype.equalsIgnoreCase("Select Expensetype"))
                    {
                     // Toast.makeText(mycontext,"Please select Expense type.",Toast.LENGTH_LONG).show();
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please select Expense type.", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                    else {
                        descriptiontext = desription.getText().toString();
                        fromlocationtext = fromlocation.getText().toString();
                        tolocationtext = tolocation.getText().toString();
                        locationtext = location.getText().toString();
                        claimamountvalue = amountclaimed.getText().toString();
                        distancevalue = distancetravelled.getText().toString();
                        if (selectedexpensetype.equalsIgnoreCase("Daily")) {
                            if (desription.getText().toString().equalsIgnoreCase("") || amountclaimed.getText().toString().equalsIgnoreCase("") || location.getText().toString().equalsIgnoreCase("")) {
                                //Toast.makeText(mycontext, "Please fill all details", Toast.LENGTH_LONG).show();
                                snackBar.dismiss();
                                snackBar = Snackbar.make(findViewById(android.R.id.content), "Please fill all details", Snackbar.LENGTH_INDEFINITE);
                                toast();
                            } else {
                                fromlocationtext = "";
                                tolocationtext = "";
                                distancevalue = "0";
                                selectedticketnumber = "0";
                                insertExpense();
                            }
                        } else if (selectedexpensetype.equalsIgnoreCase("Travel")) {
                            if(selectedticketnumber.equalsIgnoreCase("Select Ticket"))
                            {
                               // Toast.makeText(mycontext,"Please select ticket number.",Toast.LENGTH_LONG).show();
                                snackBar.dismiss();
                                snackBar = Snackbar.make(findViewById(android.R.id.content), "Please select ticket number.", Snackbar.LENGTH_INDEFINITE);
                                toast();
                            }
                            else {
                                if (descriptiontext.equalsIgnoreCase("") || amountclaimed.getText().toString().equalsIgnoreCase("") || distancetravelled.getText().toString().equalsIgnoreCase("") || fromlocationtext.equalsIgnoreCase("") || tolocationtext.equalsIgnoreCase("")) {
                                    //Toast.makeText(mycontext, "Please fill all details", Toast.LENGTH_LONG).show();
                                    snackBar.dismiss();
                                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Please fill all details", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                } else {
                                    locationtext = "";
                                    insertExpense();

                                }
                            }
                        }
                    }
                }
                else
                {
                  //  Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content),"Please check the internet connection", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }

            }
        });
        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

    }

    private boolean isDeviceSupportCamera() {
        if (mycontext.getPackageManager().hasSystemFeature(
                PackageManager.FEATURE_CAMERA)) {
            // this device has a camera
            return true;
        } else {
            // no camera on this device
            return false;
        }
    }

    private void captureImage() {
        try {
            Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
         //   Uri fileUri = getOutputMediaFileUri();
            Uri fileUri = FileProvider.getUriForFile(addexpense.this,
                    BuildConfig.APPLICATION_ID + ".provider",
                    getOutputMediaFileUri());
            intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri);
            startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE);
        }catch(Exception e)
        {
            //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();

            try {
                Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

               Uri fileUri = getOutputMediaFileUriException();

                intent.putExtra(MediaStore.EXTRA_OUTPUT, fileUri);
                startActivityForResult(intent, CAMERA_CAPTURE_IMAGE_REQUEST_CODE);
            }catch(Exception e1)
            {
                //Toast.makeText(mycontext,"error"+e.toString(),Toast.LENGTH_LONG).show();
            }
        }
    }

    private File getOutputMediaFileUri() {
        File mediaFile = null;

        File mediaStorageDir = new File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/"+"ExpenseImages");
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }
        SimpleDateFormat dateFormatter2 = new SimpleDateFormat
                ("yyyyMMdd_HHmmss");
        mediaFile = new File(mediaStorageDir.getPath() + File.separator

                + "IMG_" + dateFormatter2.format(new Date()) + ".jpg");
        picturefilename = "IMG_" + dateFormatter2.format(new Date()) + ".jpg";
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        imagefilepath = mediaFile;
        return mediaFile;

    }


    private Uri getOutputMediaFileUriException() {
        File mediaFile = null;

        File mediaStorageDir = new File("/sdcard/Android/data/com.B2lmobitech.FieldCloudDesk/"+"ExpenseImages");
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }
        SimpleDateFormat dateFormatter2 = new SimpleDateFormat
                ("yyyyMMdd_HHmmss");
        mediaFile = new File(mediaStorageDir.getPath() + File.separator

                + "IMG_" + dateFormatter2.format(new Date()) + ".jpg");
        picturefilename = "IMG_" + dateFormatter2.format(new Date()) + ".jpg";
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        imagefilepath = mediaFile;
        return Uri.fromFile(mediaFile);

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (requestCode == CAMERA_CAPTURE_IMAGE_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {
                try {
                    File filename = imagefilepath;
                    decodemyFile(filename);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    Toast.makeText(getApplicationContext(),
                            "please try again", Toast.LENGTH_SHORT)
                            .show();
                }
            } else if (resultCode == RESULT_CANCELED) {

                // user cancelled Image capture
                Toast.makeText(getApplicationContext(),
                        "You cancelled image capture", Toast.LENGTH_SHORT)
                        .show();

            } else {
                // failed to capture image
                Toast.makeText(getApplicationContext(),
                        "Sorry! Failed to capture image", Toast.LENGTH_SHORT)
                        .show();
            }

        }

    }

    private void decodemyFile(File f) {
        try {
            // Decode image size
            final BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream(new FileInputStream(f), null, o);

            o.inSampleSize = calculateInSampleSize(o, 300, 300);
            o.inJustDecodeBounds = false;
            //---

            Bitmap bmp = BitmapFactory.decodeStream(new FileInputStream(f), null, o);//o2
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            //bmp.creates
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, stream);
            byte[] byteArray = stream.toByteArray();
            try {
                //convert file into array of bytes
                FileOutputStream fileOuputStream =
                        new FileOutputStream(f);//outputfile
                fileOuputStream.write(byteArray);
                fileOuputStream.flush();
                fileOuputStream.close();


                File filename = imagefilepath;
                if(Uri.fromFile(filename).getPath()!=null)
                {
                    // globalvariables.BitMapToString(bmp), subcategorylistadapter.Picturefilename
                    imageinstring = globalvariables.BitMapToString(bmp);
                    snapshot.setImageBitmap(bmp);

                }


            }catch(Exception e){
                e.printStackTrace();
            }



        } catch (FileNotFoundException e) {}
        // return null;
    }

    public static int calculateInSampleSize(
            BitmapFactory.Options options, int reqWidth, int reqHeight) {
        //Raw height and width of image
        final int height = options.outHeight;
        final int width = options.outWidth;
        int inSampleSize = 1;

        if (height > reqHeight || width > reqWidth) {

            final int halfHeight = height / 2;
            final int halfWidth = width / 2;

            // Calculate the largest inSampleSize value that is a power of 2 and keeps both
            // height and width larger than the requested height and width.
            while ((halfHeight / inSampleSize) >= reqHeight
                    && (halfWidth / inSampleSize) >= reqWidth) {
                inSampleSize *= 2;
            }
        }

        return inSampleSize;
    }


    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    private void toast(){
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

    private void getTickets(){
        Map<String, String> params = new HashMap<>();
        params.put("companyname",registeredcompany);
        params.put("Assignedto", registeredemailid);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
            myRequestQueue.addToQueue(SERVICEURL.GET_TICKETSFOREXPENSE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    selectticket=new ArrayList<>();
                    if(jsonObject.getInt("s")==1){
                        JSONArray jsonArray=jsonObject.getJSONArray("tickets");
                        for(int i=0;i<jsonArray.length();i++) {
                            selectticket.add(jsonArray.getJSONObject(i).getString("ticketnumber"));
                        }
                        ArrayAdapter<String> ticketsAdapter = new ArrayAdapter<String>(mycontext,
                                android.R.layout.simple_spinner_item, selectticket);
                        ticketsAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                        ticketspinner.setAdapter(ticketsAdapter);
                    }else{
                        ArrayAdapter<String> ticketsAdapter = new ArrayAdapter<String>(mycontext,
                                android.R.layout.simple_spinner_item, selectticket);
                        ticketsAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                        ticketspinner.setAdapter(ticketsAdapter);
                        Toast.makeText(mycontext,"No tickets found", Toast.LENGTH_LONG).show();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void insertExpense(){
        Map<String, String> params = new HashMap<>();
        params.put("companyname",registeredcompany);
        params.put("Assignedto", registeredemailid);
        params.put("companyname", registeredcompany);
        params.put("ticketnumber", selectedticketnumber);
        params.put("submittedby", registeredemailid);
        params.put("expensetype",selectedexpensetype);
        params.put("description", descriptiontext);
        params.put("distanceinkms", distancevalue);
        params.put("fromlocation", fromlocationtext);
        params.put("tolocation",tolocationtext );
        params.put("location", locationtext);
        params.put("claimamount", claimamountvalue);
        params.put("imagefilepath", picturefilename);
        params.put("image", imageinstring );
        params.put("dateandtime", Utility.getCurrentDateTime());

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.INSERT_EXPENSE, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        Toast.makeText(mycontext,"Successfully submitted.", Toast.LENGTH_LONG).show();
                        // finish();
                        NavUtils.navigateUpFromSameTask(addexpense.this);
                    }else{
                        Toast.makeText(mycontext,"Please Try Again", Toast.LENGTH_LONG).show();

                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }


}
