package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.DatePicker;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.b2lmobitech.fieldcloudplus.service.adapter.expenseadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

public class expense extends AppCompatActivity {
private Context mycontext;
    private FloatingActionButton fab,fab1,fab2;
    private Animation fab_open, fab_close, rotate_forward, rotate_backward;
    private Boolean isFabOpen = false;
    private TextView addexpensetext,addcalendartext,history;
    private ArrayList<String> date, description, type, amount;
    private ListView expenselistview;
    private String url_get_expenses="",registeredcompany,registeredemailid,selecteddate="0000-00-00", month,day;
    private int getsuccess =0,status=0;
    private  ProgressBar progressbar;
    private SwipeRefreshLayout swipeContainer;
    private Snackbar snackBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_expense);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        mycontext = this;
        fab = (FloatingActionButton) findViewById(R.id.fab);
        fab1 = (FloatingActionButton) findViewById(R.id.fab1);
        fab2 = (FloatingActionButton) findViewById(R.id.fab2);
        expenselistview = (ListView) findViewById(R.id.expenselistview);

        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        swipeContainer = (SwipeRefreshLayout) findViewById(R.id.swipeContainer);

        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
                animateFAB();
            }
        });

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        fab_open = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_open);
        fab_close = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.fab_close);
        rotate_forward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_forward);
        rotate_backward = AnimationUtils.loadAnimation(getApplicationContext(), R.anim.rotate_backward);
        addexpensetext = (TextView) findViewById(R.id.addexpensetext);
        addcalendartext = (TextView) findViewById(R.id.addcalendartext);
        history = (TextView) findViewById(R.id.history);
        progressbar = (ProgressBar) findViewById(R.id.expenseprogressBar);

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
        fab1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(mycontext, addexpense.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                mycontext.startActivity(intent);
            }
        });

        fab2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                final Calendar c = Calendar.getInstance();
                int mYear = c.get(Calendar.YEAR); // current year
                int mMonth = c.get(Calendar.MONTH); // current month
                int mDay = c.get(Calendar.DAY_OF_MONTH); // current day
                // date picker dialog
                DatePickerDialog datePickerDialog = new DatePickerDialog(mycontext,
                        new DatePickerDialog.OnDateSetListener() {

                            @Override
                            public void onDateSet(DatePicker view, int year,
                                                  int monthOfYear, int dayOfMonth) {
                                // set day of month , month and year value in the edit text
                                monthOfYear = monthOfYear+1;
                                if(monthOfYear < 10){
                                    month = "0" + monthOfYear;
                                }
                                else
                                {
                                    month = "" + monthOfYear;
                                }
                                if(dayOfMonth < 10){

                                    day  = "0" + dayOfMonth ;
                                }
                                else
                                {
                                    day  = "" + dayOfMonth ;
                                }
                                selecteddate = year+"-"+month+"-"+day;
                                if(isNetworkAvailable())
                                {
                                    getExpense();
                                }
                                else
                                {
                                   // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
                                    snackBar.dismiss();
                                    snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                                    toast();
                                }

                            }
                        }, mYear, mMonth, mDay);
                datePickerDialog.show();
            }
        });
        date = new ArrayList<String>();
        description  = new ArrayList<String>();
        type  = new ArrayList<String>();
        amount  = new ArrayList<String>();


        if(isNetworkAvailable()){
            history.setVisibility(View.GONE);
            getExpense();
        }else{
            history.setVisibility(View.VISIBLE);
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }

        swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {

                if(isNetworkAvailable()) {
                    selecteddate="0000-00-00";
                    getExpense();
                }else{
                   // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }
                swipeContainer.setRefreshing(false);

            }
        });
    }

    public void animateFAB() {

        if (isFabOpen) {

            fab.startAnimation(rotate_backward);
            fab1.startAnimation(fab_close);
            fab2.startAnimation(fab_close);
            addexpensetext.setVisibility(View.GONE);
            addcalendartext.setVisibility(View.GONE);
            fab1.setClickable(false);
            fab2.setClickable(false);
            isFabOpen = false;


        } else {

            fab.startAnimation(rotate_forward);
            fab1.startAnimation(fab_open);
            fab2.startAnimation(fab_open);
            addexpensetext.setVisibility(View.VISIBLE);
            addcalendartext.setVisibility(View.VISIBLE);
            fab1.setClickable(true);
            fab2.setClickable(true);
            isFabOpen = true;


        }
    }

    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    private void getExpense(){
        Map<String, String> params = new HashMap<>();
        params.put("companyname",registeredcompany);
        params.put("submittedby", registeredemailid);
        params.put("dateandtime", selecteddate);

        MyRequestQueue myRequestQueue=MyRequestQueue.getInstance(this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue(SERVICEURL.GET_EXPENSELSIT, params, new MyRequestFinishedListener() {
            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject=new JSONObject(response);
                    if(jsonObject.getInt("s")==1){
                        setAdapter(jsonObject.getJSONArray("expense"));
                    }else{
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content),  "No list found", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAdapter(JSONArray jsonArray) throws JSONException {
        date.clear();
        description.clear();
        type.clear();
        amount.clear();

        int	countval = jsonArray.length();
        for(int i=0;i<countval;i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            date.add(jsonObject.getString("dateandtime"));
            description.add(jsonObject.getString("description"));
            type.add(jsonObject.getString("expensetype"));
            amount.add(jsonObject.getString("claimamount"));
        }
        Parcelable parcelable=expenselistview.onSaveInstanceState();
        expenseadapter adapter = new expenseadapter(mycontext, date, description, type, amount,jsonArray);
        expenselistview.setAdapter(adapter);
        if(parcelable!=null){
            expenselistview.onRestoreInstanceState(parcelable);
        }
    }

    private void toast(){
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

}
