package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.json.JSONException;
import org.json.JSONObject;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL;
import com.bumptech.glide.Glide;

public class showexpense extends AppCompatActivity {
private String expensetype,expensedate,registeredcompany,registeredemailid,url_get_expenses="";
    private String ticketnumbervalue="",descriptionvalue="",distancevalue="",amountvalue="",fromvalue="",tovalue="",locationvalue="";
    private  EditText description,distance,amount,from,to,location;
    private TextView expense,ticketnumber;
    private TextView descriptiontext,distancetext,amounttext,fromlocationtext,tolocationtext,locationtext,imagetext;
    private  ImageView snapshot;
    private Context mycontext;
    private int status=0,getsuccess=0;
    private  ProgressBar progressbar;
    private Bitmap imagebitmap;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_showexpense);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
         getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        mycontext = this;
        expensetype = getIntent().getExtras().getString("type","");
        expensedate = getIntent().getExtras().getString("date","");
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        expense = (TextView) findViewById(R.id.expensetype);
        ticketnumber = (TextView) findViewById(R.id.ticketnumber);
        description = (EditText) findViewById(R.id.description);
        distance = (EditText) findViewById(R.id.distance);
        amount = (EditText) findViewById(R.id.amount);
        from = (EditText) findViewById(R.id.from);
        to = (EditText) findViewById(R.id.to);
        location = (EditText) findViewById(R.id.location);
        snapshot = (ImageView) findViewById(R.id.snapshot);
        progressbar = (ProgressBar) findViewById(R.id.expenseprogressBar);
        descriptiontext  = (TextView) findViewById(R.id.descriptiontext);
        distancetext  = (TextView) findViewById(R.id.distancetext);
        amounttext  = (TextView) findViewById(R.id.Amounttext);
        fromlocationtext  = (TextView) findViewById(R.id.fromlocationtext);
        tolocationtext  = (TextView) findViewById(R.id.tolocationtext);
        locationtext  = (TextView) findViewById(R.id.locationtext);
        imagetext  = (TextView) findViewById(R.id.imagetext);
        expense.setText(expensetype);
        if(expensetype.equalsIgnoreCase("Daily"))
        {
            ticketnumber.setVisibility(View.GONE);
            distancetext.setVisibility(View.GONE);
            distance.setVisibility(View.GONE);
            fromlocationtext.setVisibility(View.GONE);
            from.setVisibility(View.GONE);
            tolocationtext.setVisibility(View.GONE);
            to.setVisibility(View.GONE);
            locationtext.setVisibility(View.VISIBLE);
            location.setVisibility(View.VISIBLE);
        }
        else if(expensetype.equalsIgnoreCase("Travel"))
        {
            ticketnumber.setVisibility(View.VISIBLE);
            distancetext.setVisibility(View.VISIBLE);
            distance.setVisibility(View.VISIBLE);
            fromlocationtext.setVisibility(View.VISIBLE);
            from.setVisibility(View.VISIBLE);
            tolocationtext.setVisibility(View.VISIBLE);
            to.setVisibility(View.VISIBLE);
            locationtext.setVisibility(View.GONE);
            location.setVisibility(View.GONE);
        }

        try {
            JSONObject jsonObject=new JSONObject(getIntent().getExtras().getString("json"));
            setDetails(jsonObject);
        } catch (JSONException e) {
            e.printStackTrace();
        }


    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.showexpense, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        // int id = item.getItemId();

        //noinspection SimplifiableIfStatement
//        if (id == an) {
//
//        }
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;

        }
        return  true;
        //return super.onOptionsItemSelected(item);
    }

    public  boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }


    private void setDetails(JSONObject jsonObject) throws JSONException {
        ticketnumbervalue=jsonObject.getString("ticketnumber");
        descriptionvalue=jsonObject.getString("description");
        distancevalue=jsonObject.getString("distanceinkms");
        amountvalue=jsonObject.getString("claimamount");
        fromvalue=jsonObject.getString("fromlocation");
        tovalue=jsonObject.getString("tolocation");
        locationvalue=jsonObject.getString("location");

        ticketnumber.setText(ticketnumbervalue);
        description.setText(descriptionvalue);
        distance.setText(distancevalue);
        amount.setText(amountvalue);
        from.setText(fromvalue);
        to.setText(tovalue);
        location.setText(locationvalue);

        Glide.with(this)
                .load(SERVICEURL.EXPENSE_IMAGE+jsonObject.getString("imagefilepath"))
                .into(snapshot);

      /*  imagebitmap=globalvariables.StringToBitMap(product2.getString("image"));
        if(imagebitmap!=null) {
            imagetext.setVisibility(View.VISIBLE);
            snapshot.setVisibility(View.VISIBLE);
            snapshot.setImageBitmap(imagebitmap);

        }else{
            imagetext.setVisibility(View.GONE);
            snapshot.setVisibility(View.GONE);
        }*/


    }

}
