package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.graphics.Color;
import androidx.recyclerview.widget.RecyclerView;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormResponsesTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class CategoryAdapter extends  RecyclerView.Adapter<CategoryAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public CategoryAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        database=ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            Log.d("category adapter",jsonObject.toString());
            holder.textView.setText(database.getQCatName(jsonObject.getString(FlexibleFormResponsesTable.CATEGORY)));
            if(jsonObject.getBoolean("isCompleted")){
                holder.completedText.setText("Completed");
                holder.completedText.setVisibility(View.VISIBLE);
                holder.completedText.setTextColor(context.getResources().getColor(R.color.list_color4));
            }else if(jsonObject.getString(FlexibleFormResponsesTable.SYNCED).equals("0")){
                holder.completedText.setText("Offline");
                holder.completedText.setTextColor(Color.RED);
            }else{
                holder.completedText.setVisibility(View.GONE);
            }
        } catch (JSONException e) {
            e.printStackTrace();
            holder.completedText.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_category, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView textView,completedText;
        public viewHolder(final View itemView) {
            super(itemView);
            textView=itemView.findViewById(R.id.textView);
            completedText=itemView.findViewById(R.id.completedText);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }

}
