package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import androidx.appcompat.widget.PopupMenu;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.listener.PreventiveListener;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FacilityTable;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import static com.b2lmobitech.fieldcloudplus.service.sql.tables.FacilityTable.*;

/**
 * Created by home on 10/31/2017.
 */

public class PreventiveAdapter extends  RecyclerView.Adapter<PreventiveAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private Database database;
    private OnItemClickListener itemClickListener;
    private PreventiveListener preventiveListener;

    public PreventiveAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        preventiveListener= (PreventiveListener) context;
        database=Database.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.text1.setText(String.format("%s (%s)",jsonObject.getString(AssignTable.CUSTOMERNAME), jsonObject.getString(FacilityTable.FACILITYID)));
            holder.text2.setText(jsonObject.getString(ADDRESS));
            holder.text3.setText(String.format("%s \u2022 %s", jsonObject.getString(AssignTable.ASSIGNDATE), jsonObject.getString(AssignTable.CUSTMERTYPE)));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_preventive, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3;
        ImageView moreImage;

        public viewHolder(final View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            text3=itemView.findViewById(R.id.text3);
            moreImage=itemView.findViewById(R.id.moreImage);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });

            moreImage.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    PopupMenu popup = new PopupMenu(context,moreImage);
                    MenuInflater inflater = popup.getMenuInflater();
                    inflater.inflate(R.menu.preventive_popup, popup.getMenu());
                    popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
                        @Override
                        public boolean onMenuItemClick(MenuItem item) {
                            switch (item.getItemId()) {
                                case R.id.call:
                                    preventiveListener.callCustomer(getAdapterPosition());
                                    break;
                                case R.id.openMap:
                                    preventiveListener.openMap(getAdapterPosition());
                                    break;
                                default:
                                    return false;
                            }
                            return false;
                        }
                    });
                    //displaying the popup
                    popup.show();
                }
            });
        }
    }


}
