package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class ProductCombinationAdapter extends  RecyclerView.Adapter<ProductCombinationAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public ProductCombinationAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        database=ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }


    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            if(!database.getProduct(jsonObject.getString(AssignTable.PRODUCT)).isEmpty()){
                holder.text1.setText(database.getProduct(jsonObject.getString(AssignTable.PRODUCT)));
            }else{
                holder.layout1.setVisibility(View.GONE);
            }
            if(!database.getBrand(jsonObject.getString(AssignTable.BRAND)).isEmpty()){
                holder.text2.setText(database.getBrand(jsonObject.getString(AssignTable.BRAND)));
            }else{
                holder.layout2.setVisibility(View.GONE);
            }
            if(!database.getModel(jsonObject.getString(AssignTable.MODEL)).isEmpty()){
                holder.text3.setText(database.getModel(jsonObject.getString(AssignTable.MODEL)));
            }else{
                holder.layout3.setVisibility(View.GONE);
            }
            if(!database.getSerialNumber(jsonObject.getString(AssignTable.SERIAL)).isEmpty()){
                holder.text4.setText(database.getSerialNumber(jsonObject.getString(AssignTable.SERIAL)));
            }else{
                holder.layout4.setVisibility(View.GONE);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_product_combination, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3,text4;
        LinearLayout layout4,layout3,layout2,layout1;
        public viewHolder(final View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            text3=itemView.findViewById(R.id.text3);
            text4=itemView.findViewById(R.id.text4);
            layout4=itemView.findViewById(R.id.layout4);
            layout3=itemView.findViewById(R.id.layout3);
            layout2=itemView.findViewById(R.id.layout2);
            layout1=itemView.findViewById(R.id.layout1);


            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }


}
