package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;

import com.b2lmobitech.fieldcloudplus.R;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RankingAdapter extends RecyclerView.Adapter<RankingAdapter.ViewHolder> {

    private final List<String> optionIds;
    private final List<String> optionTexts;
    private final OnRankingChangedListener listener;

    public interface OnRankingChangedListener {
        void onRankingChanged(List<String> updatedIds);
    }

    public RankingAdapter(List<String> optionIds, List<String> optionTexts, OnRankingChangedListener listener) {
        this.optionIds = new ArrayList<>(optionIds);
        this.optionTexts = new ArrayList<>(optionTexts);
        this.listener = listener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item_ranking, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.textView.setText(optionTexts.get(position));
    }

    @Override
    public int getItemCount() {
        return optionTexts.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        TextView textView;
        ImageView dragHandle;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            textView = itemView.findViewById(R.id.text_option);
            dragHandle = itemView.findViewById(R.id.drag_handle);
        }
    }

    // ItemTouchHelper Callback
    public final ItemTouchHelper.Callback itemTouchHelperCallback =
            new ItemTouchHelper.SimpleCallback(ItemTouchHelper.UP | ItemTouchHelper.DOWN, 0) {

                @Override
                public boolean onMove(@NonNull RecyclerView recyclerView,
                                      @NonNull RecyclerView.ViewHolder viewHolder,
                                      @NonNull RecyclerView.ViewHolder target) {

                    int fromPos = viewHolder.getAdapterPosition();
                    int toPos = target.getAdapterPosition();

                    // Swap items
                    Collections.swap(optionIds, fromPos, toPos);
                    Collections.swap(optionTexts, fromPos, toPos);
                    notifyItemMoved(fromPos, toPos);

                    if (listener != null) {
                        listener.onRankingChanged(optionIds);
                    }
                    return true;
                }

                @Override
                public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
                    // no swipe
                }

                @Override
                public boolean isLongPressDragEnabled() {
                    return true; // drag starts on long press
                }
            };
}
