package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.CombinationTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class ServiceCombinationAdapter extends  RecyclerView.Adapter<ServiceCombinationAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public ServiceCombinationAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        database=ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            if(!database.getServiceTypeName(jsonObject.getString(CombinationTable.SERVICETYPE)).isEmpty()) {
                holder.text3.setText(database.getServiceTypeName(jsonObject.getString(CombinationTable.SERVICETYPE)));
            }else{
                holder.layout3.setVisibility(View.GONE);
            }
            holder.text1.setText(database.getCategoryName(jsonObject.getString(CombinationTable.CAT)));
            if(!database.getSubCategoryName(jsonObject.getString(CombinationTable.SUBCAT)).isEmpty()) {
                holder.text2.setText(database.getSubCategoryName(jsonObject.getString(CombinationTable.SUBCAT)));
            }else{
                holder.layout2.setVisibility(View.GONE);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_service_combination, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3;
        LinearLayout layout3,layout2;
        public viewHolder(final View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            text3=itemView.findViewById(R.id.text3);
            layout3=itemView.findViewById(R.id.layout3);
            layout2=itemView.findViewById(R.id.layout2);
            setIsRecyclable(false);

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }

}
