package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

/**
 * Created by home on 10/31/2017.
 */

public class SpareAdapter extends  RecyclerView.Adapter<SpareAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private OnItemClickListener itemClickListener;
    ArrayList<JSONObject> arrayList=new ArrayList<>();

    public SpareAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        try {
            arrayList= JSONUtils.fromJSONArray(jsonArray);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public SpareAdapter(Context context, ArrayList<JSONObject> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        itemClickListener= (OnItemClickListener) context;
    }

    public JSONArray getJsonArray() {
        JSONArray jsonArray=new JSONArray();
        for(JSONObject jsonObject:arrayList){
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=arrayList.get(holder.getAdapterPosition());
            holder.text1.setText(jsonObject.getString("name"));
            holder.text2.setText(jsonObject.getString("unit"));
            holder.text3.setText(jsonObject.getString("total"));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_spare, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3;

        public viewHolder(final View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            text3=itemView.findViewById(R.id.text3);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }

    public void removeItem(int position) {
        arrayList.remove(position);
        notifyItemRemoved(position);
    }

    public void restoreItem(JSONObject jsonObject, int position) {
        arrayList.add(position, jsonObject);
        notifyItemInserted(position);
    }

}
