package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QuestionTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class SubCategoryAdapter extends  RecyclerView.Adapter<SubCategoryAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public SubCategoryAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        database=ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.textView.setText(database.getQSubCatName(jsonObject.getString(QuestionTable.SUBCAT)));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_category, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView textView;
        public viewHolder(final View itemView) {
            super(itemView);
            textView=itemView.findViewById(R.id.textView);


            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }

}
