package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.core.app.ActivityCompat;
import androidx.appcompat.widget.PopupMenu;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FacilityTable;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class TicketAdapter extends  RecyclerView.Adapter<TicketAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private Database database;
    private OnItemClickListener itemClickListener;

    public TicketAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        database=Database.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.text1.setText(String.format("%s (%s)", jsonObject.getString("customername"), jsonObject.getString("companyname")));
            holder.text2.setText(jsonObject.getString("location"));
            holder.text3.setText(jsonObject.getString("assigneddateandtime"));
            holder.text4.setText(jsonObject.getString("priority"));
            if(jsonObject.getString("ticketstatus").equals("assigned")){
                holder.newIcon.setVisibility(View.VISIBLE);
            }else{
                holder.newIcon.setVisibility(View.INVISIBLE);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_ticket, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3,text4;
        ImageView moreImage,newIcon;

        public viewHolder(final View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            text3=itemView.findViewById(R.id.text3);
            text4=itemView.findViewById(R.id.text4);
            newIcon=itemView.findViewById(R.id.newIcon);
            moreImage=itemView.findViewById(R.id.moreImage);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
            moreImage.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    PopupMenu popup = new PopupMenu(context,moreImage);
                    MenuInflater inflater = popup.getMenuInflater();
                    inflater.inflate(R.menu.preventive_popup, popup.getMenu());
                    popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
                        @Override
                        public boolean onMenuItemClick(MenuItem item) {
                            switch (item.getItemId()) {
                                case R.id.call:
                                   callCustomer(getAdapterPosition());
                                    break;
                                case R.id.openMap:
                                   openMap(getAdapterPosition());
                                    break;
                                default:
                                    return false;
                            }
                            return false;
                        }
                    });
                    //displaying the popup
                    popup.show();
                }
            });

        }
    }

    private void callCustomer(int position){
        try {
            JSONObject jsonObject = getJsonArray().getJSONObject(position);
            if (ActivityCompat.checkSelfPermission(context, Manifest.permission.CALL_PHONE) !=
                    PackageManager.PERMISSION_GRANTED) {
                return;
            }
            context.startActivity(new Intent(Intent.ACTION_CALL, Uri.parse("tel:" + jsonObject.getString(FacilityTable.MOBILE))));

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void openMap(int position){
        try {
            JSONObject jsonObject = getJsonArray().getJSONObject(position);
            Uri gmmIntentUri = Uri.parse("geo:"+jsonObject.getString("latitude")+","
                    +jsonObject.getString("longitude")
                    +"?q="+jsonObject.getString("latitude")+","
                    +jsonObject.getString("longitude"));
            Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
            mapIntent.setPackage("com.google.android.apps.maps");
            context.startActivity(mapIntent);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }


}
