package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.service.listener.OnBottomReachedListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

/**
 * Created by home on 10/31/2017.
 */

public class TicketHistoryAdapter extends  RecyclerView.Adapter<TicketHistoryAdapter.viewHolder>{

    private Context context;
    private JSONArray jsonArray;
    private Database database;
    private OnItemClickListener itemClickListener;
    private OnBottomReachedListener onBottomReachedListener;


    public TicketHistoryAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        itemClickListener= (OnItemClickListener) context;
        onBottomReachedListener= (OnBottomReachedListener) context;
        database=Database.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.text1.setText(String.format("%s (%s)", jsonObject.getString("customername"), jsonObject.getString("companyname")));
            holder.text2.setText(jsonObject.getString("location"));
            holder.text3.setText(jsonObject.getString("ticketstatus"));
            holder.text4.setText(DateUtils.getNormalDate(jsonObject.getString("assigneddateandtime")));
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if(holder.getAdapterPosition()==jsonArray.length()-1){
            onBottomReachedListener.onBottomReached(holder.getAdapterPosition());
        }
    }

    public void addToArray(int startposition,JSONArray jsonArray){
        try {
            for(int i=0; i<jsonArray.length(); i++){
                this.jsonArray.put(jsonArray.getJSONObject(i));
            }
            notifyItemRangeInserted(startposition,jsonArray.length());
            notifyDataSetChanged();
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_ticket_history, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView text1,text2,text3,text4;
        ImageView moreImage,newIcon;

        public viewHolder(final View itemView) {
            super(itemView);
            text1=itemView.findViewById(R.id.text1);
            text2=itemView.findViewById(R.id.text2);
            text3=itemView.findViewById(R.id.text4);
            text4=itemView.findViewById(R.id.text3);
            newIcon=itemView.findViewById(R.id.newIcon);
            newIcon.setVisibility(View.GONE);
            moreImage=itemView.findViewById(R.id.moreImage);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    itemClickListener.itemClicked(getAdapterPosition());
                }
            });
            moreImage.setVisibility(View.GONE);

        }
    }




}
