package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.service.activities.showexpense;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;

/**
 * Created by HP on 30-01-2017.
 */

public class expenseadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> date, description, type, amount;
    private JSONArray jsonArray;

    public expenseadapter(Context context, ArrayList<String> date, ArrayList<String> description, ArrayList<String> type, ArrayList<String> amount) {
        super(context, R.layout.custom_expense, date);
        this.mycontext = context;
        this.date = date;
        this.description = description;
        this.type = type;
        this.amount = amount;
    }

    public expenseadapter(Context context, ArrayList<String> date, ArrayList<String> description, ArrayList<String> type, ArrayList<String> amount, JSONArray jsonArray){
        super(context, R.layout.custom_expense, date);
        this.mycontext = context;
        this.date = date;
        this.description = description;
        this.type = type;
        this.amount = amount;
        this.jsonArray=jsonArray;
    }


    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_expense, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.datevalue = (TextView) convertView.findViewById(R.id.datevalue);
            myholder.descriptionvalue = (TextView) convertView.findViewById(R.id.descriptionvalue);
            myholder.typevalue = (TextView) convertView.findViewById(R.id.typevalue);
            myholder.amountvalue = (TextView) convertView.findViewById(R.id.amountvalue);
            convertView.setTag(myholder);
            convertView.setBackgroundColor(position % 2 == 0 ? Color.WHITE : Color.parseColor("#FEFCFF"));

        } else {
            myholder = (holder) convertView.getTag();

        }

        myholder.datevalue.setText(date.get(position).split(" ")[0]);
        myholder.descriptionvalue.setText(description.get(position));
        myholder.typevalue.setText(type.get(position));
        myholder.amountvalue.setText(amount.get(position));

        final  RelativeLayout listlayout = (RelativeLayout) convertView.findViewById(R.id.custom_expense);
        listlayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(mycontext, showexpense.class);
                Bundle extras = new Bundle();
                extras.putString("date",date.get(position));
                extras.putString("type", type.get(position));
                try {
                    extras.putString("json",jsonArray.getJSONObject(position).toString());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                intent.putExtras(extras);
                mycontext.startActivity(intent);
            }
        });
        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {

        TextView datevalue, descriptionvalue, typevalue, amountvalue;


    }
}
