package com.b2lmobitech.fieldcloudplus.service.others

import okhttp3.MultipartBody
import retrofit2.http.Multipart
import retrofit2.http.POST
import retrofit2.http.Part
import retrofit2.Call

interface ApiService {
    @Multipart
    @POST("fileupload.php")
    fun uploadFiles(@Part files: List<MultipartBody.Part>): Call<List<UploadResponse>>

    @Multipart
    @POST("signatureupload.php")
    fun uploadSignature(
        @Part parts: List<MultipartBody.Part>
    ): Call<List<UploadResponse>>
}

data class UploadResponse(
    val status: String,
    val file: String?,
    val message: String?
)

