package com.b2lmobitech.fieldcloudplus.service.others

import org.json.JSONObject

object FormAnswerManager {

    val formAnswers = mutableMapOf<String, JSONObject>()

    fun saveAnswer(sectionName: String,sectionId: String, questionId: String, jsonObject: JSONObject) {
        val sectionJson = formAnswers.getOrPut(sectionId) {
            JSONObject().apply {
                put("filled", true)
                put("sectionId", sectionId)
            }
        }

        var questionObj = JSONObject()
        questionObj = jsonObject

        sectionJson.put(questionId, questionObj)
        formAnswers[sectionName] = sectionJson
    }

    fun getFormJson(): JSONObject = JSONObject(formAnswers as Map<*, *>)
}
