package com.b2lmobitech.fieldcloudplus.service.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AnswerTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.BrandTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.CategoryTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.CombinationTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FacilityTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormOptionsTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormQuestionsTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormResponsesDataTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormResponsesTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FlexibleFormSectionsTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.ModelTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.ProductTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QCategoryTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QSubCatTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QuestionTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.SerialTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.TicketTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.TypeTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

public class ServiceDatabase {

    private static ServiceDatabase mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;
    private static SqliteHelper sqliteHelper;

    private ServiceDatabase(Context context){
        // Specify the application context
        mContext = context;
        // Get the request queue
        sqliteHelper=new SqliteHelper(context);
    }

    public static synchronized ServiceDatabase getInstance(Context context){
        // If Instance is null then initialize new Instance
        if(mInstance == null){
            mInstance = new ServiceDatabase(context);
        }
        // Return MySingleton new Instance
        createTables();
        return mInstance;

    }

    public static void createTables(){
        SQLiteDatabase db = sqliteHelper.getWritableDatabase();
        try {
            db.execSQL(QuestionTable.CREATE_TABLE);
            db.execSQL(QSubCatTable.CREATE_TABLE);
            db.execSQL(QCategoryTable.CREATE_TABLE);
            db.execSQL(FlexibleFormQuestionsTable.CREATE_TABLE);
            db.execSQL(FlexibleFormSectionsTable.CREATE_TABLE);
            db.execSQL(FlexibleFormOptionsTable.CREATE_TABLE);
            db.execSQL(FlexibleFormResponsesTable.CREATE_TABLE);
            db.execSQL(FlexibleFormResponsesDataTable.CREATE_TABLE);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void insertIntoTable(JSONArray jsonArray,String Table) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = JSONUtils.jsonToValues(jsonObject);
            sdb.insertWithOnConflict(Table,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertIntoTable(JSONObject jsonObject,String Table) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        ContentValues cv = JSONUtils.jsonToValues(jsonObject);
        sdb.insertWithOnConflict(Table,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        sdb.close();
    }

    public JSONArray getPreventive(){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ AssignTable.TABLENAME +
                " INNER JOIN " + FacilityTable.TABLENAME +" ON "+FacilityTable.ID+"="+AssignTable.FACILITY+
                " WHERE "+AssignTable.STATUS+"!='completed'"+
                " GROUP BY "+FacilityTable.FACILITYID+","+AssignTable.ASSIGNDATE+
                " ORDER BY "+AssignTable.ASSIGNDATE +" DESC";
        Cursor cursor = sdb.rawQuery(query,null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONArray getTickets(){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TicketTable.TABLENAME +
/*
                " WHERE "+TicketTable.STATUS+"!='Complete'"+
*/
                " ORDER BY "+TicketTable.ASSIGNEDDT +" DESC";
        Cursor cursor = sdb.rawQuery(query,null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONObject getTicketInfo(String ticket) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TicketTable.TABLENAME +
                " WHERE "+TicketTable.TICKETNUMBER+"='"+ticket+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if(cursor!=null && cursor.moveToFirst()) {
            return JSONUtils.cursorToJson(cursor);
        }
        return null;
    }

    public String getCategoryName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ CategoryTable.TABLENAME +" WHERE "+
                CategoryTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(CategoryTable.CATEGORY));
            }
            cursor.close();
        }
        return "";
    }

    public String getQCatName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ QCategoryTable.TABLENAME +" WHERE "+
                QCategoryTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(QCategoryTable.CATEGORY));
            }
            cursor.close();
        }
        return "";
    }

    public String getQSubCatName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ QSubCatTable.TABLENAME +" WHERE "+
                QSubCatTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(QSubCatTable.SUBCAT));
            }
            cursor.close();
        }
        return "General";
    }

    public String getServiceTypeName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TypeTable.TABLENAME +" WHERE "+
                TypeTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(TypeTable.TYPE));
            }
            cursor.close();
        }
        return "";
    }

    public String getSerialNumber(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ SerialTable.TABLENAME +" WHERE "+
                SerialTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(SerialTable.SERIALNUMBER));
            }
            cursor.close();
        }
        return "";
    }

    public String getModel(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ ModelTable.TABLENAME +" WHERE "+
                ModelTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(ModelTable.MODEL));
            }
            cursor.close();
        }
        return "";
    }

    public String getCustomerMobile(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ FacilityTable.TABLENAME +" WHERE "+
                FacilityTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(FacilityTable.MOBILE));
            }
            cursor.close();
        }
        return "";
    }

    public String getProduct(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ ProductTable.TABLENAME +" WHERE "+
                ProductTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(ProductTable.PRODUCT));
            }
            cursor.close();
        }
        return "";
    }

    public String getBrand(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ BrandTable.TABLENAME +" WHERE "+
                BrandTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(BrandTable.BARND));
            }
            cursor.close();
        }
        return "";
    }

    public String getSubCategoryName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ QSubCatTable.TABLENAME +" WHERE "+ QSubCatTable.ID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(QSubCatTable.SUBCAT));
            }
            cursor.close();
        }
        return "General";
    }

    public JSONArray getCombinations(String facility,String date){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ AssignTable.TABLENAME +
                " INNER JOIN " + CombinationTable.TABLENAME +" ON "+AssignTable.COMBINATION+"="+CombinationTable.ID+
                " WHERE "+AssignTable.ASSIGNDATE+"='"+date+"' AND " + AssignTable.FACILITY+"='"+facility+"' AND "+
                AssignTable.STATUS+"!='completed' " +
                " GROUP BY "+AssignTable.COMBINATION;
        Cursor cursor = sdb.rawQuery(query,null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONArray getQuestionsCategory(String assignId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT *,(CASE WHEN (flexible_form_responses.question_id IS NULL OR flexible_form_responses.sync='0') THEN 'false' ELSE 'true' END) AS isCompleted" +
                ",(CASE WHEN flexible_form_responses.sync='0' THEN 'true' ELSE 'false' END) AS inOffline FROM "+
                CombinationTable.TABLENAME +
                " INNER JOIN " + QuestionTable.TABLENAME +" ON "+QuestionTable.TABLENAME+"."+QuestionTable.NAME+"=combination."+CombinationTable.ID+
                " LEFT JOIN " +AssignTable.TABLENAME +" ON "+AssignTable.COMBINATION+"=combination."+CombinationTable.ID+
                " LEFT JOIN "+FlexibleFormResponsesTable.TABLENAME +" ON flexible_form_responses."+FlexibleFormResponsesTable.ASSIGNMENT_ID+"=scheduleassign."+AssignTable.ASSIGNID +
                " AND "+FlexibleFormResponsesTable.PREVIEW+"='0' AND flexible_form_responses."+FlexibleFormResponsesTable.CATEGORY+"=questions."+QuestionTable.CATEGORY+
                " WHERE scheduleassign."+ AssignTable.ASSIGNID+"='"+assignId+"'"+
                " GROUP BY questions."+QuestionTable.CATEGORY;
        Cursor cursor = sdb.rawQuery(query,null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONArray getSubCategories(String facility,String date,String cat,String assignid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ CombinationTable.TABLENAME +
                " INNER JOIN " + QuestionTable.TABLENAME +" ON "+QuestionTable.TABLENAME+"."+QuestionTable.NAME+"="+CombinationTable.TABLENAME+"."+CombinationTable.ID+
                " INNER JOIN " +AssignTable.TABLENAME +" ON "+AssignTable.COMBINATION+"="+CombinationTable.TABLENAME+"."+CombinationTable.ID+
                " WHERE "+ AssignTable.ASSIGNDATE+"='"+date+"' AND " + AssignTable.FACILITY+"='"+facility+"'"+
                " AND "+QuestionTable.CATEGORY+"='"+cat+"' AND " +AssignTable.ASSIGNID+"='"+assignid+"' "+
                " GROUP BY "+QuestionTable.SUBCAT;
        Cursor cursor = sdb.rawQuery(query,null);
        return JSONUtils.cursorToArray(cursor);
    }

    public List<DbSection> getSections(String formId) {
        List<DbSection> sections = new ArrayList<>();
        SQLiteDatabase db = sqliteHelper.getReadableDatabase();

        String query = "SELECT section_id, section_name FROM " + FlexibleFormSectionsTable.TABLENAME +
                " WHERE form_id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{formId});

        if (cursor != null) {
            while (cursor.moveToNext()) {
                String id = cursor.getString(cursor.getColumnIndexOrThrow("section_id"));
                String name = cursor.getString(cursor.getColumnIndexOrThrow("section_name"));
                sections.add(new DbSection(id, name));
            }
            cursor.close();
        }

        return sections;
    }

//    public JSONArray getQuestions(String facility,String date,String cat,String subcat,String assignid){
//        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
//        String query="SELECT * FROM "+ CombinationTable.TABLENAME +
//                " INNER JOIN " + QuestionTable.TABLENAME +" ON "+QuestionTable.TABLENAME+"."+QuestionTable.NAME+"="+CombinationTable.TABLENAME+"."+CombinationTable.ID+
//                " INNER JOIN " +AssignTable.TABLENAME +" ON "+AssignTable.COMBINATION+"="+CombinationTable.TABLENAME+"."+CombinationTable.ID+
//                " WHERE "+ AssignTable.ASSIGNDATE+"='"+date+"' AND " + AssignTable.FACILITY+"='"+facility+"'"+
//                " AND "+QuestionTable.CATEGORY+"='"+cat+"' AND "+QuestionTable.SUBCAT+"='"+subcat+"' AND " +AssignTable.ASSIGNID+"='"+assignid+"' ";
//        Cursor cursor = sdb.rawQuery(query,null);
//        return JSONUtils.cursorToArray(cursor);
//    }

    public JSONArray getQuestions(String facility, String date, String cat, String assignid, @Nullable String sectionId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();

        // Build base query with joins you already had
        String baseQuery = "SELECT fq.* FROM " + CombinationTable.TABLENAME + " c " +
                " INNER JOIN " + QuestionTable.TABLENAME + " q ON q." + QuestionTable.NAME + " = c." + CombinationTable.ID +
                " INNER JOIN " + AssignTable.TABLENAME + " a ON a." + AssignTable.COMBINATION + " = c." + CombinationTable.ID +
                " INNER JOIN " + FlexibleFormQuestionsTable.TABLENAME + " fq ON fq.form_id = q." + QuestionTable.FORM_ID +
                " WHERE a." + AssignTable.ASSIGNDATE + " = ?" +
                " AND a." + AssignTable.FACILITY + " = ?" +
                " AND q." + QuestionTable.CATEGORY + " = ?" +
                " AND a." + AssignTable.ASSIGNID + " = ?";

        // If sectionId is provided, filter by it
        String[] args;
        if (sectionId != null) {
            baseQuery += " AND fq.section_id = ?";
            args = new String[]{date, facility, cat, assignid, sectionId};
        } else {
            args = new String[]{date, facility, cat, assignid};
        }

        Cursor cursor = sdb.rawQuery(baseQuery, args);
        JSONArray result = JSONUtils.cursorToArray(cursor);
        cursor.close();
        return result;
    }



    public JSONObject getAnswers(String assignid,String cat,String subcat){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ AnswerTable.TABLENAME +
                " WHERE "+ AnswerTable.ASSIGNID+"='"+assignid+"' AND "+AnswerTable.CATEGORY+"='"+cat+"' AND "+AnswerTable.SUBCAT+"='"+subcat+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        JSONObject jsonObject=new JSONObject();
        if(cursor.moveToFirst()){
            do{
                try {
                    JSONObject jsonObject1=new JSONObject();
                    jsonObject1.put("answer",cursor.getString(cursor.getColumnIndex(AnswerTable.ANSWER)));
                    jsonObject1.put("issue",cursor.getString(cursor.getColumnIndex(AnswerTable.ISSUE)));
                    jsonObject1.put("remarks",cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS)));
                    jsonObject.put(cursor.getString(cursor.getColumnIndex(AnswerTable.NUMBER)),jsonObject1);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }while (cursor.moveToNext());
        }
        return jsonObject;
    }

    public JSONArray getOptions(String facility, String date, String cat, String assignid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();

        // Build base query with joins you already had
        String baseQuery = "SELECT fo.* FROM " + CombinationTable.TABLENAME + " c " +
                " INNER JOIN " + QuestionTable.TABLENAME + " q ON q." + QuestionTable.NAME + " = c." + CombinationTable.ID +
                " INNER JOIN " + AssignTable.TABLENAME + " a ON a." + AssignTable.COMBINATION + " = c." + CombinationTable.ID +
                " INNER JOIN " + FlexibleFormOptionsTable.TABLENAME + " fo ON fo.form_id = q." + QuestionTable.FORM_ID +
                " WHERE a." + AssignTable.ASSIGNDATE + " = ?" +
                " AND a." + AssignTable.FACILITY + " = ?" +
                " AND q." + QuestionTable.CATEGORY + " = ?" +
                " AND a." + AssignTable.ASSIGNID + " = ?";

        // If sectionId is provided, filter by it
        String[] args;
        args = new String[]{date, facility, cat, assignid};

        Cursor cursor = sdb.rawQuery(baseQuery, args);
        JSONArray result = JSONUtils.cursorToArray(cursor);
        cursor.close();
        return result;
    }

    public JSONObject getAnswers(String assignId,String catId) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ FlexibleFormResponsesTable.TABLENAME +
                " WHERE "+ FlexibleFormResponsesTable.ASSIGNMENT_ID+"='"+assignId+"' AND "+FlexibleFormResponsesTable.CATEGORY+"='"+catId+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        JSONObject jsonObject=new JSONObject();
        JSONArray jsonArray=new JSONArray();
        if(cursor.moveToFirst()){
            jsonObject.put("assign",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ASSIGNMENT_ID)));
            jsonObject.put("lat",cursor.getString(cursor.getColumnIndex(AnswerTable.LAT)));
            jsonObject.put("lon",cursor.getString(cursor.getColumnIndex(AnswerTable.LON)));
            jsonObject.put("location",cursor.getString(cursor.getColumnIndex(AnswerTable.LOCATION)));
            jsonObject.put("cat",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.CATEGORY)));
            jsonObject.put("facility",cursor.getString(cursor.getColumnIndex(AnswerTable.FACILITY)));
            jsonObject.put("datetime",cursor.getString(cursor.getColumnIndex(AnswerTable.DATETIME)));
        }
        if(cursor.moveToFirst()){
            do{
                try {
                    JSONObject jsonObject1=new JSONObject();
                    jsonObject1.put("question_id",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.QUESTION_ID)));
                    jsonObject1.put("answer",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.OPTION_TEXT)));
                    jsonObject1.put("issue",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ISSUE)));
                    jsonObject1.put("form_id",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.FORM_ID)));
                    jsonObject1.put("row_index",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ROW_INDEX)));
                    jsonObject1.put("delete_status",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.DELETE_STATUS)));
//                    if( cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS))==null)
//                    {
//                        jsonObject1.put("remarks","");
//                    }
//                    else {
                        jsonObject1.put("remarks", cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS)));
//                    }
                    jsonArray.put(jsonObject1);
                    } catch (JSONException e) {
                    e.printStackTrace();
                }
            }while (cursor.moveToNext());
        }
        jsonObject.put("list",jsonArray);
        return jsonObject;
    }

//    public List<JSONObject> getAnswersList(String assignId, String catId) throws JSONException {
//        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
//        String query="SELECT * FROM "+ AnswerTable.TABLENAME +
//                " WHERE "+ AnswerTable.ASSIGNID+"='"+assignId+"' AND "+AnswerTable.CATEGORY+"='"+catId+"'";
//        Cursor cursor = sdb.rawQuery(query,null);
//
//        List<JSONObject> list= new ArrayList();
//
//        JSONObject jsonObject=new JSONObject();
//        JSONArray jsonArray=new JSONArray();
//        if(cursor.moveToFirst()){
//            jsonObject.put("assign",cursor.getString(cursor.getColumnIndex(AnswerTable.ASSIGNID)));
//            jsonObject.put("lat",cursor.getString(cursor.getColumnIndex(AnswerTable.LAT)));
//            jsonObject.put("lon",cursor.getString(cursor.getColumnIndex(AnswerTable.LON)));
//            jsonObject.put("location",cursor.getString(cursor.getColumnIndex(AnswerTable.LOCATION)));
//            jsonObject.put("cat",cursor.getString(cursor.getColumnIndex(AnswerTable.CATEGORY)));
//            jsonObject.put("subcat",cursor.getString(cursor.getColumnIndex(AnswerTable.SUBCAT)));
//            jsonObject.put("facility",cursor.getString(cursor.getColumnIndex(AnswerTable.FACILITY)));
//            jsonObject.put("datetime",cursor.getString(cursor.getColumnIndex(AnswerTable.DATETIME)));
//        }
//        if(cursor.moveToFirst()){
//            do{
//                try {
//                    JSONObject jsonObject1=new JSONObject();
//                    jsonObject1.put("question",cursor.getString(cursor.getColumnIndex(AnswerTable.QUESTION)));
//                    jsonObject1.put("answer",cursor.getString(cursor.getColumnIndex(AnswerTable.ANSWER)));
//                    jsonObject1.put("issue",cursor.getString(cursor.getColumnIndex(AnswerTable.ISSUE)));
////                    if( cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS))==null)
////                    {
////                        jsonObject1.put("remarks","");
////                    }
////                    else {
//                        jsonObject1.put("remarks", cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS)));
////                    }
//                    jsonObject1.put("type",cursor.getString(cursor.getColumnIndex(AnswerTable.TYPE)));
//                    jsonObject1.put("number",cursor.getString(cursor.getColumnIndex(AnswerTable.NUMBER)));
//                    jsonObject1.put("subcat",cursor.getString(cursor.getColumnIndex(AnswerTable.SUBCAT)));
//                    if(cursor.getString(cursor.getColumnIndex(AnswerTable.TYPE)).equals("signature")
//                            || cursor.getString(cursor.getColumnIndex(AnswerTable.TYPE)).equals("image")) {
//
//                        JSONObject jsonObject2 = new JSONObject(jsonObject.toString());
//                        JSONArray jsonArray1 = new JSONArray();
//                        jsonArray1.put(jsonObject1);
//                        jsonObject2.put("list",jsonArray1);
//                        list.add(jsonObject2);
//                    }else{
//                        jsonArray.put(jsonObject1);
//                    }
//
//                } catch (JSONException e) {
//                    e.printStackTrace();
//                }
//            }while (cursor.moveToNext());
//        }
//
//        if(jsonArray.length() != 0){
//            jsonObject.put("list",jsonArray);
//            list.add(jsonObject);
//        }
//
//        return list;
//    }

    public List<JSONObject> getAnswersList(String assignId, String catId) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ FlexibleFormResponsesTable.TABLENAME +
                " fr INNER JOIN "+ FlexibleFormQuestionsTable.TABLENAME + " fq ON fr." + FlexibleFormResponsesTable.FORM_ID +
                " = fq." +FlexibleFormQuestionsTable.FORM_ID + " AND fr." + FlexibleFormResponsesTable.QUESTION_ID + " = fq." + FlexibleFormQuestionsTable.QUESTION_ID +
                " WHERE "+ FlexibleFormResponsesTable.ASSIGNMENT_ID+"='"+assignId+"' AND "+ FlexibleFormResponsesTable.CATEGORY +"='"+catId+"'";
        Cursor cursor = sdb.rawQuery(query,null);

        List<JSONObject> list= new ArrayList();

        JSONObject jsonObject=new JSONObject();
        JSONArray jsonArray=new JSONArray();
        if(cursor.moveToFirst()){
            jsonObject.put("assign",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ASSIGNMENT_ID)));
        }
        if(cursor.moveToFirst()){
            do{
                try {
                    JSONObject jsonObject1=new JSONObject();
                    jsonObject1.put("form_id",cursor.getString(cursor.getColumnIndex(FlexibleFormQuestionsTable.FORM_ID)));
                    jsonObject1.put("answer",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.OPTION_TEXT)));
                    jsonObject1.put("issue",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ISSUE)));
                    jsonObject1.put("question_id",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.QUESTION_ID)));
//                    jsonObject1.put("row_index", cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ROW_INDEX)));
                    jsonObject1.put("delete_status",cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.DELETE_STATUS)));
                    String rowIndexValue = cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.ROW_INDEX));
                    if (rowIndexValue == null || rowIndexValue.isEmpty()) {
                        rowIndexValue = String.valueOf(0);
                    }
                    jsonObject1.put("row_index", rowIndexValue);
    //                    if( cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS))==null)
    //                    {
    //                        jsonObject1.put("remarks","");
    //                    }
    //                    else {
    //                        jsonObject1.put("remarks", cursor.getString(cursor.getColumnIndex(AnswerTable.REMARKS)));
    //                    }
                    if(cursor.getString(cursor.getColumnIndex(FlexibleFormQuestionsTable.ANSWER_TYPE)).equals("image")) {

                        JSONObject jsonObject2 = new JSONObject(jsonObject.toString());
                        JSONArray jsonArray1 = new JSONArray();
                        jsonArray1.put(jsonObject1);
                        jsonObject2.put("list",jsonArray1);
                        list.add(jsonObject2);
                    }else{
                        jsonArray.put(jsonObject1);
                    }

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }while (cursor.moveToNext());
        }

        if(jsonArray.length() != 0){
            jsonObject.put("list",jsonArray);
            list.add(jsonObject);
        }

        return list;
    }

    public int getLastNumberPart(String questionId, String prefix, String suffix) {
        SQLiteDatabase db = sqliteHelper.getReadableDatabase();
        int lastNumber = 0;

        Cursor cursor = db.rawQuery(
                "SELECT "+ FlexibleFormResponsesDataTable.OPTION_TEXT +" FROM " + FlexibleFormResponsesDataTable.TABLENAME + " WHERE "+ FlexibleFormResponsesDataTable.QUESTION_ID +" = ? ORDER BY "+ FlexibleFormResponsesDataTable.ID +" DESC LIMIT 1",
                new String[]{questionId}
        );

        if (cursor.moveToFirst()) {
            String optionText = cursor.getString(0);
            try {
                // Strip prefix and suffix if they match
                String numberPart = optionText;
                if (numberPart.startsWith(prefix)) {
                    numberPart = numberPart.substring(prefix.length());
                }
                if (numberPart.endsWith(suffix)) {
                    numberPart = numberPart.substring(0, numberPart.length() - suffix.length());
                }

                // Convert middle part to Int
                if (!numberPart.isEmpty()) {
                    lastNumber = Integer.parseInt(numberPart);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        cursor.close();
        return lastNumber;
    }

    public void deleteAddress(String questionId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="DELETE FROM "+ FlexibleFormResponsesTable.TABLENAME +
                " WHERE question_id ='" + questionId + "'";
        sdb.execSQL(query);
    }


    public boolean checkAllCategoriesCompleted(String assignId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ CombinationTable.TABLENAME +
                " INNER JOIN " + QuestionTable.TABLENAME +" ON "+QuestionTable.TABLENAME+"."+QuestionTable.NAME+"=combination."+CombinationTable.ID+
                " LEFT JOIN " +AssignTable.TABLENAME +" ON "+AssignTable.COMBINATION+"=combination."+CombinationTable.ID+
                " LEFT JOIN "+FlexibleFormResponsesTable.TABLENAME +" ON flexible_form_responses."+FlexibleFormResponsesTable.ASSIGNMENT_ID+"=scheduleassign."+AssignTable.ASSIGNID +
                " AND "+FlexibleFormResponsesTable.PREVIEW+"='0' AND flexible_form_responses."+FlexibleFormResponsesTable.CATEGORY+"=questions."+QuestionTable.CATEGORY+
                " WHERE scheduleassign."+ AssignTable.ASSIGNID+"='"+assignId+"' AND flexible_form_responses.question_id IS NULL"+
                " GROUP BY questions."+QuestionTable.CATEGORY;
        Cursor cursor = sdb.rawQuery(query,null);
        return cursor == null || cursor.getCount() == 0;
    }

    public String getUnSyncedCategory(String assignId) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ FlexibleFormResponsesTable.TABLENAME +
                " WHERE "+ FlexibleFormResponsesTable.ASSIGNMENT_ID+"='"+assignId+"' AND "+FlexibleFormResponsesTable.SYNCED+"='0' "
                +" GROUP BY "+FlexibleFormResponsesTable.CATEGORY +" LIMIT 1";
        Cursor cursor = sdb.rawQuery(query,null);
        if(cursor !=null && cursor.getCount()!=0){
            cursor.moveToFirst();
            return cursor.getString(cursor.getColumnIndex(FlexibleFormResponsesTable.CATEGORY));
        }else{
            return null;
        }
    }

    public void updateSynced(String assignId,String catid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(FlexibleFormResponsesTable.SYNCED, "1");
        sdb.update(FlexibleFormResponsesTable.TABLENAME, cv ,FlexibleFormResponsesTable.ASSIGNMENT_ID+" = ? AND "+FlexibleFormResponsesTable.CATEGORY+"= ?", new String[]{assignId,catid});
    }

    public void deleteAll(){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        sdb.delete(AnswerTable.TABLENAME,"",new String[]{});
        sdb.delete(QuestionTable.TABLENAME,"",new String[]{});
        sdb.delete(QCategoryTable.TABLENAME,"",new String[]{});
        sdb.delete(QSubCatTable.TABLENAME,"",new String[]{});
        sdb.delete(AssignTable.TABLENAME,"",new String[]{});
    }

    public void deleteResponses(String assignId, String formId){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query = "DELETE FROM "+ FlexibleFormResponsesTable.TABLENAME +" WHERE "+
                FlexibleFormResponsesTable.ASSIGNMENT_ID+" = '"+assignId+"' AND "+ FlexibleFormResponsesTable.FORM_ID +
                " = '"+formId+"'";
        sdb.execSQL(query);
    }
    public void updateCompleted(String assignId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(AssignTable.STATUS, "completed");
        sdb.update(AssignTable.TABLENAME, cv ,AssignTable.ASSIGNID+"=?", new String[]{assignId});
    }

    public void updateStarted(String assignId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(AssignTable.STATUS, "underprogress");
        sdb.update(AssignTable.TABLENAME, cv ,AssignTable.ASSIGNID+"=?", new String[]{assignId});
    }

}
