package com.b2lmobitech.fieldcloudplus.service.sql;

/**
 * Created by home on 2/8/2018.
 */

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;


import com.b2lmobitech.fieldcloudplus.service.sql.tables.AnswerTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.BrandTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.CategoryTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.CombinationTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.FacilityTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.ModelTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.ProductTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QCategoryTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QSubCatTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.QuestionTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.SerialTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.SubCatTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.TicketTable;
import com.b2lmobitech.fieldcloudplus.service.sql.tables.TypeTable;


public class SqliteHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "service.db3";
    private static final int DATABASE_VERSION = 3;

    public SQLiteDatabase db;
    private final Context context;
    private SqliteHelper dbHelper;

    public SqliteHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.context=context;
    }

    // Called when no database exists in disk and the helper class needs
    // to create a new one.
    @Override
    public void onCreate(SQLiteDatabase _db) {
        _db.execSQL(AssignTable.CREATE_TABLE);
        _db.execSQL(BrandTable.CREATE_TABLE);
        _db.execSQL(CategoryTable.CREATE_TABLE);
        _db.execSQL(CombinationTable.CREATE_TABLE);
        _db.execSQL(FacilityTable.CREATE_TABLE);
        _db.execSQL(ModelTable.CREATE_TABLE);
        _db.execSQL(ProductTable.CREATE_TABLE);
        _db.execSQL(SerialTable.CREATE_TABLE);
        _db.execSQL(SubCatTable.CREATE_TABLE);
        _db.execSQL(TypeTable.CREATE_TABLE);
        _db.execSQL(QuestionTable.CREATE_TABLE);
        _db.execSQL(QSubCatTable.CREATE_TABLE);
        _db.execSQL(QCategoryTable.CREATE_TABLE);
        _db.execSQL(AnswerTable.CREATE_TABLE);
        _db.execSQL(TicketTable.CREATE_TABLE);

    }

    // Called when there is a database version mismatch meaning that the version
    // of the database on disk needs to be upgraded to the current version.
    @Override
    public void onUpgrade(SQLiteDatabase _db, int _oldVersion, int _newVersion) {
        _db.execSQL("DROP TABLE "+AssignTable.TABLENAME);
        _db.execSQL("DROP TABLE "+QuestionTable.TABLENAME);
        _db.execSQL(AssignTable.CREATE_TABLE);
        _db.execSQL(QuestionTable.CREATE_TABLE);
    }






}
