package com.b2lmobitech.fieldcloudplus.service.v2

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.databinding.ActivityAnswersBinding
import com.b2lmobitech.fieldcloudplus.service.v2.adapter.HistoryAnswerAdapter
import com.b2lmobitech.fieldcloudplus.service.v2.adapter.parseGroupedAnswers
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.setManager
import com.google.android.material.tabs.TabLayout
//import kotlinx.android.synthetic.main.activity_answers.*
import org.json.JSONArray

class AnswersActivity : AppCompatActivity(),TabLayout.OnTabSelectedListener {

    private var list = JSONArray()
    private lateinit var historyAnswerAdapter: HistoryAnswerAdapter
    private var cat=""
    private lateinit var binding: ActivityAnswersBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_answers)
        binding = ActivityAnswersBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        intent?.let {
            list = JSONArray(it.getStringExtra("list"))
            cat = it.getStringExtra("cat")!!
        }

        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.title = ""

        val subCats = HashSet<String>()
        for(i in 0 until list.length()){
            val json = list.getJSONObject(i)
            if(json.getString("category_name").equals(cat)){
                json.getString("section_name").let {
                    if(it.isEmpty() || it.equals("null")){
                        subCats.add("General")
                    }else{
                        subCats.add(it)
                    }
                }
            }
        }

        binding.tabLayout.removeAllTabs()
        for (subCat in subCats) {
            binding.tabLayout.addTab(binding.tabLayout.newTab().setText(subCat))
        }

        historyAnswerAdapter = HistoryAnswerAdapter(emptyList())
        binding.recyclerView.setManager(this)
        binding.recyclerView.addDivider(this)
        binding.recyclerView.adapter = historyAnswerAdapter

        binding.tabLayout.addOnTabSelectedListener(this)
        onTabSelected(binding.tabLayout.getTabAt(0))
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    override fun onTabReselected(p0: TabLayout.Tab?) {

    }

    override fun onTabUnselected(p0: TabLayout.Tab?) {

    }

    override fun onTabSelected(p0: TabLayout.Tab?) {
        val selectedSubCat = p0!!.text.toString()
        val answers = JSONArray()
        for(i in 0 until list.length()){
            val json = list.getJSONObject(i)
            if(json.getString("category_name").equals(cat)){
                json.getString("section_name").let {
                    if(selectedSubCat.equals("General",true)){
                        if(it.isEmpty() || it.equals("null")){
                            answers.put(json)
                        }
                    }else if(selectedSubCat.equals(json.getString("section_name"))){
                        answers.put(json)
                    }
                }
            }
        }
        Log.e("answers","$answers")
        val groupedList = parseGroupedAnswers(answers)
        historyAnswerAdapter = HistoryAnswerAdapter(groupedList)
        binding.recyclerView.adapter = historyAnswerAdapter
        historyAnswerAdapter.notifyDataSetChanged()
    }

}
