package com.b2lmobitech.fieldcloudplus.service.v2

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.databinding.ActivityHistoryCategoryBinding
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.service.v2.adapter.CategoryAdapter
import com.b2lmobitech.fieldcloudplus.task.others.Preference
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.setManager
//import kotlinx.android.synthetic.main.activity_history_list.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.HashMap

class HistoryCategoryActivity : AppCompatActivity() {

    private var list = JSONArray()
    private lateinit var categoryAdapter: CategoryAdapter
    private var id=""
    private lateinit var binding: ActivityHistoryCategoryBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_history_category)
        binding = ActivityHistoryCategoryBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        id = intent?.getStringExtra("id")!!
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.title = "Completed"




        categoryAdapter = CategoryAdapter(itemClickListener = object :OnItemClickListener{
            override fun itemClicked(position: Int) {
                val intent = Intent(this@HistoryCategoryActivity,AnswersActivity::class.java)
                intent.putExtra("list",list.toString())
                intent.putExtra("cat",categoryAdapter.list.get(position))
                startActivity(intent)
            }
        })

        binding.recyclerView.setManager(this)
        binding.recyclerView.addDivider(this)
        binding.recyclerView.adapter = categoryAdapter

        getData()

    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    private fun getData() {
        val preference = Preference.getInstance(this)
        val params: MutableMap<String, String> = HashMap()
        params["id"] = id
        Log.d("params assignid","$id")
        val myRequestQueue = MyRequestQueue.getInstance(this)
        myRequestQueue.addToQueue(SERVICEURL.GET_ANSWERS, params) { response ->
            try {
                JSONObject(response).let {
                    list = it.getJSONArray("list")
                    Log.e("list","$list, ${list.length()}")
                    val cats = HashSet<String>()
                    for(i in 0 until list.length()){
                        cats.add(list.getJSONObject(i).getString("category_name"))
                    }
                    categoryAdapter.list = cats.toList()
                    categoryAdapter.notifyDataSetChanged()
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }


}
