package com.b2lmobitech.fieldcloudplus.service.v2

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.databinding.ActivityHistoryListBinding
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.service.v2.adapter.HistoryAdapter
import com.b2lmobitech.fieldcloudplus.task.others.Preference
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.setManager
//import kotlinx.android.synthetic.main.activity_history_list.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.HashMap

class HistoryListActivity : AppCompatActivity() {

    private var list = JSONArray()
    private lateinit var historyAdapter: HistoryAdapter
    private lateinit var binding: ActivityHistoryListBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_history_list)
        binding = ActivityHistoryListBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.title = "Completed"

        historyAdapter = HistoryAdapter(list,itemClickListener = object : OnItemClickListener {
            override fun itemClicked(position: Int) {
                val intent = Intent(this@HistoryListActivity,HistoryCategoryActivity::class.java)
                intent.putExtra("id",list.getJSONObject(position).getString("assignschedule_id"))
                startActivity(intent)
            }
        })
        binding.recyclerView.setManager(this)
        binding.recyclerView.addDivider(this)
        binding.recyclerView.adapter = historyAdapter

        getData()

    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }


    private fun getData() {
        val preference = Preference.getInstance(this)
        val params: MutableMap<String, String> = HashMap()
        params["mail"] = preference.emailId
        params["cname"] = preference.companyName
        val myRequestQueue = MyRequestQueue.getInstance(this)
        myRequestQueue.addToQueue(SERVICEURL.GET_HISTORY, params) { response ->
            try {
                JSONObject(response).let {
                    list = it.getJSONArray("list")
                    historyAdapter.jsonArray = list
                    historyAdapter.notifyDataSetChanged()
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

}
