package com.b2lmobitech.fieldcloudplus.service.v2

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.MenuItem
import com.b2lmobitech.fieldcloudplus.databinding.ActivitySelectComboBinding
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.service.v2.adapter.ComboAdapter
import com.b2lmobitech.fieldcloudplus.task.others.Preference
import com.b2lmobitech.fieldcloudplus.utils.addDivider
import com.b2lmobitech.fieldcloudplus.utils.setManager
//import kotlinx.android.synthetic.main.activity_select_combo.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.HashMap

class SelectComboActivity : AppCompatActivity() {

    private var combos = JSONArray()

    private lateinit var binding: ActivitySelectComboBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_select_combo)
        binding = ActivitySelectComboBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        getData()

        supportActionBar?.let {
            it.setTitle("Select Type")
            it.setDisplayHomeAsUpEnabled(true)
        }
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        onBackPressed()
        return super.onOptionsItemSelected(item)
    }

    private fun getData() {
        val preference = Preference.getInstance(this)
        val params: MutableMap<String, String> = HashMap()
        params["mail"] = preference.emailId
        params["cname"] = preference.companyName
        val myRequestQueue = MyRequestQueue.getInstance(this)
        myRequestQueue.addToQueue(SERVICEURL.GET_FORM_DATA, params) { response ->
            try {
                JSONObject(response).let {
                    combos = it.getJSONArray("cat")
                    setAdapter()
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun setAdapter(){
        binding.recyclerView.setManager(this)
        binding.recyclerView.addDivider(this)
        val adapter = ComboAdapter(combos,object:OnItemClickListener{
            override fun itemClicked(position: Int) {
                val intent = Intent(this@SelectComboActivity,SelectQuestionActivity::class.java)
                intent.putExtra("cat",combos.getJSONObject(position).getString("id"))
                startActivity(intent)
                finish()
            }
        })
        binding.recyclerView.adapter = adapter
    }

}
