package com.b2lmobitech.fieldcloudplus.service.v2

import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import android.content.Context
import android.content.Intent
import android.content.IntentSender
import android.content.pm.PackageManager
import android.location.LocationManager
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import androidx.core.app.ActivityCompat
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.BuildConfig
import com.b2lmobitech.fieldcloudplus.databinding.ActivitySelectQuestionBinding
import com.b2lmobitech.fieldcloudplus.defect.DEFECTURL
import com.b2lmobitech.fieldcloudplus.hcm.HCMURL
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue
import com.b2lmobitech.fieldcloudplus.service.activities.ServiceCombinationActivity
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase
import com.b2lmobitech.fieldcloudplus.service.sql.tables.*
import com.b2lmobitech.fieldcloudplus.task.others.Preference
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress
import com.b2lmobitech.fieldcloudplus.utils.DistanceCalculator
import com.b2lmobitech.fieldcloudplus.utils.hidden
import com.b2lmobitech.fieldcloudplus.utils.toast
import com.b2lmobitech.fieldcloudplus.utils.visible
import com.google.android.gms.common.api.ApiException
import com.google.android.gms.common.api.ResolvableApiException
import com.google.android.gms.location.*
import com.google.android.material.snackbar.Snackbar
//import kotlinx.android.synthetic.main.activity_select_question.*
//import kotlinx.android.synthetic.main.content_attendance.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.*
import kotlin.collections.HashSet

class SelectQuestionActivity : AppCompatActivity() {

    private var facilityEntities: List<FacilityEntity> = ArrayList<FacilityEntity>()
    private lateinit var dbViewModel: DBViewModel
    private val stateList = HashSet<String>()
    private var cityList = LinkedHashMap<String, HashSet<String>>()
    private var facilityList = LinkedHashMap<String, List<FacilityEntity>>()
    private var equipmentsList = JSONArray()
    private var kitchensList = JSONArray()
    private var comboList = JSONArray()
    private var selectedCatId = "";
    private var lat_data = "";
    private var lon_data = "";
    private lateinit var binding: ActivitySelectQuestionBinding
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
//        setContentView(R.layout.activity_select_question)
        binding = ActivitySelectQuestionBinding.inflate(layoutInflater)
        val view = binding.root
        setContentView(view)
        dbViewModel = ViewModelProvider.AndroidViewModelFactory.getInstance(application).create(DBViewModel::class.java)
        selectedCatId = intent.getStringExtra("cat")?:""

        supportActionBar?.apply {
            setDisplayHomeAsUpEnabled(true)
            setTitle("New Inspection")
        }

        binding.btnSubmit.setOnClickListener {
            checkGeoFence()
        }
        getData()
    }

    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu_form, menu)
        return super.onCreateOptionsMenu(menu)
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item?.itemId == R.id.done) {
            checkGeoFence()
            //addInspection()
        } else if (item?.itemId == android.R.id.home) {
            onBackPressed()
        }
        return super.onOptionsItemSelected(item)

    }

    private fun getData() {
        val preference = Preference.getInstance(this)
        val params: MutableMap<String, String> = HashMap()
        params["mail"] = preference.emailId
        params["cname"] = preference.companyName
        val myRequestQueue = MyRequestQueue.getInstance(this)
        myRequestQueue.addToQueue(SERVICEURL.GET_FORM_DATA, params) { response ->
            try {
                JSONObject(response).let {
                    comboList = it.getJSONArray("combs")
//                    Log.d("comboList",comboList.toString())

                    getKitchens()
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getKitchens() {
        val params: MutableMap<String, String> = HashMap()
        params["cname"] = com.b2lmobitech.fieldcloudplus.others.utils.Preference.getInstance(this).companyName

        MyRequestQueue.getInstance(this).addToQueue(DEFECTURL.GET_KITCHENS, params) { response ->
            try {
                kitchensList = JSONArray(response)
//                Log.d("kitchensList",kitchensList.toString())
                getFacilities()
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getFacilities() {
        val params: MutableMap<String, String> = HashMap()
        params["email"] = com.b2lmobitech.fieldcloudplus.others.utils.Preference.getInstance(this).emailId

        MyRequestQueue.getInstance(this).addToQueue(HCMURL.GET_FACILITIES, params) { response ->
            try {
                val jsonArray = JSONArray(response)
                val listener = object : DBViewModel.CompletedCallBack {
                    override fun onTaskCompleted() {
                        runOnUiThread {

                            getFacilitiesOffline()
                        }
                    }
                }

//                Log.d("getfacilities",jsonArray.length().toString())
                dbViewModel.addAllFacilities(jsonArray, listener)
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getFacilitiesOffline() {
        dbViewModel.getAllFacilities().removeObservers(this)

        dbViewModel.getAllFacilities()?.observe(this, Observer { result ->
            dbViewModel.getAllFacilities().removeObservers(this)
            setfacilityEntities(result!!)
        })
    }

    fun setfacilityEntities(list: List<FacilityEntity>) {

        facilityEntities = list
        facilityEntities.forEach {
            stateList.add(it.state)
        }

        stateList.forEach { state ->
            val city = HashSet<String>()
            facilityEntities.forEach {
                if (it.state.equals(state, ignoreCase = true)) {
                    city.add(it.location)
                }
            }
            cityList.put(state, city)
        }

        cityList.forEach { states ->
            states.value.forEach { city ->
                val facilities = ArrayList<FacilityEntity>()
                list.forEach { facility ->
                    if (facility.location.equals(city, true)) {
                        facilities.add(facility)
                    }
                }
                facilityList.put(city, facilities)
            }
        }

        setSpinners()
        // scrollView.visible()
    }

    private var selectedFacilitiesList = ArrayList<FacilityEntity>()
    private var selectedKitchensList = JSONArray()
    private var selectedSubCatlist = JSONArray()

    fun setSpinners() {

        /*fun setSubCats(catName:String){
            selectedSubCatlist = JSONArray()
            val subCatList = ArrayList<String>()

            for( i in 0 until  subcats.length()){
                subcats.getJSONObject(i)?.let {
                    if(it.getString("category_name").equals(catName,true)) {
                        subCatList.add(subcats.getJSONObject(i).getString("sub_category_name"))
                        selectedSubCatlist.put(it)
                    }
                }
            }

            val subCatAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, subCatList)
            subCatAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            materialSpinner3.adapter = subCatAdapter
            if(subCatList.isEmpty()){
                materialSpinner3.hidden()
            }else{
                materialSpinner3.setSelection(0)
                materialSpinner3.visible()
            }


        }*/

        /* val catList = ArrayList<String>()
         for( i in 0 until  cats.length()){
             catList.add(cats.getJSONObject(i).getString("category_name"))
         }
         val catAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, catList)
         catAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
         materialSpinner.adapter = catAdapter

         materialSpinner.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
             override fun onNothingSelected(parent: AdapterView<*>?) {
             }
             override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                 setSubCats(materialSpinner.selectedItem.toString())
             }
         }

         materialSpinner.setSelection(0)*/
        binding.materialSpinner.visible(false)
        binding.materialSpinner3.visible(false)

        fun setFacilitiesSpinner(selectedCity: String) {
            selectedFacilitiesList.clear()
            selectedFacilitiesList.addAll(facilityList.get(selectedCity)!!)
            val arrayList = ArrayList<String>()
            selectedFacilitiesList.forEach {
                arrayList.add(it.sitename)
            }
            val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, arrayList)
            cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            binding.spinnerSite.adapter = cityAdapter
            binding.spinnerSite.setSelection(0)
        }

        fun setCitySpinner(selectedState: String) {
            val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, cityList.get(selectedState)!!.toList())
            cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
            binding.spinnerCity.adapter = cityAdapter
            binding.spinnerCity.setSelection(0)
        }

        fun filterFacilities(selectedCity: String) {
            val filteredList = ArrayList<FacilityEntity>()
            facilityEntities.forEach {
                if (it.location.equals(selectedCity, true)) {
                    filteredList.add(it)
                }

            }
            setFacilitiesSpinner(selectedCity)
        }


        val stateAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, ArrayList(stateList))
        stateAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        binding.spinnerState.adapter = stateAdapter
        binding.spinnerState.setSelection(0)

        binding.spinnerCity.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onNothingSelected(parent: AdapterView<*>?) {
            }

            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                binding.spinnerCity.selectedItem?.let { setFacilitiesSpinner(it.toString()) }
            }
        }

        binding.spinnerState.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
            override fun onNothingSelected(parent: AdapterView<*>?) {
            }

            override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
                binding.spinnerState.selectedItem?.let { setCitySpinner(it.toString()) }
            }

        }

        setKitchensSpinner()
    }

    fun setKitchensSpinner() {
        val arrayList = ArrayList<String>()

        for (i in 0 until kitchensList.length()) {
            arrayList.add(kitchensList.getJSONObject(i).getString("subfacility_name"))
        }
        val cityAdapter = ArrayAdapter<String>(this, R.layout.simple_spinner_item, arrayList)
        cityAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item)
        binding.materialSpinner5.adapter = cityAdapter
        binding.materialSpinner5.setSelection(0)
    }

    fun getCombinationId(): Pair<String, String> {
        var id = "";
        var type = "";


        for (i in 0 until comboList.length()) {
            comboList.getJSONObject(i)?.let {
                if (it.getString("service_category").equals(selectedCatId, true)) {
                    id = it.getString("ID")
                    type = it.getString("type")
                }
                /* if(it.getString("service_category").equals(catId,true) &&
                         ( subCat.isEmpty() || subCat.equals("no data available",true))){
                     id = it.getString("id")
                     type=it.getString("type")
                 }*/
            }
        }

        return Pair(id, type)
    }

    private var geoFenceEnabled = false
    private var geoLat = 0.0
    private var geoLon = 0.0
    private var geoDistance = 0

    private fun checkGeoFence() {
//        Log.d("here3","checkGeoFence")
        selectedFacilitiesList.get(binding.spinnerSite.selectedItemPosition).let {
            if (it.geofencing.equals("enable", true)) {
                geoFenceEnabled = true
                geoLat = it.latitude.toDouble()
                geoLon = it.longitude.toDouble()
                geoDistance = it.geo_distance.toInt()
//                Log.d("here4","geofencing")
            }
        }

        if (geoFenceEnabled && BuildConfig.DEBUG) {
//            Log.d("here1","connectLocation")
            connectLocation()

        } else {
//            Log.d("here2","addInspection")
            addInspection()

        }


    }

    var locationManager: LocationManager? = null

    fun connectLocation() {
//        Log.d("connect location", "connectLocation")
        RequestProgress.getInstance(this).showProgressBar()
        val locationRequest = LocationRequest.create()
        locationRequest.priority = LocationRequest.PRIORITY_HIGH_ACCURACY
        locationRequest.interval = 1000
        locationRequest.fastestInterval = 1000 / 2.toLong()
        locationRequest.numUpdates = 1
        val builder = LocationSettingsRequest.Builder().addLocationRequest(locationRequest)
        builder.setAlwaysShow(true)
        val task = LocationServices.getSettingsClient(this).checkLocationSettings(builder.build())

        task.addOnCompleteListener { task ->
            try {
                task.getResult(ApiException::class.java)
                findlocation()
            } catch (exception: ApiException) {
                when (exception.statusCode) {
                    LocationSettingsStatusCodes.RESOLUTION_REQUIRED -> try {
                        val resolvable = exception as ResolvableApiException
                        resolvable.startResolutionForResult(this, 4)
                    } catch (e: IntentSender.SendIntentException) { // Ignore the error.
                    } catch (e: ClassCastException) { // Ignore, should be an impossible error.
                    }
                }
            }
        }
    }

    private lateinit var mFusedLocationClient: FusedLocationProviderClient
    private lateinit var mLocationRequest: LocationRequest
    private var currentlocationlaltitue = 0.0
    private var currentlocationlongitude = 0.0

    fun findlocation() {

        locationManager = getSystemService(Context.LOCATION_SERVICE) as LocationManager

        mFusedLocationClient = LocationServices.getFusedLocationProviderClient(this)
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return
        }


        mFusedLocationClient.getCurrentLocation(LocationRequest.PRIORITY_HIGH_ACCURACY, null).addOnCompleteListener {
            it.result?.let { location ->
                //Place current location marker
                Log.e("Location", location.latitude.toString() + " " + location.longitude)
                currentlocationlaltitue = location.latitude
                currentlocationlongitude = location.longitude
                calculateDistance(currentlocationlaltitue, currentlocationlongitude)
            }
        }.addOnCanceledListener {
            "Try Again".toast(this)
        }

        //				 Log.d("currentlocationlaltitue",""+currentlocationlaltitue);
//				 Log.d("currentlocationlongitude",""+currentlocationlongitude);
    }

    private fun calculateDistance(lat: Double, lon: Double) {
        fun alertNotInFacility() {
            val alertdialog = AlertDialog.Builder(this)
            alertdialog.setMessage("It seems you are out of the geofence")
            alertdialog.setPositiveButton("Close") { dialog, whichButton ->
                binding.progressBar.hidden()
            }.create()
            alertdialog.setCancelable(false)
            alertdialog.show()
        }

        lat_data = lat.toString();
        lon_data = lon.toString()
        val distance = DistanceCalculator.distance(lat, lon, geoLat, geoLon)
        Log.d("calculate distance", "$distance")
        if (!geoFenceEnabled || distance <= geoDistance) {
            addInspection()
        } else {
            MyRequestQueue.getInstance(this).hideProgressBar()
            alertNotInFacility()
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == 4) {
            when (resultCode) {
                Activity.RESULT_OK -> findlocation()
                Activity.RESULT_CANCELED -> {
                    val snackBar = Snackbar.make(window.decorView, "Please enable location", Snackbar.LENGTH_INDEFINITE)
                    snackBar.show()
                    RequestProgress.getInstance(this).hideProgressBar()
                }
            }
        }
    }

    private var sid = ""
    private var date = ""
    private var fid = ""

    private fun addInspection() {

        val params: MutableMap<String, String> = HashMap()
        if (selectedFacilitiesList.isEmpty()) {
            "Select Valid Facility".toast(this)
            return
        }
        selectedFacilitiesList.get(binding.spinnerSite.selectedItemPosition).let {
            if (it == null) {
                "Select Valid Facility".toast(this)
                return
            } else {
                params["facility_id"] = it.atmid
//                Log.d("facility_id",it.atmid.toString())
            }
        }
        params["kitchen"] = kitchensList.getJSONObject(binding.materialSpinner5.selectedItemPosition).getString("subfacility_id")
        params["empemail"] = Preference.getInstance(this).emailId
        params["cname"] = Preference.getInstance(this).companyName
//        Log.d("kitchen",kitchensList.getJSONObject(materialSpinner5.selectedItemPosition).getString("subfacility_id"))
//        Log.d("empemail",Preference.getInstance(this).emailId)
//        Log.d("cname",Preference.getInstance(this).companyName)
        getCombinationId().let {
            params["cid"] = it.first
            params["ctype"] = it.second
//            Log.d("cid",it.first.toString())
//            Log.d("ctype",it.second.toString())
        }



        MyRequestQueue.getInstance(this).addToQueue(SERVICEURL.ADD_INSPECTION, params) { response ->
            try {
                val json = JSONObject(response)
//                Log.d("addinspection",json.getInt("s").toString())
                if (json.getInt("s") == 1) {
                    sid = json.getString("sid")
                    date = json.getString("date")
                    fid = json.getString("fid")
                    getInspections()
                } else {
                    "Error".toast(this)
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    private fun getInspections() {
        val preference = Preference.getInstance(this)
        val params: MutableMap<String, String> = HashMap()
        params["mail"] = preference.emailId
        params["cname"] = preference.companyName
        val myRequestQueue = MyRequestQueue.getInstance(this)
        myRequestQueue.addToQueue(SERVICEURL.GET_INSPECTIONS, params) { response ->
            try {
                Log.d("dummmy","Tocheckwhere")
                getInspections(JSONObject(response))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
    }

    @Throws(JSONException::class)
    private fun getInspections(jsonObject: JSONObject) {
        /* JSONArray jsonArray=jsonObject.getJSONArray("list");
        adapter=new PreventiveAdapter(this,jsonArray);
        recyclerView.setAdapter(adapter);*/
        Log.d("dummmy","here1")
        val database = ServiceDatabase.getInstance(this)
        database.insertIntoTable(jsonObject.getJSONArray("brand"), BrandTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("model"), ModelTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("product"), ProductTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("serial"), SerialTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("cat"), CategoryTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("subcat"), SubCatTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("type"), TypeTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("combs"), CombinationTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("assign"), AssignTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("facility"), FacilityTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ques"), QuestionTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("qcat"), QCategoryTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("qsubcat"), QSubCatTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_questions"),
            FlexibleFormQuestionsTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_sections"),
            FlexibleFormSectionsTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_options"),
            FlexibleFormOptionsTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_response"),
            FlexibleFormResponsesTable.TABLENAME)
        database.insertIntoTable(jsonObject.getJSONArray("ff_dataresponse"),
            FlexibleFormResponsesDataTable.TABLENAME)
        startNextActivity()
    }

    fun startNextActivity() {
        val intent = Intent(applicationContext, ServiceCombinationActivity::class.java)
        intent.putExtra("id", fid)
        intent.putExtra("date", date)
        intent.putExtra("assignid", sid)
        intent.putExtra("lat", lat_data)
        intent.putExtra("lon", lon_data)
        Log.e("location",lat_data + " " + lon_data)
        Log.d("IntentQuestionActivity","${intent}")
        startActivity(intent)
        finish()
    }

}
