package com.b2lmobitech.fieldcloudplus.service.v2.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
import com.b2lmobitech.fieldcloudplus.utils.hidden
//import kotlinx.android.synthetic.main.list_category.view.*
import org.json.JSONException

/**
 * Created by home on 10/31/2017.
 */
class CategoryAdapter(var list:List<String> = ArrayList<String>(), val itemClickListener: OnItemClickListener? = null) :
        RecyclerView.Adapter<CategoryAdapter.viewHolder>() {


    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        try {
           holder.textView.text = list.get(holder.adapterPosition)
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    override fun getItemCount(): Int {
        return list.size
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context)
                .inflate(R.layout.list_category, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val textView: TextView = itemView.findViewById(R.id.textView)
        init {
            val completedText: TextView = itemView.findViewById(R.id.completedText)
           completedText.hidden()
            itemView.setOnClickListener { itemClickListener?.itemClicked(adapterPosition) }
        }

    }

}