package com.b2lmobitech.fieldcloudplus.service.v2.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener
//import kotlinx.android.synthetic.main.item_inspection_history.view.*
//import kotlinx.android.synthetic.main.list_category.view.*
import org.json.JSONArray
import org.json.JSONException

/**
 * Created by home on 10/31/2017.
 */
class HistoryAdapter(var jsonArray: JSONArray, val itemClickListener: OnItemClickListener? = null) :
        RecyclerView.Adapter<HistoryAdapter.viewHolder>() {


    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        try {
           holder.itemView.apply {
               jsonArray.getJSONObject(holder.adapterPosition).let {
                   holder.txt_facility_name.text = it.getString("sitename")
                   holder.txt_cat_name.text = it.getString("category_name")
                   holder.txt_date.text = it.getString("assigndate")
               }
           }
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    override fun getItemCount(): Int {
        return jsonArray.length()
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context)
                .inflate(R.layout.item_inspection_history, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        init {
            itemView.setOnClickListener { itemClickListener?.itemClicked(adapterPosition) }
        }
        val txt_facility_name: TextView = itemView.findViewById(R.id.txt_facility_name)
        val txt_cat_name: TextView = itemView.findViewById(R.id.txt_cat_name)
        val txt_date: TextView = itemView.findViewById(R.id.txt_date)
    }

}