package com.b2lmobitech.fieldcloudplus.service.v2.adapter

import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.service.others.SERVICEURL
import com.b2lmobitech.fieldcloudplus.utils.hidden
import com.b2lmobitech.fieldcloudplus.utils.visible
import com.bumptech.glide.Glide
//import kotlinx.android.synthetic.main.item_answer.view.*
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import kotlin.text.substringAfterLast

/**
 * Created by home on 10/31/2017.
 */
class HistoryAnswerAdapter(private val items: List<QuestionWithAnswers>) :
        RecyclerView.Adapter<HistoryAnswerAdapter.viewHolder>() {


    override fun onBindViewHolder(holder: viewHolder, position: Int) {
        try {
           holder.itemView.apply {
               Log.e("jsonArray","$items")
               val item = items[position]
               holder.txt_que.text = "${item.questionOrder}. ${item.questionText}"
               if (item.questionType.equals("signature", ignoreCase = true)) {
                   // Hide text answers
                   holder.txt_ans.visibility = View.GONE
                   holder.imageView2.visible()

                   if (item.answers.isNotEmpty()) {
                       val signatureUrl = "http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/" + item.answers[0]
                       Glide.with(holder.itemView.context)
                           .load(signatureUrl)
                           .into(holder.imageView2)
                   }
               } else if (item.questionType.equals("single choice image", ignoreCase = true)) {
                   // Hide text answers
                   holder.txt_ans.visibility = View.GONE
                   holder.imageView2.visible()

                   if (item.answers.isNotEmpty()) {
                       val signatureUrl = "http://fieldcloud.in/" + item.answers[0]
                       Glide.with(holder.itemView.context)
                           .load(signatureUrl)
                           .into(holder.imageView2)
                   }
               } else if (item.questionType.equals("multiple choice image", ignoreCase = true)) {
                   // Hide text answers
                   holder.txt_ans.visibility = View.GONE
                   holder.imageView2.hidden()
                   holder.linearLayoutImages.visible()
                   holder.linearLayoutImages.removeAllViews() // Clear previous images

                   for (answer in item.answers) {
                       val imageView = ImageView(holder.itemView.context).apply {
                           layoutParams = LinearLayout.LayoutParams(
                               LinearLayout.LayoutParams.WRAP_CONTENT,
                               LinearLayout.LayoutParams.WRAP_CONTENT
                           ).also { it.setMargins(4, 4, 4, 4) }
                       }

                       val imageUrl = "http://fieldcloud.in/$answer"
                       Glide.with(holder.itemView.context)
                           .load(imageUrl)
                           .into(imageView)

                       holder.linearLayoutImages.addView(imageView)
                   }
               } else if(item.questionType.equals("file upload", ignoreCase = true)) {
                   holder.txt_ans.visibility = View.VISIBLE
                   holder.txt_ans.text = item.answers.joinToString("\n") { it.substringAfterLast("_0_") }

                   // Fallback imagepath logic
                   if (!item.imagePath.isNullOrEmpty()) {
                       holder.imageView2.visible()
                       Glide.with(holder.itemView.context)
                           .load(SERVICEURL.ANSWERIMAGE + item.imagePath)
                           .into(holder.imageView2)
                   } else {
                       holder.imageView2.hidden()
                   }
               } else {
                   // Show answers as text
                   holder.txt_ans.visibility = View.VISIBLE
                   holder.txt_ans.text = item.answers.joinToString("\n") { it }

                   // Fallback imagepath logic
                   if (!item.imagePath.isNullOrEmpty()) {
                       holder.imageView2.visible()
                       Glide.with(holder.itemView.context)
                           .load(SERVICEURL.ANSWERIMAGE + item.imagePath)
                           .into(holder.imageView2)
                   } else {
                       holder.imageView2.hidden()
                   }
               }

               if (item.remarks.isNullOrEmpty()) {
                   holder.txt_remarks.visibility = View.GONE
               } else {
                   holder.txt_remarks.visibility = View.VISIBLE
                   holder.txt_remarks.text = "Remarks:- ${item.remarks}"
               }
           }
        } catch (e: JSONException) {
            e.printStackTrace()
        }
    }

    override fun getItemCount(): Int {
        return items.size
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): viewHolder {
        val itemView = LayoutInflater.from(parent.context)
                .inflate(R.layout.item_answer, parent, false)
        return viewHolder(itemView)
    }

    inner class viewHolder(itemView: View) : RecyclerView.ViewHolder(itemView)
    {
        val txt_que: TextView = itemView.findViewById(R.id.txt_que)
        val txt_ans: TextView = itemView.findViewById(R.id.txt_ans)
        val txt_remarks: TextView = itemView.findViewById(R.id.txt_remarks)
        val imageView2: ImageView = itemView.findViewById(R.id.imageView2)
        val linearLayoutImages: LinearLayout = itemView.findViewById(R.id.linearLayoutImages)
    }

}

data class QuestionWithAnswers(
    val questionOrder: String,
    val questionText: String,
    val answers: List<String>,
    val remarks: String?,
    val imagePath: String?,
    val questionType: String,
    val rowIndex: String?
)

fun parseGroupedAnswers(jsonArray: JSONArray): List<QuestionWithAnswers> {
    Log.e("jsonArray","$jsonArray")
    val map = linkedMapOf<String, MutableList<String>>()
    val questionInfo = mutableMapOf<String, JSONObject>()

    for (i in 0 until jsonArray.length()) {
        val obj = jsonArray.getJSONObject(i)
        val qId = obj.getString("question_id")
        val ans = obj.getString("answer")
        map.getOrPut(qId) { mutableListOf() }.add(ans)
        if (!questionInfo.containsKey(qId)) {
            questionInfo[qId] = obj
        }
    }

    val result = mutableListOf<QuestionWithAnswers>()
    map.forEach { (qId, answers) ->
        val obj = questionInfo[qId]!!
        result.add(
            QuestionWithAnswers(
                questionOrder = obj.getString("question_order"),
                questionText = obj.getString("question_text"),
                answers = answers,
                remarks = obj.optString("remarks", ""),
                imagePath = obj.optString("imagepath", ""),
                questionType = obj.optString("answer_type", ""),
                rowIndex = obj.optString("row_index", "0")
            )
        )
    }
    return result
}
