package com.b2lmobitech.fieldcloudplus.serviceold;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstable;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.categorylistadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class CategoryList extends AppCompatActivity {
private Context mycontext;
    private getdynamicquestions mytask = null;
    private getsubmittedcategory gettask = null;
    private String url_get_dynamicquestions="",url_get_categories="",registeredcompany = "",registeredcombinationname="",registeredcombinationtype="",registeredcustomertype="",registeredquestionmode="",registeredemailid="",todaydate="",registeredcustomername="no data available";
    private int status = 0,categorystatus=0;
    private String questionnumber,category,subcategory,question,typeofquestion,count,optionforanswers,dateandtime,correctanswer,questionmode,customertype,combinationname;
    private sqldatabase mDbHelper;
    private ProgressBar progressbar;
    private ListView list;
    private categorylistadapter adapter;
    private ArrayList<String> categorylistvalues,updatedcategories,categoryliststatus;
    private TextView nohistory;
    private Snackbar snackBar;

    MenuItem download;
    MenuItem downloaded;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.content_category_list);
//        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
//        setSupportActionBar(toolbar);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        categoryliststatus = new ArrayList<String>();
        //progressbar = new ProgressBar(mycontext, null, android.R.attr.progressBarStyleSmall);
        progressbar = (ProgressBar)findViewById(R.id.progressBar);
        list = (ListView) findViewById(R.id.categorylist);
        nohistory = (TextView) findViewById(R.id.nohistory);


        Intent intent = getIntent();

        registeredcombinationname = intent.getStringExtra("combinationname");
        registeredcombinationtype = intent.getStringExtra("combinationtype");
        registeredcustomertype = intent.getStringExtra("customertype");
        registeredquestionmode = intent.getStringExtra("questionmode");

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);

        getSupportActionBar().setBackgroundDrawable(
                new ColorDrawable(Color.parseColor("#3F51B5")));

      /*  int titleId = getResources().getIdentifier("action_bar_title", "id", "android");
        TextView abTitle = (TextView) findViewById(titleId);
        abTitle.setTextColor(getResources().getColor(R.color.title_color));*/
    }

    @Override
    protected void onResume() {
        super.onResume();


        SimpleDateFormat dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd");
        todaydate = dateFormatter.format(new Date());
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
      //  registeredcustomername = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_customername, "");

        String[] name_array=registeredcombinationname.split("#@");
        registeredcustomername=name_array[2];
        if(isNetworkAvailable())
        {
            nohistory.setVisibility(View.GONE);
            mDbHelper.delete_dynamicquestionstable();
            mytask = new getdynamicquestions();
            StartAsyncTaskInParallel(mytask);
        }
        else
        {
           // nohistory.setVisibility(View.VISIBLE);
           // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.

        Log.e("Menu inflated","true");

        getMenuInflater().inflate(R.menu.category, menu);

        download = menu.findItem(R.id.download);
        downloaded = menu.findItem(R.id.downloaded);

        download.setVisible(false);
        downloaded.setVisible(false);

        Cursor questioncursorlocal = mDbHelper.get_dynamicquestions_local();
        if(questioncursorlocal==null)
        {
            Log.e("null","true");
            download.setVisible(true);
            downloaded.setVisible(false);
        }
        else{

//            Log.e("not null","true");
//            download.setVisible(false);
//            downloaded.setVisible(true);



            Cursor questionlocal = mDbHelper.get_dynamicquestions_combination(registeredcombinationname,registeredcombinationtype,registeredcustomertype,registeredquestionmode,registeredcustomername,"no data available");
            if(questionlocal==null)
            {

                download.setVisible(false);
                downloaded.setVisible(false);
            }
            else{


                download.setVisible(false);
                downloaded.setVisible(true);
            }
        }


        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();

        switch(id)
        {
            case android.R.id.home:
                onBackPressed();
                break;

            case R.id.download:

                SimpleDateFormat dateFormatter = new SimpleDateFormat
                        ("yyyy-MM-dd");
                todaydate = dateFormatter.format(new Date());

                Cursor questioncursorlocal = mDbHelper.get_dynamicquestions_local();
                if(questioncursorlocal==null)
                {

                    Cursor questioncursor = mDbHelper.get_dynamicquestions_all(registeredcompany,"enable");
              //      if(questioncursor!=null) {
                        if (questioncursor.moveToFirst()) {
                            do {
                                String categoryl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.CATEGORY)));
                                String subcategoryl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.SUBCATEGORY)));
                                String questionnumbersl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.QUESTIONNUMBER)));
                                String questionl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.QUESTION)));
                                String typeofquestionsl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.TYPEOFQUESTION)));
                                String countl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.COUNT)));
                                String optionforanswersl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.OPTIONFORANSWERS)));
                                String correctanswerl = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.CORRECTANSWER)));
                                String dateandtimel = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstable.DATEANDTIME)));
                               Log.e("Insert","called");
                                mDbHelper.insert_dynamicquestionstable_local(registeredcompany, registeredcustomername, "no data available", registeredquestionmode, registeredcustomertype, registeredcombinationname, registeredcombinationtype, categoryl, subcategoryl, questionnumbersl, questionl, typeofquestionsl, countl, optionforanswersl, correctanswerl, dateandtimel,todaydate);


                            } while (questioncursor.moveToNext());
                            //   adapter.clear();

                   //     }

                        download.setVisible(false);
                        downloaded.setVisible(true);
                        questioncursor.close();


                            Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                            intent.putExtra("combinationname",registeredcombinationname);
                            intent.putExtra("combinationtype",registeredcombinationtype);
                            intent.putExtra("questionmode",question);
                            intent.putExtra("customertype",registeredcustomertype);
                            intent.putExtra("customername",registeredcustomername);
                            intent.putExtra("facility","no data available");
                            mycontext.startActivity(intent);
                    }
                 else{
                        Toast.makeText(mycontext,"All Categories are already Inspected!!",Toast.LENGTH_SHORT).show();
                    }

                }else{

                    Toast.makeText(mycontext, "Finish Previous offline inspection!!", Toast.LENGTH_SHORT).show();
                }

                break;

            default:
                break;
        }

        return super.onOptionsItemSelected(item);
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(getdynamicquestions task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getdynamicquestions extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_dynamicquestions"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_dynamicquestions = product.getString("url");


                    List<NameValuePair> getquestionsparams = new ArrayList<NameValuePair>();
                    getquestionsparams.add(new BasicNameValuePair("companyname", registeredcompany ));
               //     getquestionsparams.add(new BasicNameValuePair("customername", registeredcustomername ));
                    getquestionsparams.add(new BasicNameValuePair("combinationname", registeredcombinationname ));
                    getquestionsparams.add(new BasicNameValuePair("customertype", registeredcustomertype ));
                    getquestionsparams.add(new BasicNameValuePair("questionmode", registeredquestionmode ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_dynamicquestions, "GET", getquestionsparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("dynamicquestions"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        for(int i=0;i<countval;i++)
                        {
                            product2 = productObj2.getJSONObject(i);
                            questionnumber = product2.getString("questionnumber");
                            category = product2.getString("category");
                            subcategory = product2.getString("subcategory");
                            question = product2.getString("question");
                            typeofquestion = product2.getString("typeofquestion");
                            count = product2.getString("count");
                            optionforanswers = product2.getString("optionforanswers");
                            correctanswer = product2.getString("correctanswer");
                            dateandtime = product2.getString("dateandtime");
                            questionmode = product2.getString("questionmode");
                            customertype = product2.getString("customertype");
                            combinationname = product2.getString("combinationname");
                            mDbHelper.insert_dynamicquestionstable(registeredcompany,registeredcustomername,questionnumber,category,subcategory,question,typeofquestion,count,optionforanswers,dateandtime,correctanswer,questionmode,customertype,combinationname);
                        }


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            mytask = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
                //Toast.makeText(mycontext,"Data is inserted",Toast.LENGTH_LONG).show();
                //list
                categorylistvalues = new ArrayList<String>();
                Cursor categorycursor = mDbHelper.get_dynamicquestions_category(registeredcompany);
                if(categorycursor.moveToFirst())
                {
                  do{
                      categorylistvalues.add(categorycursor.getString(categorycursor.getColumnIndex(dynamicquestionstable.CATEGORY)) ) ;
                      categoryliststatus.add("disable");
                  }while(categorycursor.moveToNext());
                    adapter = new categorylistadapter(mycontext,categorylistvalues,categoryliststatus,registeredquestionmode,registeredcustomertype,registeredcombinationname,registeredcombinationtype);
                    list.setAdapter(adapter);
                }


                if(isNetworkAvailable())
                {
                    gettask = new getsubmittedcategory();
                    StartAsyncTaskInParallel(gettask);
                }
                else
                {
                   // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }

            }
            else
            {
                nohistory.setVisibility(View.VISIBLE);
                //Toast.makeText(mycontext,"Not found any questions for inspection!!",Toast.LENGTH_LONG).show();
            }

        }
        @Override
        protected void onCancelled() {
            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    //------
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(getsubmittedcategory task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getsubmittedcategory extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            updatedcategories = new ArrayList<String>();
            Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_category"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_categories = product.getString("url");
//
//                    Log.e("companyname", registeredcompany);
//                    Log.e("customername", registeredcustomername );
//                    Log.e("questionmode", registeredquestionmode );
//                    Log.e("customertype", registeredcustomertype );
//                    Log.e("combinationname", registeredcombinationname );
//                    Log.e("emailid", registeredemailid );
//                    Log.e("date", todaydate );


                    List<NameValuePair> getcategoriesparams = new ArrayList<NameValuePair>();
                    getcategoriesparams.add(new BasicNameValuePair("companyname", registeredcompany ));
                    getcategoriesparams.add(new BasicNameValuePair("customername", registeredcustomername ));
                    getcategoriesparams.add(new BasicNameValuePair("questionmode", registeredquestionmode ));
                    getcategoriesparams.add(new BasicNameValuePair("customertype", registeredcustomertype ));
                    getcategoriesparams.add(new BasicNameValuePair("combinationname", registeredcombinationname ));
                    getcategoriesparams.add(new BasicNameValuePair("emailid", registeredemailid ));
                    getcategoriesparams.add(new BasicNameValuePair("date", todaydate ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_categories, "GET", getcategoriesparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("answerstable"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        for(int i=0;i<countval;i++)
                        {
                            product2 = productObj2.getJSONObject(i);
                            updatedcategories.add(product2.getString("category"));

                        }


                        categorystatus = 1;
                    }
                    else
                    {
                        categorystatus = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            mytask = null;
            progressbar.setVisibility(View.GONE);
            if(categorystatus==1)
            {
                for(int i=0;i<categorylistvalues.size();i++)
                {
                    for(int j=0;j<updatedcategories.size();j++)
                    {
                        if(categorylistvalues.get(i).equals(updatedcategories.get(j)))
                        {

                            mDbHelper.update_categories_updated(categorylistvalues.get(i));
                            categoryliststatus.set(i,"enable");
                        }

                    }

                }

               adapter.notifyDataSetChanged();

            }


        }
        @Override
        protected void onCancelled() {
            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
