package com.b2lmobitech.fieldcloudplus.serviceold;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Base64;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.dashboard;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.answerstablelocal;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstablelocal;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.categorylistadapter_offline;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class CategoryList_Offline extends AppCompatActivity {
    private Context mycontext;

    private String url_get_dynamicquestions="",url_get_categories="",registeredcompany = "",registeredcombinationname="",registeredcombinationtype="",registeredcustomertype="",registeredquestionmode="",registeredemailid="",todaydate="",registeredcustomername="no data available",registeredfacility="no data available";
    private int status = 0,categorystatus=0;
    private String questionnumber,category,subcategory,question,typeofquestion,count,optionforanswers,dateandtime,correctanswer,questionmode,customertype,combinationname;
    private sqldatabase mDbHelper;
    private ProgressBar progressbar;
    private ListView list;
    private categorylistadapter_offline adapter;
    private ArrayList<String> categorylistvalues,updatedcategories,categoryliststatus,updatedsync,categorylistsync;
    private TextView nohistory;
    private Snackbar snackBar;

    updatedataintoserver mytask;
    String url_insert_multiplerecords_answerstable;

    MenuItem download;
    MenuItem downloaded;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.content_category_list);
//        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
//        setSupportActionBar(toolbar);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        categoryliststatus = new ArrayList<String>();
        categorylistsync = new ArrayList<String>();
        //progressbar = new ProgressBar(mycontext, null, android.R.attr.progressBarStyleSmall);
        progressbar = (ProgressBar)findViewById(R.id.progressBar);
        list = (ListView) findViewById(R.id.categorylist);
        nohistory = (TextView) findViewById(R.id.nohistory);


        Intent intent = getIntent();

        registeredcombinationname = intent.getStringExtra("combinationname");
        registeredcombinationtype = intent.getStringExtra("combinationtype");
        registeredcustomertype = intent.getStringExtra("customertype");
        registeredquestionmode = intent.getStringExtra("questionmode");
        registeredcustomername = intent.getStringExtra("customername");
        registeredfacility = intent.getStringExtra("facility");

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);


        SimpleDateFormat dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd");
        todaydate = dateFormatter.format(new Date());
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");






        getSupportActionBar().setBackgroundDrawable(
                new ColorDrawable(Color.parseColor("#3F51B5")));

      /*  int titleId = getResources().getIdentifier("action_bar_title", "id", "android");
        TextView abTitle = (TextView) findViewById(titleId);
        abTitle.setTextColor(getResources().getColor(R.color.title_color));*/
    }

    @Override
    protected void onResume() {
        super.onResume();


        nohistory.setVisibility(View.GONE);
        mDbHelper.delete_dynamicquestionstable();

        Cursor questioncursor = mDbHelper.get_dynamicquestions_local_all(registeredcompany);
        if(questioncursor.moveToFirst()) {
            do {
                String categoryl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.CATEGORY)));
                String subcategoryl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.SUBCATEGORY)));
                String questionnumbersl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.QUESTIONNUMBER)));
                String questionl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.QUESTION)));
                String typeofquestionsl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.TYPEOFQUESTION)));
                String countl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.COUNT)));
                String optionforanswersl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.OPTIONFORANSWERS)));
                String correctanswerl=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.CORRECTANSWER)));
                String dateandtimel=(questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.DATEANDTIME)));

                mDbHelper.insert_dynamicquestionstable(registeredcompany,registeredcustomername,questionnumbersl,categoryl,subcategoryl,questionl,typeofquestionsl,countl,optionforanswersl,dateandtimel,correctanswerl,registeredquestionmode,registeredcustomertype,registeredcombinationname);



            } while (questioncursor.moveToNext());
            //   adapter.clear();


            categorylistvalues = new ArrayList<String>();
            Cursor categorycursor = mDbHelper.get_dynamicquestions_category(registeredcompany);
            if(categorycursor.moveToFirst())
            {
                do{
                    categorylistvalues.add(categorycursor.getString(categorycursor.getColumnIndex(dynamicquestionstable.CATEGORY)) ) ;
                    categoryliststatus.add("disable");
                    categorylistsync.add("No");
                }while(categorycursor.moveToNext());
                adapter = new categorylistadapter_offline(mycontext,categorylistvalues,categoryliststatus,registeredquestionmode,registeredcustomertype,registeredcombinationname,registeredcombinationtype,registeredcustomername,registeredfacility,categorylistsync);
                list.setAdapter(adapter);
            }
/////////////////////////////////////////////////////////////////////////

            updatedcategories = new ArrayList<String>();
            updatedsync = new ArrayList<String>();
            Cursor updatedcategorycursor = mDbHelper.get_answers_category(registeredcompany,registeredcombinationname,registeredquestionmode,registeredcustomertype,registeredcustomername,registeredfacility);
            if(updatedcategorycursor.moveToFirst())
            {
                do{
                    updatedcategories.add(updatedcategorycursor.getString(updatedcategorycursor.getColumnIndex(answerstablelocal.CATEGORY)) ) ;
                    updatedsync.add(updatedcategorycursor.getString(updatedcategorycursor.getColumnIndex(answerstablelocal.SYNC)) ) ;

                }while(updatedcategorycursor.moveToNext());

            }


            for(int i=0;i<categorylistvalues.size();i++)
            {
                for(int j=0;j<updatedcategories.size();j++)
                {
                    if(categorylistvalues.get(i).equals(updatedcategories.get(j)))
                    {
                        categoryliststatus.set(i,"enable");
                        categorylistsync.set(i,updatedsync.get(j));
                    }

                }

            }

            adapter.notifyDataSetChanged();


        }

        else{

            nohistory.setVisibility(View.VISIBLE);
        }

    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.

        Log.e("Menu inflated","true");

        getMenuInflater().inflate(R.menu.attendance, menu);

        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();

        switch(id)
        {
            case android.R.id.home:
                onBackPressed();
                break;

            case R.id.attendance_sync:
                try {
                    if(isNetworkAvailable()) {
                        // Toast.makeText(mycontext, "Please wait..", Toast.LENGTH_LONG).show();
                        Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_LONG)
                                .setAction("Action", null).show();
                         mytask = new updatedataintoserver();
                        StartAsyncTaskInParallel(mytask);
                    }
                    else
                    {
                        snackBar.dismiss();
                        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
                        toast();
                    }
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                break;

            default:
                break;
        }

        return super.onOptionsItemSelected(item);
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(updatedataintoserver task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }


    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }

    /////////////////////////////////////////////////////////////////////////////////////

    class updatedataintoserver extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            Snackbar.make(findViewById(android.R.id.content), "Please do not press back..", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();
                List<NameValuePair> insertparams = new ArrayList<NameValuePair>();
                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "insert_answers"));
                JSONArray jsonarray = new JSONArray();

                int insertsuccess = 0;

                Log.e("do in bacg","coming");
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_insert_multiplerecords_answerstable = product.getString("url");

                    Log.e("url",url_insert_multiplerecords_answerstable);


                    Cursor answers_cursor = mDbHelper.get_answerstablelocal_summary(registeredcompany,registeredemailid,"No");
                    if(answers_cursor.moveToFirst())
                    {
                        Log.e("answer table","coming");

                        ArrayList<String> category_sync = new ArrayList<String>();
                        ArrayList<String> subcategory_sync = new ArrayList<String>();
                        ArrayList<String> question_sync = new ArrayList<String>();
                        ArrayList<String> questionumber_sync = new ArrayList<String>();



                        // Log.e("camera string",  globalvariables.getString(answers_cursor.getBlob(answers_cursor.getColumnIndex(answerstable.IMAGE))));

                        do{
                            JSONObject JSONList = new JSONObject();//if you declare outside data vl get replace,so dont chnage from here

                            JSONList.put("companyname",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.COMPANYNAME)));
                            JSONList.put("customername",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.CUSTOMERNAME)));
                            JSONList.put("atmid",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.ATMID)));
                            JSONList.put("emailid",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.EMAILID)));
                            JSONList.put("questionnumber",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.QUESTIONNUMBER)));
                            JSONList.put("category",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.CATEGORY)));
                            JSONList.put("subcategory",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.SUBCATEGORY)));
                            JSONList.put("question",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.QUESTION)));
                            JSONList.put("typeofquestion",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.TYPEOFQUESTION)));
                            JSONList.put("answer",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.ANSWER)));
                            byte[] cam=answers_cursor.getBlob(answers_cursor.getColumnIndex(answerstablelocal.IMAGE));
                            String temp =null;
                            if(cam!=null) {
                                temp = Base64.encodeToString(cam, Base64.DEFAULT);
                                // Log.e("Camera", temp);
                            }
                            JSONList.put("image",temp);
                            JSONList.put("imagepath",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.IMAGEPATH)));
                            JSONList.put("dateandtime",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.DATEANDTIME)));
                            JSONList.put("latitude","no data available");
                            JSONList.put("longitude","no data available");
                            JSONList.put("location","no data available");
                            JSONList.put("issue",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.ISSUE)));

                            JSONList.put("questionmode",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.QUESTIONMODE)));
                            JSONList.put("customertype",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.CUSTOMERTYPE)));
                            JSONList.put("combinationname",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.COMBINATIONNAME)));
                            JSONList.put("combinationtype",registeredcombinationtype);

                            JSONList.put("uniqueid",answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.UNIQUEID)));

                            jsonarray.put(JSONList);
                            //---
                            category_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.CATEGORY)));
                            subcategory_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.SUBCATEGORY)));
                            question_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.QUESTION)));
                            questionumber_sync.add(answers_cursor.getString(answers_cursor.getColumnIndex(answerstablelocal.QUESTIONNUMBER)));

                        }while(answers_cursor.moveToNext());
                        insertparams.add(new BasicNameValuePair("JSON", String.valueOf(jsonarray)));//[{},{}]
                        //{}-Json object,[]-Json array


                        try {
                            JSONObject json_insert = jParser.makeHttpRequest(
                                    url_insert_multiplerecords_answerstable, "POST", insertparams);
                            insertsuccess = json_insert.getInt("success");
//                        message = json_insert.getString("message");

                            if (insertsuccess == 1) {

                                for(int i=0;i<question_sync.size();i++)
                                {
                                    mDbHelper.update_answerstable_local(registeredcompany,registeredcustomername,registeredfacility,registeredemailid,category_sync.get(i),subcategory_sync.get(i),questionumber_sync.get(i),question_sync.get(i));

                                }
                                status = 1;

                            }
                            else
                            {
                                status = 0;

                            }
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();

                        }
                    }

                    answers_cursor.close();
                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products
            if( status == 1)
            {
              //  Toast.makeText(mycontext,"Submitted.",Toast.LENGTH_LONG).show();
              //  finish();

                Cursor answers_synced = mDbHelper.get_answerstablelocal_synced(registeredcompany,registeredemailid,"Yes");
                Cursor question_local =  mDbHelper.get_dynamicquestions_local_all(registeredcompany);

                if(answers_synced.getCount()==question_local.getCount())
                {
                    mDbHelper.delete_dynamicquestions_local_all();
                    mDbHelper.delete_answers_local_all();
                    snackBar.dismiss();
                  //  snackBar = Snackbar.make(findViewById(android.R.id.content), "All Data Synced.", Snackbar.LENGTH_INDEFINITE);
                   // toast();

                    Toast.makeText(mycontext, "All Data Synced", Toast.LENGTH_SHORT).show();

                    Intent intent = new Intent(mycontext, dashboard.class);
                    startActivity(intent);

                }else{

                    onResume();
                }


            }
            else
            {
                //Toast.makeText(mycontext,"Not inserted!!Please try again.",Toast.LENGTH_LONG).show();
                snackBar.dismiss();
                snackBar = Snackbar.make(findViewById(android.R.id.content), "Report is not submitted!!Please try again.", Snackbar.LENGTH_INDEFINITE);
                toast();
            }

            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
        @Override
        protected void onCancelled() {
            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
    }

    /////////////////////////////////////////////////////////////////////////////////////
}
