package com.b2lmobitech.fieldcloudplus.serviceold;


import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.Log;
import android.view.View;

import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.combinationdetailslistadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;


public class CombinationDetails extends AppCompatActivity {

    private ListView list;
    private TextView address,addresstxt,phonetxt,phone;

    private Context mycontext;

    private getaddress getfacility = null;

    private getcompanyaddress getcompany = null;

    private combinationdetailslistadapter adapter;

    private ProgressBar progressbar;

    String url_get_address;

    String company,customer,facility;

    String combinationname,combinationtype,customertype,getcombinationtype;

    String[] type_array;
    String[] name_array;

    private int status =0;

    String facilityaddress,facilitypone;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_combinationdetails);

        mycontext = this;

        Intent intent = getIntent();

        combinationname = intent.getStringExtra("combinationname");
        customertype = intent.getStringExtra("customertype");
        getcombinationtype = intent.getStringExtra("combinationtype");


        char[] ch=getcombinationtype.toCharArray();

        StringBuilder sb=new StringBuilder();
        sb.append("Company");
        for(int i=0;i<ch.length;i++) {
            if(ch[i]=='o')
            {
                sb.append("#@CustomerMode");
            }
            else if(ch[i]=='c')
            {
                sb.append("#@CustomerName");
            }
            else if(ch[i]=='f')
            {
                sb.append("#@Facility");
            }
            else if(ch[i]=='b')
            {
                sb.append("#@Brand");
            }
            else if(ch[i]=='p')
            {
                sb.append("#@Product");
            }
            else if(ch[i]=='m')
            {
                sb.append("#@Module");
            }
            else if(ch[i]=='n')
            {
                sb.append("#@SerialNumber");
            }
            else if(ch[i]=='r')
            {
                sb.append("#@Designation");
            }
            else if(ch[i]=='g')
            {
                sb.append("#@Group");
            }
            else if(ch[i]=='s')
            {
                sb.append("_SubGroup");
            }
            else if(ch[i]=='t')
            {
                sb.append("#@Team");
            }
            else if(ch[i]=='z')
            {
                sb.append("#@Custom");
            }
        }

        combinationtype=sb.toString();


        type_array=combinationtype.split("#@");
        name_array=combinationname.split("#@");


        list = (ListView) findViewById(R.id.combinationlist);
        address = (TextView) findViewById(R.id.address);
        phone = (TextView) findViewById(R.id.phone);
        addresstxt = (TextView) findViewById(R.id.addresstxt);
        phonetxt = (TextView) findViewById(R.id.phonetxt);
        progressbar = (ProgressBar)findViewById(R.id.atmprogressBar);






        if(isNetworkAvailable())
        {
            if(customertype.equalsIgnoreCase("individual"))
            {

                company = name_array[0];
                customer = name_array[2];

                getcompany = new getcompanyaddress();
                StartAsyncTaskInParallel(getcompany);

            }
            else {

                company = name_array[0];
                customer = name_array[2];
                facility = name_array[3];

                getfacility = new getaddress();
                StartAsyncTaskInParallel(getfacility);

            }

        }

        else{
            address.setVisibility(View.GONE);
            phone.setVisibility(View.GONE);
            addresstxt.setVisibility(View.GONE);
            phonetxt.setVisibility(View.GONE);

            adapter = new combinationdetailslistadapter(mycontext,name_array,type_array);//customeraddress
            list.setAdapter(adapter);
        }



        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        // getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }


    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }


    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(getaddress task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }


    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(getcompanyaddress task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getaddress extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_facility_address"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_address = product.getString("url");


                    List<NameValuePair> getatmsparams = new ArrayList<NameValuePair>();
                    getatmsparams.add(new BasicNameValuePair("companyname", company ));
                    getatmsparams.add(new BasicNameValuePair("customername", customer ));
                    getatmsparams.add(new BasicNameValuePair("facility", facility ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_address, "GET", getatmsparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("atmdetails"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();

                        product2 = productObj2.getJSONObject(0);

                        facilitypone=(product2.getString("atmphonenumber"));
                        facilityaddress=(product2.getString("atmaddress")+"-"+product2.getString("atmpincode"));


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            getfacility = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
                address.setVisibility(View.VISIBLE);
                phone.setVisibility(View.VISIBLE);
                addresstxt.setVisibility(View.VISIBLE);
                phonetxt.setVisibility(View.VISIBLE);

                address.setText(facilityaddress);
                phone.setText(facilitypone);
                adapter = new combinationdetailslistadapter(mycontext,name_array,type_array);//customeraddress
                list.setAdapter(adapter);
            }
            else
            {
                address.setVisibility(View.VISIBLE);
                phone.setVisibility(View.VISIBLE);
                addresstxt.setVisibility(View.VISIBLE);
                phonetxt.setVisibility(View.VISIBLE);
                address.setText("Not available");
                phone.setText("Not available");
            }

        }
        @Override
        protected void onCancelled() {
            getfacility = null;
            progressbar.setVisibility(View.GONE);
        }
    }



    class getcompanyaddress extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_company_address"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_address = product.getString("url");

                    Log.e("companyname", company );
                    Log.e("customername", customer);

                    List<NameValuePair> getatmsparams = new ArrayList<NameValuePair>();
                    getatmsparams.add(new BasicNameValuePair("companyname", company ));
                    getatmsparams.add(new BasicNameValuePair("customername", customer ));
                    getatmsparams.add(new BasicNameValuePair("customermode", "Individual" ));


                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_address, "GET", getatmsparams);

                    checkin_success = json_getcheck.getInt("success");

                    Log.e("company address success",String.valueOf(checkin_success));

                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("atmdetails"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();

                        Log.e("count",String.valueOf(countval));

                        product2 = productObj2.getJSONObject(0);

                        facilitypone=(product2.getString("phonenumber"));
                        facilityaddress=(product2.getString("clientaddress")+"-"+product2.getString("pincode"));


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            getfacility = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
                address.setVisibility(View.VISIBLE);
                phone.setVisibility(View.VISIBLE);
                addresstxt.setVisibility(View.VISIBLE);
                phonetxt.setVisibility(View.VISIBLE);
                address.setText(facilityaddress);
                phone.setText(facilitypone);
                adapter = new combinationdetailslistadapter(mycontext,name_array,type_array);//customeraddress
                list.setAdapter(adapter);
            }
            else
            {
                address.setVisibility(View.VISIBLE);
                phone.setVisibility(View.VISIBLE);
                addresstxt.setVisibility(View.VISIBLE);
                phonetxt.setVisibility(View.VISIBLE);
                address.setText("Not available");
                phone.setText("Not available");
            }

        }
        @Override
        protected void onCancelled() {
            getfacility = null;
            progressbar.setVisibility(View.GONE);
        }
    }

}
