package com.b2lmobitech.fieldcloudplus.serviceold;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.dashboard;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.dynamicquestionstablelocal;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class CombinationsList_Offline extends AppCompatActivity {
    private Context mycontext;


    private String url_get_combinations="",registeredcompany = "",registeredquestionmode="",todaydate="",registeredcustomertype="",registeredatmid="",registeredcustomername,registeredfacility,registeredcombinationname,registeredcombinationtype;
    private int status = 0,categorystatus=0;
    private String combinationname[],combinationtype[];
    private sqldatabase mDbHelper;
    private ProgressBar progressbar;
    private ListView list;


    private TextView nohistory;
    private Snackbar snackBar;

    TextView cname;
    TextView ctype;

    ImageView next,delete;
    TextView details;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_combination_list_offline);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);

        //progressbar = new ProgressBar(mycontext, null, android.R.attr.progressBarStyleSmall);
        progressbar = (ProgressBar)findViewById(R.id.progressBar);

        nohistory = (TextView) findViewById(R.id.nohistory);

        cname = (TextView) findViewById(R.id.c_name);
        ctype = (TextView) findViewById(R.id.c_type);
        next = (ImageView) findViewById(R.id.next);
        delete = (ImageView) findViewById(R.id.delete);
       details = (TextView) findViewById(R.id.details);

        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);

        SimpleDateFormat dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd");


        todaydate = dateFormatter.format(new Date());
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredatmid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_atmid, "");

        Cursor questioncursor = mDbHelper.get_dynamicquestions_local();
        if(questioncursor==null)
        {
            nohistory.setVisibility(View.VISIBLE);
            cname.setVisibility(View.GONE);
            ctype.setVisibility(View.GONE);
            next.setVisibility(View.GONE);
            delete.setVisibility(View.GONE);
            details.setVisibility(View.GONE);
        }
        else {

            if (questioncursor.moveToFirst()) {


                registeredquestionmode = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.QUESTIONMODE)));
                registeredcustomertype = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.CUSTOMERTYPE)));
                registeredcustomername = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.CUSTOMERNAME)));
                registeredfacility= (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.FACILITY)));
                registeredcombinationname = (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.COMBINATIONNAME)));
                registeredcombinationtype= (questioncursor.getString(questioncursor.getColumnIndex(dynamicquestionstablelocal.COMBINATIONTYPE)));

              //  adapter = new combinationlistadapterlocal(mycontext,registeredcombinationname,registeredcombinationtype,registeredquestionmode,registeredcustomertype,registeredcustomername,registeredfacility);
               // list.setAdapter(adapter);

                cname.setText(registeredcombinationname);

                char[] ch=registeredcombinationtype.toCharArray();

                StringBuilder sb=new StringBuilder();
                sb.append("Company");
                for(int i=0;i<ch.length;i++) {
                    if(ch[i]=='o')
                    {
                        sb.append("#@CustomerMode");
                    }
                    else if(ch[i]=='c')
                    {
                        sb.append("#@CustomerName");
                    }
                    else if(ch[i]=='f')
                    {
                        sb.append("#@Facility");
                    }
                    else if(ch[i]=='b')
                    {
                        sb.append("#@Brand");
                    }
                    else if(ch[i]=='p')
                    {
                        sb.append("#@Product");
                    }
                    else if(ch[i]=='m')
                    {
                        sb.append("#@Module");
                    }
                    else if(ch[i]=='n')
                    {
                        sb.append("#@SerialNumber");
                    }
                    else if(ch[i]=='r')
                    {
                        sb.append("#@Designation");
                    }
                    else if(ch[i]=='g')
                    {
                        sb.append("#@Group");
                    }
                    else if(ch[i]=='s')
                    {
                        sb.append("#@SubGroup");
                    }
                    else if(ch[i]=='t')
                    {
                        sb.append("#@Team");
                    }
                    else if(ch[i]=='z')
                    {
                        sb.append("#@Custom");
                    }
                }

               ctype.setText(sb.toString());


              next.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                        intent.putExtra("combinationname",registeredcombinationname);
                        intent.putExtra("combinationtype",registeredcustomertype);
                        intent.putExtra("questionmode",registeredquestionmode);
                        intent.putExtra("customertype",registeredcustomertype);
                        intent.putExtra("customername",registeredcustomername);
                        intent.putExtra("facility",registeredfacility);
                        mycontext.startActivity(intent);
                    }
                });


                delete.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {

                        AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                        alertdialog.setTitle("Are you sure?");
                        alertdialog.setIcon(R.drawable.ic_action_delete);
                        alertdialog.setMessage("Erase all data from local inspections");
                        alertdialog.setPositiveButton("Yes",
                                new DialogInterface.OnClickListener() {
                                    public void onClick(DialogInterface dialog, int whichButton)
                                    {

                                        mDbHelper.delete_dynamicquestions_local_all();
                                        mDbHelper.delete_answers_local_all();

                                        Intent intent = new Intent(mycontext, dashboard.class);
                                        startActivity(intent);

                                    }
                                });
                        alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                // TODO Auto-generated method stub

                            }
                        }).create();
                        alertdialog.show();

                    }
                });

                details.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {


                        if(registeredquestionmode.equalsIgnoreCase("customer"))
                        {
                            Intent intent = new Intent(mycontext, CombinationDetails.class);

                            intent.putExtra("combinationname",registeredcombinationname);
                            intent.putExtra("combinationtype",registeredcombinationtype);
                            intent.putExtra("customertype",registeredcustomertype);

                            mycontext.startActivity(intent);
                        }
                        else{

                            Intent intent = new Intent(mycontext, Local_CombinationDetails.class);
                            intent.putExtra("combinationname",registeredcombinationname);
                            intent.putExtra("combinationtype",registeredcombinationtype);
                            intent.putExtra("customername",registeredcustomername);
                            intent.putExtra("facility",registeredfacility);
                            mycontext.startActivity(intent);
                        }





                    }
                });

            }
        }
    }

    @Override
    protected void onResume() {
        super.onResume();



    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.combination, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        // int id = item.getItemId();

        //noinspection SimplifiableIfStatement
//        if (id == an) {
//
//        }
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;

        }
        return  true;
        //return super.onOptionsItemSelected(item);
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }


    //------



    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
