package com.b2lmobitech.fieldcloudplus.serviceold;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;

import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.preventivelistadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


public class EmployeeList extends AppCompatActivity {

    private Context mycontext;


    String registeredcompany,registeredemailid;



    String[] emailid;
    String[] category;
    String[] facility;
    String[] customername;
    String[] location;
    String[] questionmode;
    String[] combinationname;
    String[] typename;

    ListView preventivelistview;
    TextView result;



    private ProgressDialog pDialog;


    JSONArray tickets = null;

    JSONParser jsonParser = new JSONParser();




    private static final String ALL_TICKET_URL ="http://fieldcloud.in/App/get_preventivedetails.php";



    private static final String TICKET_SUCCESS = "success";
    private static final String TICKET_MESSAGE = "message";



    JSONArray products = null;




    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_employeelist);

        mycontext = this;


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        result=(TextView) findViewById(R.id.result);
        preventivelistview=(ListView) findViewById(R.id.preventivelistview);



        if(isNetworkAvailable())
        {

            new GetPreventiveDetail().execute();
        }
        else
        {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();
        }



      /*  issueslistadapter adapter =new

                issueslistadapter(TicketList.this, ticketnumber,customername,facility,emailid,question,answer,location,questionmode,questiontype,combinationname,typename);


        issueslistview.setAdapter(adapter);*/

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }




    class GetPreventiveDetail extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(EmployeeList.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));



                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_TICKET_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {



                        customername=new String[count];
                        facility=new String[count];
                        emailid=new String[count];
                        category=new String[count];
                        location=new String[count];
                        questionmode=new String[count];
                        combinationname=new String[count];
                        typename=new String[count];


                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);


                            customername[i]=photoobj.getString("customername");
                            facility[i]=photoobj.getString("atmid");
                            emailid[i]=photoobj.getString("emailid");
                            category[i]=photoobj.getString("category");
                            location[i]=photoobj.getString("location");
                            questionmode[i]=photoobj.getString("questionmode");
                            combinationname[i]=photoobj.getString("combinationname");
                            typename[i]=photoobj.getString("typename");



                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();
if(customername==null)
{
    result.setVisibility(View.VISIBLE);
    result.setText("No Inspections Done Today!");
    preventivelistview.setVisibility(View.GONE);
}
else {
    preventivelistadapter adapter = new

            preventivelistadapter(EmployeeList.this,  emailid,customername, facility, category,location, questionmode, combinationname, typename);

    preventivelistview.setAdapter(adapter);


    preventivelistview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

        @Override

        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

                Date date = new Date();
                Calendar c = Calendar.getInstance();
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                String todaydate= df1.format(c.getTime());

                Intent intent = new Intent(mycontext, inspectionreport.class);

            intent.putExtra("date", todaydate);
            intent.putExtra("customername", customername[position]);
            intent.putExtra("facility", facility[position]);
            intent.putExtra("category", category[position]);
            intent.putExtra("questionmode", questionmode[position]);
            intent.putExtra("combinationname", combinationname[position]);
            intent.putExtra("typename", typename[position]);
            intent.putExtra("emailid", emailid[position]);


                mycontext.startActivity(intent);

        }
    });
}
        }
    }





}
