package com.b2lmobitech.fieldcloudplus.serviceold;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.employee_combinationlistadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

public class Employee_CombinationList extends AppCompatActivity {
    private Context mycontext;
    private getCombinationList mytask = null;

    private String url_get_combinations="",registeredcompany = "",registeredquestionmode,todaydate="",registeredatmid="";
    private int status = 0,categorystatus=0;
    private String combinationname[],combinationtype[];

    private String new_combinationname[],new_combinationtype[];

    private String group,subgroup,team,designation;

    private sqldatabase mDbHelper;
    private ProgressBar progressbar;
    private ListView list;
    private employee_combinationlistadapter adapter;
    private ArrayList<String> combinationnamelist,combinationtypelist;
    private TextView nohistory;
    private Snackbar snackBar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_combination_list);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        mycontext = this;
        mDbHelper = new sqldatabase(mycontext);
        combinationnamelist = new ArrayList<String>();
        combinationtypelist = new ArrayList<String>();
        //progressbar = new ProgressBar(mycontext, null, android.R.attr.progressBarStyleSmall);
        progressbar = (ProgressBar)findViewById(R.id.progressBar);
        list = (ListView) findViewById(R.id.categorylist);
        nohistory = (TextView) findViewById(R.id.nohistory);
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
//        SimpleDateFormat dateFormatter = new SimpleDateFormat
//                ("yyyy-MM-dd");
//        todaydate = dateFormatter.format(new Date());
//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
      //  getSupportActionBar().setDisplayHomeAsUpEnabled(true);
//        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
//        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
//        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
//        if(isNetworkAvailable())
//        {
//            mDbHelper.delete_dynamicquestionstable();
//                       mytask = new getdynamicquestions();
//                       StartAsyncTaskInParallel(mytask);
//        }
//        else
//        {
//            Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
//        }

    }

    @Override
    protected void onResume() {
        super.onResume();
        SimpleDateFormat dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd");
        todaydate = dateFormatter.format(new Date());
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredatmid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_atmid, "");

        group = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_group, "");
        subgroup = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_subgroup, "");
        team = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_team, "");
        designation = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_designation, "");

        Log.e("group",group);
        Log.e("subgroup",subgroup);
        Log.e("team",team);
        Log.e("designation",designation);

        Intent intent = getIntent();

        registeredquestionmode = intent.getStringExtra("questionmode");

        if(isNetworkAvailable())
        {
            nohistory.setVisibility(View.GONE);
            mytask = new getCombinationList();
            StartAsyncTaskInParallel(mytask);
        }
        else
        {
            // nohistory.setVisibility(View.VISIBLE);
            // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.combination, menu);
        return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        // int id = item.getItemId();

        //noinspection SimplifiableIfStatement
//        if (id == an) {
//
//        }
        switch (item.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;

        }
        return  true;
        //return super.onOptionsItemSelected(item);
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(getCombinationList task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class getCombinationList extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
            Snackbar.make(findViewById(android.R.id.content), "Please wait..", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_product_combinations"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_combinations = product.getString("url");


                    List<NameValuePair> getquestionsparams = new ArrayList<NameValuePair>();
                    getquestionsparams.add(new BasicNameValuePair("companyname", registeredcompany ));
                    getquestionsparams.add(new BasicNameValuePair("questionmode", registeredquestionmode ));


                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_combinations, "GET", getquestionsparams);

                    checkin_success = json_getcheck.getInt("success");

                    Log.e("checkin_success",String.valueOf(checkin_success));


                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("dynamicquestions"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();

                        combinationname=new String[countval];
                        combinationtype=new String[countval];

                        Log.e("countval",String.valueOf(countval));

                        for(int i=0;i<countval;i++)
                        {
                            product2 = productObj2.getJSONObject(i);
                            combinationname[i]=product2.getString("combinationname");
                            combinationtype[i] = product2.getString("combinationtype");

                        }


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            mytask = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
                //Toast.makeText(mycontext,"Data is inserted",Toast.LENGTH_LONG).show();
                //list

                int newcombinationcount=0;

                String[] team_array=team.split(",");


                for(int i=0;i<combinationname.length;i++)
                {

                    if(combinationtype[i].toLowerCase().contains("t")) {

                        if(combinationtype[i].toLowerCase().contains("s") && subgroup!=null) {

                            for (int j = 0; j < team_array.length; j++) {
                                if (combinationname[i].toLowerCase().contains(group.toLowerCase()) && combinationname[i].toLowerCase().contains(subgroup.toLowerCase()) && combinationname[i].toLowerCase().contains(team_array[j].toLowerCase())) {
                                    newcombinationcount++;
                                }
                            }
                        }

                        else{

                            for (int j = 0; j < team_array.length; j++) {
                                if (combinationname[i].toLowerCase().contains(group.toLowerCase()) && combinationname[i].toLowerCase().contains(team_array[j].toLowerCase())) {
                                    newcombinationcount++;
                                }
                            }
                        }
                    }
                    else{
                        if (combinationname[i].toLowerCase().contains(designation.toLowerCase())) {
                            newcombinationcount++;
                        }
                    }
                }

                if(newcombinationcount>0) {

                    new_combinationname = new String[newcombinationcount];
                    new_combinationtype = new String[newcombinationcount];

                    int j = 0;

                    for (int i = 0; i < combinationname.length; i++) {

                        if(combinationtype[i].toLowerCase().contains("t")) {

                            if(combinationtype[i].toLowerCase().contains("s") && subgroup!=null) {

                                for (int k = 0; k < team_array.length; k++) {

                                    if (combinationname[i].toLowerCase().contains(group.toLowerCase()) && combinationname[i].toLowerCase().contains(subgroup.toLowerCase()) && combinationname[i].toLowerCase().contains(team_array[k].toLowerCase())) {

                                        new_combinationname[j] = combinationname[i];
                                        new_combinationtype[j] = combinationtype[i];

                                        j++;
                                    }
                                }
                            }
                            else{

                                for (int k = 0; k < team_array.length; k++) {

                                    if (combinationname[i].toLowerCase().contains(group.toLowerCase()) && combinationname[i].toLowerCase().contains(team_array[k].toLowerCase())) {

                                        new_combinationname[j] = combinationname[i];
                                        new_combinationtype[j] = combinationtype[i];

                                        j++;
                                    }
                                }
                            }
                        }

                        else{



                            if (combinationname[i].toLowerCase().contains(designation.toLowerCase()) ) {

                                new_combinationname[j] = combinationname[i];
                                new_combinationtype[j] = combinationtype[i];

                                j++;
                            }
                        }
                    }


                    combinationnamelist = new ArrayList<String>(Arrays.asList(new_combinationname));
                    combinationtypelist = new ArrayList<String>(Arrays.asList(new_combinationtype));

                    adapter = new employee_combinationlistadapter(mycontext, combinationnamelist, combinationtypelist, registeredquestionmode);
                    list.setAdapter(adapter);

                }

                else
                {
                    nohistory.setVisibility(View.VISIBLE);
                    //Toast.makeText(mycontext,"Not found any questions for inspection!!",Toast.LENGTH_LONG).show();
                }

            }
            else
            {
                nohistory.setVisibility(View.VISIBLE);
                //Toast.makeText(mycontext,"Not found any questions for inspection!!",Toast.LENGTH_LONG).show();
            }

        }
        @Override
        protected void onCancelled() {
            mytask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    //------



    @Override
    protected void onDestroy() {
        mDbHelper.close();
        super.onDestroy();
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
