package com.b2lmobitech.fieldcloudplus.serviceold;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.google.android.material.snackbar.Snackbar;
import androidx.core.app.ActivityCompat;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.Log;
import android.view.View;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.facility_atmlistadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.others.utils.parser.Jsonparser;

public class Facility_ATMlistactivity extends AppCompatActivity {
    private ProgressBar progressbar;
    private ListView list;
    private TextView nohistory;
    private ArrayList<String> atmids,atmphonenumbers,atmaddress,atmqrcode,atmlatitude,atmlongitude;
    private String registeredcompany="",registeredemailid="",url_get_atmids="",Customername="",Customertype="",questionmode,combinationname,combinationtype;
    private Context mycontext;
    private  atmlist gettask = null;
    private int status =0;
    private facility_atmlistadapter adapter;
    public static Context atmlistactivitycontext;
    //--Location
    private LocationManager locationManager;
    private LocationListener locationListener;
    private boolean isGPSEnabled = false;
    private boolean isNetworkEnabled = false;
    private boolean canGetLocation = false;
    // The minimum distance to change Updates in meters
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10; // 10 meters
    // The minimum time between updates in milliseconds
    private static final long MIN_TIME_BW_UPDATES = 1000 * 60 * 1;
    private Location location;
    private boolean running = false;
    private String currentlocation = "Not found";
    private Double currentlocationlaltitue = 0.0, currentlocationlongitude = 0.0;
    private List<Address> addresses = null;
    private static final AndroidHttpClient ANDROID_HTTP_CLIENT = AndroidHttpClient.newInstance(ATMlistactivity.class.getName());
    private Bitmap Customericon;
    private Snackbar snackBar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_atmlistactivity);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

//        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
//        fab.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
//                        .setAction("Action", null).show();
//            }
//        });
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        mycontext = this;
        atmlistactivitycontext = this;
        progressbar = (ProgressBar)findViewById(R.id.atmprogressBar);
        list = (ListView) findViewById(R.id.atmlist);
        nohistory = (TextView) findViewById(R.id.nohistory);
        atmids = new ArrayList<String>();
        atmphonenumbers = new ArrayList<String>();
        atmaddress = new ArrayList<String>();
        atmqrcode = new ArrayList<String>();
        atmlatitude = new ArrayList<String>();
        atmlongitude = new ArrayList<String>();


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        //  Customername = getIntent().getExtras().getString("Customername","");
        snackBar = Snackbar.make(findViewById(android.R.id.content), "Please check internet connection", Snackbar.LENGTH_INDEFINITE);

        // byte[] byteArray = getIntent().getExtras().getByteArray("Customericon");

        Intent intent = getIntent();

        Customername = intent.getStringExtra("Customername");
        Customertype = intent.getStringExtra("Customertype");
        questionmode = intent.getStringExtra("questionmode");
        combinationname = intent.getStringExtra("combinationname");
        combinationtype = intent.getStringExtra("combinationtype");

        Log.e("facility_atmlist",combinationtype);

        byte[] byteArray = intent.getByteArrayExtra("Customericon");

        if(byteArray==null)
        {
            Customericon = null;
        }
        else {
            Bitmap bmp = BitmapFactory.decodeByteArray(byteArray, 0, byteArray.length);
            Customericon = bmp;
        }
        //Toast.makeText(mycontext,Customername,Toast.LENGTH_LONG).show();
        if(isNetworkAvailable())
        {
            nohistory.setVisibility(View.GONE);
            gettask = new atmlist();
            StartAsyncTaskInParallel(gettask);
        }
        else
        {
            nohistory.setVisibility(View.VISIBLE);
            // Toast.makeText(mycontext,"Please check the internet connection",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),  "Please check internet connection", Snackbar.LENGTH_INDEFINITE);
            toast();
        }
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void StartAsyncTaskInParallel(atmlist task) {
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB)
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        else
            task.execute();
    }

    class atmlist extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressbar.setVisibility(View.VISIBLE);
        }



        /**
         * getting particular products from url
         * */
        protected String doInBackground(String... args) {
            try {
                Jsonparser jParser = new Jsonparser();

                List<NameValuePair> getparams = new ArrayList<NameValuePair>();
                getparams.add(new BasicNameValuePair("type", "App"));
                getparams.add(new BasicNameValuePair("keyword", "get_atms"));

                int checkin_success = 0;
                // Building Parameters
                JSONObject json_get = jParser.makeHttpRequest(
                        globalvariables.url_get_url, "GET", getparams);

                int getsuccess = json_get.getInt("success");
                if (getsuccess == 1) {
                    JSONArray productObj = json_get.getJSONArray("url"); // JSON Array

                    JSONObject product = null;

                    //int	countval = productObj.length();
                    product = productObj.getJSONObject(0);
                    url_get_atmids = product.getString("url");


                    List<NameValuePair> getatmsparams = new ArrayList<NameValuePair>();
                    getatmsparams.add(new BasicNameValuePair("companyname", registeredcompany ));
                    getatmsparams.add(new BasicNameValuePair("customername", Customername ));

                    JSONObject json_getcheck = jParser.makeHttpRequest(
                            url_get_atmids, "GET", getatmsparams);

                    checkin_success = json_getcheck.getInt("success");
                    if (checkin_success == 1) {
                        JSONArray productObj2 = json_getcheck.getJSONArray("atmdetails"); // JSON Array

                        JSONObject product2 = null;

                        int	countval = productObj2.length();
                        for(int i=0;i<countval;i++)
                        {
                            product2 = productObj2.getJSONObject(i);
                            atmids.add(product2.getString("atmid"));
                            atmphonenumbers.add(product2.getString("atmphonenumber"));
                            atmaddress.add(product2.getString("atmaddress")+"-"+product2.getString("atmpincode"));
                            atmqrcode.add(product2.getString("qrcode"));
                            atmlatitude.add(product2.getString("latitude"));
                            atmlongitude.add(product2.getString("longitude"));

                        }


                        status = 1;
                    }
                    else
                    {
                        status = 0;
                    }

                }


            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();

            }




            return null;
        }


        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog after getting all products

            gettask = null;
            progressbar.setVisibility(View.GONE);
            if(status==1)
            {
                nohistory.setVisibility(View.GONE);
                adapter = new facility_atmlistadapter(mycontext,atmids,atmaddress,atmphonenumbers,atmqrcode,atmlatitude,atmlongitude,Customername,Customericon,Customertype,questionmode,combinationname,combinationtype);//customeraddress
                list.setAdapter(adapter);
            }
            else
            {
                nohistory.setVisibility(View.VISIBLE);
            }

        }
        @Override
        protected void onCancelled() {
            gettask = null;
            progressbar.setVisibility(View.GONE);
        }
    }
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {

        if (requestCode == 0) {
//				Log.d("requestCode", ""+requestCode);

            if (resultCode == RESULT_OK) {
//			    	  Log.d("RESULT_OK", "RESULT_OK");
                String contents = intent.getStringExtra("SCAN_RESULT");
                if(contents.equals(facility_atmlistadapter.wantedqrcode))
                {
                    // Toast.makeText(mycontext,"QRcode matched.Please wait..",Toast.LENGTH_LONG).show();
                    Snackbar.make(findViewById(android.R.id.content), "QRcode matched.Please wait..", Snackbar.LENGTH_LONG)
                            .setAction("Action", null).show();
                    findlocation();
                }
                else
                {
                    // Toast.makeText(mycontext,"QRcode not matched",Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content),  "QRcode not matched", Snackbar.LENGTH_INDEFINITE);
                    toast();
                }


            } else if (resultCode == RESULT_CANCELED) {
                // Handle cancel

            }
            else
            {
                Uri marketUri = Uri.parse("market://details?id=com.google.zxing.client.android");
                Intent marketIntent = new Intent(Intent.ACTION_VIEW,marketUri);
                startActivity(marketIntent);
            }
        }

    }
    public void findlocation()
    {

        try {
//				Log.d("findlocation","findlocation");
            final Geocoder geocoder = new Geocoder(mycontext, Locale.getDefault());
            locationManager = (LocationManager) mycontext.getSystemService(Context.LOCATION_SERVICE);

            locationListener = new LocationListener() {

                @Override
                public void onStatusChanged(String provider, int status, Bundle extras) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onProviderEnabled(String provider) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onProviderDisabled(String provider) {
                    // TODO Auto-generated method stub

                }

                @Override
                public void onLocationChanged(android.location.Location location) {
                    // TODO Auto-generated method stub

                }
            };
            // getting GPS status
            isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
//            if(!isGPSEnabled)
//            {
//                Toast.makeText(mycontext,"Turn your GPS 'ON' for location access", Toast.LENGTH_LONG).show();
//            }
            // getting network status
            isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
            try {
                if (!isGPSEnabled && !isNetworkEnabled) {
                    // no network provider is enabled
                    // Toast.makeText(mycontext,"Turn your GPS 'ON' for location access (or)data network for internet", Toast.LENGTH_LONG).show();
                    snackBar.dismiss();
                    snackBar = Snackbar.make(findViewById(android.R.id.content), "Turn your GPS 'ON' for location access (or)data network for internet", Snackbar.LENGTH_INDEFINITE);
                    toast();
                } else {
                    this.canGetLocation = true;
                    if(!(isNetworkAvailable()))
                    {
                        // Toast.makeText(mycontext,"Please check the internet connection", Toast.LENGTH_LONG).show();
                        Snackbar.make(findViewById(android.R.id.content), "Please check the internet connection", Snackbar.LENGTH_LONG)
                                .setAction("Action", null).show();
                    }
                    // First get location from Network Provider
                    if (isNetworkEnabled) {
                        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                            // TODO: Consider calling
                            //    ActivityCompat#requestPermissions
                            // here to request the missing permissions, and then overriding
                            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
                            //                                          int[] grantResults)
                            // to handle the case where the user grants the permission. See the documentation
                            // for ActivityCompat#requestPermissions for more details.
                            return;
                        }
                        locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                        if (locationManager != null) {
                            location = locationManager
                                    .getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
                            if (location != null) {
                                currentlocationlaltitue = location.getLatitude();
                                currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                checkinglocationvalue(currentlocationlaltitue,currentlocationlongitude);
                                try {
                                    addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                    Address address = addresses.get(0);
                                    ArrayList<String> addressFragments = new ArrayList<String>();
                                    // Fetch the address lines using getAddressLine,
                                    // join them, and send them to the thread.
                                    for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                        addressFragments.add(address.getAddressLine(i));
                                    }
                                    currentlocation = addressFragments.toString();
                                } catch (Exception e) {
                                    // TODO Auto-generated catch block
//										e.printStackTrace();
                                    fetchCityName(mycontext, location);
                                }
                            }


                            else{

                                locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                                if (locationManager != null) {
                                    location = locationManager
                                            .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                    if (location != null) {
                                        currentlocationlaltitue = location.getLatitude();
                                        currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                        checkinglocationvalue(currentlocationlaltitue,currentlocationlongitude);
                                        try {
                                            addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                            Address address = addresses.get(0);
                                            ArrayList<String> addressFragments = new ArrayList<String>();
                                            // Fetch the address lines using getAddressLine,
                                            // join them, and send them to the thread.
                                            for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                                addressFragments.add(address.getAddressLine(i));
                                            }
                                            currentlocation = addressFragments.toString();
                                        } catch (Exception e) {
                                            // TODO Auto-generated catch block
//										e.printStackTrace();
                                            fetchCityName(mycontext, location);
                                        }
                                    }
                                }
                            }
                        }


                        else{

                            locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                            if (locationManager != null) {
                                location = locationManager
                                        .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                if (location != null) {
                                    currentlocationlaltitue = location.getLatitude();
                                    currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                    checkinglocationvalue(currentlocationlaltitue,currentlocationlongitude);
                                    try {
                                        addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                        Address address = addresses.get(0);
                                        ArrayList<String> addressFragments = new ArrayList<String>();
                                        // Fetch the address lines using getAddressLine,
                                        // join them, and send them to the thread.
                                        for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                            addressFragments.add(address.getAddressLine(i));
                                        }
                                        currentlocation = addressFragments.toString();
                                    } catch (Exception e) {
                                        // TODO Auto-generated catch block
//										e.printStackTrace();
                                        fetchCityName(mycontext, location);
                                    }
                                }
                            }
                        }
                    }
                    // if GPS Enabled get lat/long using GPS Services
                    if (isGPSEnabled) {
                        if (location == null) {
                            locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
//					             Log.d("GPS Enabled", "GPS Enabled");
                            if (locationManager != null) {
                                location = locationManager
                                        .getLastKnownLocation(LocationManager.GPS_PROVIDER);
                                if (location != null) {
                                    currentlocationlaltitue = location.getLatitude();
                                    currentlocationlongitude = location.getLongitude();
                                    checkinglocationvalue(currentlocationlaltitue,currentlocationlongitude);
                                    try {
                                        addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                        Address address = addresses.get(0);
                                        ArrayList<String> addressFragments = new ArrayList<String>();
                                        // Fetch the address lines using getAddressLine,
                                        // join them, and send them to the thread.
                                        for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                            addressFragments.add(address.getAddressLine(i));
                                        }
                                        currentlocation = addressFragments.toString();
                                    } catch (Exception e) {
                                        // TODO Auto-generated catch block
//											e.printStackTrace();
                                        fetchCityName(mycontext, location);
                                    }

                                }

                                else{

                                    locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                                    if (locationManager != null) {
                                        location = locationManager
                                                .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                        if (location != null) {
                                            currentlocationlaltitue = location.getLatitude();
                                            currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                            checkinglocationvalue(currentlocationlaltitue,currentlocationlongitude);
                                            try {
                                                addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                                Address address = addresses.get(0);
                                                ArrayList<String> addressFragments = new ArrayList<String>();
                                                // Fetch the address lines using getAddressLine,
                                                // join them, and send them to the thread.
                                                for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                                    addressFragments.add(address.getAddressLine(i));
                                                }
                                                currentlocation = addressFragments.toString();
                                            } catch (Exception e) {
                                                // TODO Auto-generated catch block
//										e.printStackTrace();
                                                fetchCityName(mycontext, location);
                                            }
                                        }
                                    }
                                }
                            }

                            else{

                                locationManager.requestLocationUpdates(LocationManager.PASSIVE_PROVIDER, MIN_TIME_BW_UPDATES, MIN_DISTANCE_CHANGE_FOR_UPDATES, locationListener);
                                if (locationManager != null) {
                                    location = locationManager
                                            .getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
                                    if (location != null) {
                                        currentlocationlaltitue = location.getLatitude();
                                        currentlocationlongitude = location.getLongitude();
//					            	 Log.d("currentlocationlaltitue", ""+currentlocationlaltitue);
//					            	 Log.d("currentlocationlongitude", ""+currentlocationlongitude);
                                        checkinglocationvalue(currentlocationlaltitue,currentlocationlongitude);
                                        try {
                                            addresses = geocoder.getFromLocation(currentlocationlaltitue, currentlocationlongitude, 1); // Here 1 represent max location result to returned, by documents it recommended 1 to 5

                                            Address address = addresses.get(0);
                                            ArrayList<String> addressFragments = new ArrayList<String>();
                                            // Fetch the address lines using getAddressLine,
                                            // join them, and send them to the thread.
                                            for(int i = 0; i < address.getMaxAddressLineIndex(); i++) {
                                                addressFragments.add(address.getAddressLine(i));
                                            }
                                            currentlocation = addressFragments.toString();
                                        } catch (Exception e) {
                                            // TODO Auto-generated catch block
//										e.printStackTrace();
                                            fetchCityName(mycontext, location);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } catch (Exception e1) {
                // TODO Auto-generated catch block
//					e1.printStackTrace();
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
//				e.printStackTrace();
        }


    }
    public void fetchCityName(final Context contex, final android.location.Location location)
    {
//		  Log.d("fetchCityName", "fetchCityName");
        if (running)
            return;

        new AsyncTask<Void, Void, String>()
        {
            protected void onPreExecute()
            {
                running = true;
            };

            @Override
            protected String doInBackground(Void... params)
            {
                String cityName = null;


                if (Geocoder.isPresent())
                {
                    try
                    {
                        Geocoder geocoder = new Geocoder(contex, Locale.getDefault());
                        List<Address> addresses = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
                        if (addresses.size() > 0)
                        {
                            cityName = addresses.get(0).getLocality();
                        }
                    }
                    catch (Exception ignored)
                    {
                        // after a while, Geocoder start to trhow "Service not availalbe" exception. really weird since it was working before (same device, same Android version etc..
                    }
                }

                if (cityName != null) // i.e., Geocoder succeed
                {
                    return cityName;
                }
                else // i.e., Geocoder failed
                {
                    return fetchCityNameUsingGoogleMap();
                }
            }

            // Geocoder failed :-(
            // Our B Plan : Google Map
            private String fetchCityNameUsingGoogleMap()
            {
                String googleMapUrl = "http://maps.googleapis.com/maps/api/geocode/json?latlng=" + location.getLatitude() + ","
                        + location.getLongitude() + "&sensor=false&language=fr";

                try
                {
                    JSONObject googleMapResponse = new JSONObject(ANDROID_HTTP_CLIENT.execute(new HttpGet(googleMapUrl),
                            new BasicResponseHandler()));

                    // many nested loops.. not great -> use expression instead
                    // loop among all results
                    JSONArray results = (JSONArray) googleMapResponse.get("results");
                    String cityName = results.getJSONObject(0).getString("formatted_address");
//	                    Log.d("address check", results.getJSONObject(0).getString("formatted_address"));

                    return cityName;
                }
                catch (Exception ignored)
                {
                    ignored.printStackTrace();
                }
                return null;
            }

            protected void onPostExecute(String cityName)
            {
                running = false;
//	                Toast.makeText(mycontext, "cityName"+cityName, Toast.LENGTH_LONG).show();
                if (cityName != null)
                {
                    // Do something with cityName
//	                    Log.i("GeocoderHelper", cityName);
//	                    alertdialog(cityName);
                    currentlocation =  cityName;
//	                    Imagecaption.setText("Latitude:"+currentlocationlaltitue+",\nLongitude:"+currentlocationlongitude+",\nLocation:"+currentlocation);

                }

//	                Toast.makeText(mycontext, currentlocation, Toast.LENGTH_LONG).show();
            };
        }.execute();
    }
    private void checkinglocationvalue(Double currentlatitude,Double currentlongitude)
    {
        if (distance(facility_atmlistadapter.wantedlatitude, facility_atmlistadapter.wantedlongitude, currentlatitude, currentlongitude) <= 0.4) // if distance < 0.16 miles we take locations as equal
        {
            //Toast.makeText(mycontext,"Location matched",Toast.LENGTH_LONG).show();
            Snackbar.make(findViewById(android.R.id.content), "Location matched", Snackbar.LENGTH_LONG)
                    .setAction("Action", null).show();
            Intent intent = new Intent(mycontext, CategoryList.class);
            mycontext.startActivity(intent);
        }
        else
        {
            // Toast.makeText(mycontext,"Location is not matching!!Try again",Toast.LENGTH_LONG).show();
            snackBar.dismiss();
            snackBar = Snackbar.make(findViewById(android.R.id.content),"Location is not matching!!Try again", Snackbar.LENGTH_INDEFINITE);
            toast();
//            Toast.makeText(mycontext,currentlatitude+","+currentlongitude,Toast.LENGTH_LONG).show();
//            Toast.makeText(mycontext,"distance="+distance(atmlistadapter.wantedlatitude, atmlistadapter.wantedlongitude, currentlatitude, currentlongitude),Toast.LENGTH_LONG).show();
        }
    }
    /** calculates the distance between two locations in MILES */
    private double distance(double lat1, double lng1, double lat2, double lng2) {

        double earthRadius = 3958.75; // in miles, change to 6371 for kilometer output

        double dLat = Math.toRadians(lat2-lat1);
        double dLng = Math.toRadians(lng2-lng1);

        double sindLat = Math.sin(dLat / 2);
        double sindLng = Math.sin(dLng / 2);

        double a = Math.pow(sindLat, 2) + Math.pow(sindLng, 2)
                * Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2));

        double c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));

        double dist = earthRadius * c;
//Log.d("distance btwm", ""+dist);
        return dist; // output distance, in MILES
    }
    private void toast()
    {
        snackBar.setAction("CLOSE", new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                snackBar.dismiss();
            }
        }).setActionTextColor(getResources().getColor(android.R.color.holo_blue_dark )).show();
    }
}
