package com.b2lmobitech.fieldcloudplus.serviceold;


import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;

import android.database.Cursor;
import android.net.ConnectivityManager;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import android.widget.EditText;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.sparestable;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.insertspareslistadapter;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.spareslistadapteredit;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

import android.view.ViewGroup.LayoutParams;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


public class InsertSpares extends AppCompatActivity {

    private String selectedcompanyname="",selectedcombinationname="",selectedcombinationtype="",selectedticketnumber="";
    private static sqldatabase mDbHelper;


    spareslistadapteredit adapter;

    private static insertspareslistadapter spareadapter = null;


    TextView result;
    ListView sparelistview;

    private Context mycontext;

    String item_id[];
    String item_sku[];
    String item_rate[];
    String item_name[];
    String quantity[];
    String totalamount[];

//    final String products[] = {"Dell Inspiron", "HTC One X", "HTC Wildfire S", "HTC Sense", "HTC Sensation XE",
//            "iPhone 4S", "Samsung Galaxy Note 800",
//            "Samsung Galaxy S3", "MacBook Air", "Mac Mini", "MacBook Pro"};
//
//    final int itemamount[] = {100, 125, 150, 175, 200,
//            225, 250,
//            275, 300, 325, 350};

    String products[];
    String sku[];
    String stock[];
    int itemamount[];

    JSONParser jsonParser = new JSONParser();

    ProgressDialog pDialog;

    JSONArray getproducts = null;

    private static final String GET_URL = "http://b2llab.in/WareHouseApp/get_spares.php";

    private static final String TAG_SUCCESS = "success";
    private static final String TAG_MESSAGE = "message";

    private static final String TAG_PRODUCTS = "product";

    private PopupWindow mPopupWindow;

    String selecteditem="";
    String selectedsku="";
    int selectedamount=0;
    int selectedtotal=0;
    int selectedquantity=1;





    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_spareparts);



        mycontext = this;

        mDbHelper = new sqldatabase(mycontext);

        selectedticketnumber = getIntent().getExtras().getString("ticketnumber");
        selectedcombinationname = getIntent().getExtras().getString("combinationname");
        selectedcombinationtype = getIntent().getExtras().getString("combinationtype");
        selectedcompanyname = getIntent().getExtras().getString("companyname");


        new GetSpares().execute();

        result=(TextView)findViewById(R.id.result);
        sparelistview=(ListView)findViewById(R.id.sparelistview);

        Cursor cursor=mDbHelper.get_spareparts(selectedticketnumber);


        if(cursor!=null){

            item_id=new String[cursor.getCount()];
            item_name=new String[cursor.getCount()];
            quantity=new String[cursor.getCount()];
            totalamount=new String[cursor.getCount()];
            item_sku=new String[cursor.getCount()];
            item_rate=new String[cursor.getCount()];

        }

        int c=0;
        if (cursor!=null) {
            cursor.moveToFirst();
            do {
                // get  the  data into array,or class variable
                item_id[c]= cursor.getString(cursor.getColumnIndex(sparestable._ID));
                item_name[c]= cursor.getString(cursor.getColumnIndex(sparestable.ITEM_NAME));
                quantity[c]= cursor.getString(cursor.getColumnIndex(sparestable.QUANTITY));
                totalamount[c]=cursor.getString(cursor.getColumnIndex(sparestable.TOTALAMOUNT));
                item_sku[c]= cursor.getString(cursor.getColumnIndex(sparestable.SKU));
                item_rate[c]=cursor.getString(cursor.getColumnIndex(sparestable.AMOUNT));

                c++;
            } while (cursor.moveToNext());
        }

        if(item_name==null)
        {
            sparelistview.setVisibility(View.GONE);
            result.setVisibility(View.VISIBLE);
            result.setText("No Spares Added");



        }
        else{

            sparelistview.setAdapter(null);

            adapter = new spareslistadapteredit(InsertSpares.this,item_id,item_sku,item_name,quantity,item_rate,totalamount);
            sparelistview.setAdapter(adapter);


        }

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
     //   getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    public void showpopup()
    {
        LayoutInflater inflater = (LayoutInflater) mycontext.getSystemService(LAYOUT_INFLATER_SERVICE);

        // Inflate the custom layout/view
        View customView = inflater.inflate(R.layout.sparespopup,null);

        mPopupWindow = new PopupWindow(
                customView,
                LayoutParams.FILL_PARENT,
                LayoutParams.FILL_PARENT
        );

        mPopupWindow.setFocusable(true);



          final ListView lv = (ListView) customView.findViewById(R.id.list_view);
        EditText inputSearch = (EditText) customView.findViewById(R.id.inputSearch);


        TextView skutxt = (TextView) customView.findViewById(R.id.sku);
        TextView nametxt = (TextView) customView.findViewById(R.id.name);
        TextView stocktxt = (TextView) customView.findViewById(R.id.stock);
        TextView amounttxt = (TextView) customView.findViewById(R.id.amount);

        DisplayMetrics displaymetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int width = displaymetrics.widthPixels;
        int txtwidth=(width-20)/4;


        skutxt.setWidth(txtwidth);
        nametxt.setWidth(txtwidth);
        stocktxt.setWidth(txtwidth);
        amounttxt.setWidth(txtwidth);


        spareadapter = new insertspareslistadapter(InsertSpares.this,sku,products,stock,itemamount);
        lv.setAdapter(spareadapter);

        inputSearch.addTextChangedListener(new TextWatcher() {

            @Override
            public void onTextChanged(CharSequence cs, int arg1, int arg2, int arg3) {
                // When user changed the Text
               // InsertSpares.this.adapter.getFilter().filter(cs);



                ///////////////////////////////////////////////////



                int count=0;

                if(cs.toString().length()==0)
                {
                    lv.setAdapter(null);
                    spareadapter = new insertspareslistadapter(InsertSpares.this,sku,products,stock,itemamount);
                    lv.setAdapter(spareadapter);

                }
                else{

                    for(int i=0;i<products.length;i++)
                    {
                        if(products[i].toLowerCase().startsWith(cs.toString().toLowerCase()))
                        {
                            count++;
                        }
                    }




                    String[] newproducts=new String[count];
                    String[] newsku=new String[count];
                    String[] newstock=new String[count];
                    int[] newitemamount=new int[count];

                    int j=0;
                    for(int i=0;i<products.length;i++)
                    {
                        if(products[i].toLowerCase().startsWith(cs.toString().toLowerCase()))
                        {
                            newproducts[j]=products[i];
                            newsku[j]=sku[i];
                            newstock[j]=stock[i];
                            newitemamount[j]=itemamount[i];

                            j++;
                        }
                    }
                    lv.setAdapter(null);
                    spareadapter = new insertspareslistadapter(InsertSpares.this,newsku,newproducts,newstock,newitemamount);
                    lv.setAdapter(spareadapter);
                }


                ///////////////////////////////////////////////////

            }

            @Override
            public void beforeTextChanged(CharSequence arg0, int arg1, int arg2,
                                          int arg3) {
                // TODO Auto-generated method stub

            }

            @Override
            public void afterTextChanged(Editable arg0) {
                // TODO Auto-generated method stub
            }
        });
/*
        lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View view,
                                    int position, long id) {


                item.setText(products[position]);

                item.setTextColor(Color.parseColor("#000000"));

               // selecteditem=products[position];
                //selectedamount=itemamount[position];


                selecteditem= String.valueOf(lv.getItemAtPosition(position));

                Log.e("selected item",selecteditem);

                for(int i=0;i<products.length;i++)
                {
                    if(products[i].equalsIgnoreCase(selecteditem))
                    {
                        selectedamount=itemamount[i];
                    }
                }

                selectedtotal=selectedquantity*selectedamount;

                quantitytxt.setVisibility(View.VISIBLE);
                quantity.setVisibility(View.VISIBLE);
                amount.setVisibility(View.VISIBLE);
                total.setVisibility(View.VISIBLE);
                submit.setVisibility(View.VISIBLE);
                next.setVisibility(View.VISIBLE);


                amount.setText(Html.fromHtml("Amount: " + "<font color='#000000'>"+String.valueOf(selectedamount)+"</font>"));
                total.setText(Html.fromHtml("Total Amount: " + "<font color='#000000'>"+String.valueOf(selectedtotal)+"</font>"));

                mPopupWindow.dismiss();
            }
        });*/


        mPopupWindow.showAtLocation(result, Gravity.CENTER,0,0);
    }

    public void submit(View v)
    {
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mDbHelper.insert_spares(selectedcompanyname,selectedcombinationname,selectedcombinationtype,String.valueOf(selectedticketnumber),selectedsku,selecteditem,String.valueOf(selectedamount),String.valueOf(selectedquantity),String.valueOf(selectedtotal),sdf2.format(new Date()));
        finish();
    }

    public void next(View v)
    {
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mDbHelper.insert_spares(selectedcompanyname,selectedcombinationname,selectedcombinationtype,String.valueOf(selectedticketnumber),selectedsku,selecteditem,String.valueOf(selectedamount),String.valueOf(selectedquantity),String.valueOf(selectedtotal),sdf2.format(new Date()));
        showpopup();
    }





    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        getMenuInflater().inflate(R.menu.sparemenu, menu);


        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        switch(id)
        {
            case R.id.action_add:

                showpopup();


                break;
            default:
                break;
        }


        return super.onOptionsItemSelected(item);
    }


            class GetSpares extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(InsertSpares.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;




            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();

                params.add(new BasicNameValuePair("company", selectedcompanyname));


                Log.d("request!", "starting");

                //Posting user data to script
                JSONObject json = jsonParser.makeHttpRequest(
                        GET_URL, "GET", params);

                ConnectivityManager connec =
                        (ConnectivityManager)getSystemService(getBaseContext().CONNECTIVITY_SERVICE);
                if (connec.getNetworkInfo(1).getState() == android.net.NetworkInfo.State.DISCONNECTED && connec.getNetworkInfo(0).getState() == android.net.NetworkInfo.State.DISCONNECTED)
                {


                    runOnUiThread(new Runnable(){
                        public void run() {


                            Toast.makeText(InsertSpares.this, "No internet connection..", Toast.LENGTH_LONG).show();

                        }
                    });

                }
                else{



                   int sparesuccess = json.getInt(TAG_SUCCESS);

                    Log.e("movie success=", String.valueOf(sparesuccess));

                    if (sparesuccess == 1) {




                        getproducts = json.getJSONArray(TAG_PRODUCTS);


                        Log.e("movies found = ",String.valueOf(getproducts.length()));


                        products=new String[getproducts.length()];
                        sku=new String[getproducts.length()];
                        stock=new String[getproducts.length()];
                        itemamount=new int[getproducts.length()];




                        // looping through All Products
                        for (int i = 0; i < getproducts.length(); i++) {

                            JSONObject getc = getproducts.getJSONObject(i);

                            // Storing each json item in variable
                            products[i]=getc.getString("item_name");

                            Log.e("products "+i,products[i]);

                            sku[i]=getc.getString("sku");

                            Log.e("sku "+i,sku[i]);

                            stock[i]=getc.getString("stock");

                            Log.e("stock "+i,stock[i]);

                            itemamount[i]=Integer.parseInt(getc.getString("sellprice"));



                        }










                    }


                    else{



                        Log.d("Login Failure!", json.getString(TAG_MESSAGE));
                        return json.getString(TAG_MESSAGE);

                    }
                }


            } catch (JSONException e) {
                e.printStackTrace();
            }


            return null;

        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {

            pDialog.dismiss();


            if(products==null)
            {

                Toast.makeText(getApplicationContext(), "No products found", Toast.LENGTH_SHORT).show();
                finish();
              //  mPopupWindow.dismiss();

            }





        }
    }



    public void ProductClick(String sku,String name,String stock,int rate) {




        // selecteditem=products[position];
        //selectedamount=itemamount[position];


        selecteditem= name;
        selectedsku=sku;
        selectedamount=rate;


        selectedtotal=selectedquantity*selectedamount;


        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mDbHelper.insert_spares(selectedcompanyname,selectedcombinationname,selectedcombinationtype,String.valueOf(selectedticketnumber),selectedsku,selecteditem,String.valueOf(selectedamount),String.valueOf(selectedquantity),String.valueOf(selectedtotal),sdf2.format(new Date()));


//        quantitytxt.setVisibility(View.VISIBLE);
//        quantity.setVisibility(View.VISIBLE);
//        amount.setVisibility(View.VISIBLE);
//        total.setVisibility(View.VISIBLE);
//        submit.setVisibility(View.VISIBLE);
//        next.setVisibility(View.VISIBLE);
//        or.setVisibility(View.VISIBLE);


        //amount.setText(Html.fromHtml("Amount: " + "<font color='#000000'>"+String.valueOf(selectedamount)+"</font>"));
        //total.setText(Html.fromHtml("Total Amount: " + "<font color='#000000'>"+String.valueOf(selectedtotal)+"</font>"));

        mPopupWindow.dismiss();

        Cursor cursor=mDbHelper.get_spareparts(selectedticketnumber);


        if(cursor!=null){
            item_id=new String[cursor.getCount()];
            item_name=new String[cursor.getCount()];
            quantity=new String[cursor.getCount()];
            totalamount=new String[cursor.getCount()];
            item_sku=new String[cursor.getCount()];
            item_rate=new String[cursor.getCount()];

        }

        int c=0;
        if (cursor!=null) {
            cursor.moveToFirst();
            do {
                // get  the  data into array,or class variable
                item_id[c]= cursor.getString(cursor.getColumnIndex(sparestable._ID));
                item_name[c]= cursor.getString(cursor.getColumnIndex(sparestable.ITEM_NAME));
                quantity[c]= cursor.getString(cursor.getColumnIndex(sparestable.QUANTITY));
                totalamount[c]=cursor.getString(cursor.getColumnIndex(sparestable.TOTALAMOUNT));
                item_sku[c]= cursor.getString(cursor.getColumnIndex(sparestable.SKU));
                item_rate[c]=cursor.getString(cursor.getColumnIndex(sparestable.AMOUNT));

                c++;
            } while (cursor.moveToNext());
        }

        if(item_name==null)
        {
            sparelistview.setVisibility(View.GONE);
            result.setVisibility(View.VISIBLE);
            result.setText("No Spares Added");



        }
        else{

            sparelistview.setVisibility(View.VISIBLE);
            result.setVisibility(View.GONE);

            sparelistview.setAdapter(null);

            adapter = new spareslistadapteredit(InsertSpares.this,item_id,item_sku,item_name,quantity,item_rate,totalamount);
            sparelistview.setAdapter(adapter);


        }


    }

    @Override
    public void onBackPressed() {

finish();


    }



    public void DeleteClick(final String id,final String selectedsku,final String selectedname)
    {
        AlertDialog.Builder builder = new AlertDialog.Builder(
                InsertSpares.this);

        builder.setMessage("Delete Selected item?");
        builder.setCancelable(false);
        builder.setPositiveButton("OK",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int which) {



                        int row=mDbHelper.deletesparesnew(id,selectedsku,selectedname);

                        if(row>0) {

                            Log.e("deleted", "true");

                            Cursor cursor = mDbHelper.get_spareparts(selectedticketnumber);


                            if (cursor != null) {

                                item_id = new String[cursor.getCount()];
                                item_name = new String[cursor.getCount()];
                                quantity = new String[cursor.getCount()];
                                totalamount = new String[cursor.getCount()];
                                item_sku = new String[cursor.getCount()];
                                item_rate = new String[cursor.getCount()];

                                int c = 0;

                                cursor.moveToFirst();
                                do {
                                    // get  the  data into array,or class variable
                                    item_id[c] = cursor.getString(cursor.getColumnIndex(sparestable._ID));
                                    item_name[c] = cursor.getString(cursor.getColumnIndex(sparestable.ITEM_NAME));
                                    quantity[c] = cursor.getString(cursor.getColumnIndex(sparestable.QUANTITY));
                                    totalamount[c] = cursor.getString(cursor.getColumnIndex(sparestable.TOTALAMOUNT));
                                    item_sku[c] = cursor.getString(cursor.getColumnIndex(sparestable.SKU));
                                    item_rate[c] = cursor.getString(cursor.getColumnIndex(sparestable.AMOUNT));

                                    c++;
                                } while (cursor.moveToNext());




                            if (item_name == null) {

                                Log.e("listview","null");

                                sparelistview.setVisibility(View.GONE);
                                result.setVisibility(View.VISIBLE);
                                result.setText("No Spares Added");


                            } else {

                                Log.e("listview","coming");

                                sparelistview.setVisibility(View.VISIBLE);
                                result.setVisibility(View.GONE);

                                sparelistview.setAdapter(null);

                                adapter = new spareslistadapteredit(InsertSpares.this, item_id,item_sku, item_name, quantity, item_rate, totalamount);
                                sparelistview.setAdapter(adapter);


                            }
                        }

                        else

                            {
                                sparelistview.setVisibility(View.GONE);
                                result.setVisibility(View.VISIBLE);
                                result.setText("No Spares Added");
                            }

                        }
                        else
                        {
                            Toast.makeText(getApplicationContext(), "No items deleted", Toast.LENGTH_SHORT).show();
                        }

                    }
                });

        builder.setNegativeButton("CANCEL",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int which) {

                    }
                });

        builder.show();
    }


    }
