package com.b2lmobitech.fieldcloudplus.serviceold;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.widget.ListView;
import android.widget.TextView;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.ticketreportadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;
import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;



public class TicketReportDaily extends AppCompatActivity {

    TextView result;
    ListView attendancelv;
    private Context mycontext;


    private ProgressDialog pDialog;


    JSONArray employees = null;

    JSONParser jsonParser = new JSONParser();


    private static final String ALL_ISSUES_URL ="http://fieldcloud.in/App/get_issuesdaily.php";

    private static final String TICKETS_URL ="http://fieldcloud.in/App/get_ticketreportdaily.php";

    private static final String EMP_SUCCESS = "success";
    private static final String EMP_MESSAGE = "message";



    JSONArray products = null;



    String registeredcompany,registeredemailid;



    String startdate="",enddate="";




    int totalissues=0;

    ActionBar ab;

    int first=0;

    String issuecount[]=null;
    String issuedate[]=null;



    String[] ticketdate;
    String[] newticket;
    String[] assignticket;
    String[] underticket;
    String[] completeticket;
    String[] incompleteticket;

    int[] monthid;

    String[] alldate=null;
    String[] all_issuecount=null;
    String[] all_newticket;
    String[] all_assignticket;
    String[] all_underticket;
    String[] all_completeticket;
    String[] all_incompleteticket;

    MenuItem chart ;


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.content_ticketreportlist);

        mycontext = this;


        Intent intent = getIntent();

        startdate=intent.getStringExtra("startdate");
        enddate=intent.getStringExtra("enddate");




        result=(TextView) findViewById(R.id.result);

        attendancelv=(ListView) findViewById(R.id.attendancelistview);


        DisplayMetrics displaymetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);


        int width = displaymetrics.widthPixels;
        int txtwidth=(width-10)/3;

        //   route.setWidth(txtwidth);


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        if(isNetworkAvailable())
        {

            new GetAllIssues().execute();
        }
        else
        {
            result.setVisibility(View.VISIBLE);
            result.setText("No Internet Connection");


            attendancelv.setVisibility(View.GONE);

            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();

        }

        getSupportActionBar().setBackgroundDrawable(
                new ColorDrawable(Color.parseColor("#8bbb4b")));

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);


    }




    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }


    @Override
    public void onBackPressed() {
        Intent intent = new Intent(getApplicationContext(),TicketReport.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP|
                Intent.FLAG_ACTIVITY_CLEAR_TASK
        ); // To clean up all activities
        startActivity(intent);
    }



    class GetAllIssues extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketReportDaily.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;





            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("startdate",startdate ));
                params.add(new BasicNameValuePair("enddate",enddate ));

                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_ISSUES_URL, "GET", params);


                success = json.getInt(EMP_SUCCESS);
                if (success == 1) {


                    employees = json.getJSONArray("tickets");

                    JSONObject photoobj;

                    int count=employees.length();



                    if(count>=1)
                    {



                        issuecount=new String[count];
                        issuedate=new String[count];
                        alldate=new String[count];
                        all_issuecount=new String[count];
                        all_newticket=new String[count];
                        all_assignticket=new String[count];
                        all_underticket=new String[count];
                        all_completeticket=new String[count];
                        all_incompleteticket=new String[count];



                        for (int i = 0; i <count; i++) {
                            photoobj=employees.getJSONObject(i);

                            issuecount[i]=photoobj.getString("issuecount");

                            Log.e("issuecount "+String.valueOf(i),issuecount[i]);

                            issuedate[i]=photoobj.getString("date");

                            Log.e("issuedate "+String.valueOf(i),issuedate[i]);

                            all_issuecount[i]=photoobj.getString("issuecount");

                            Log.e("all_issuecount "+String.valueOf(i),all_issuecount[i]);

                            alldate[i]=photoobj.getString("date");

                            Log.e("alldate "+String.valueOf(i),alldate[i]);

                            all_newticket[i]="0";

                            all_assignticket[i]="0";

                            all_underticket[i]="0";

                            all_completeticket[i]="0";

                            all_incompleteticket[i]="0";



                        }

                    }




                    return json.getString(EMP_MESSAGE);


                }

                else if(success==0){

                    return json.getString(EMP_MESSAGE);

                }

                else if(success==2){

                    return json.getString(EMP_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();



            new GetAttendanceEmployees().execute();


        }
    }



    class GetAttendanceEmployees extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketReportDaily.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;




            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("startdate",startdate ));
                params.add(new BasicNameValuePair("enddate",enddate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        TICKETS_URL, "GET", params);

                // full json response
                //   Log.d("Login attempt", json.toString());

                // json success element




                success = json.getInt(EMP_SUCCESS);
                if (success == 1) {


                    employees = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=employees.length();



                    if(count>=1)
                    {



                        ticketdate=new String[count];
                        newticket=new String[count];
                        assignticket=new String[count];
                        underticket=new String[count];
                        completeticket=new String[count];
                        incompleteticket=new String[count];

                        alldate=new String[count];
                        all_issuecount=new String[count];
                        all_newticket=new String[count];
                        all_assignticket=new String[count];
                        all_underticket=new String[count];
                        all_completeticket=new String[count];
                        all_incompleteticket=new String[count];



                        for (int i = 0; i <count; i++) {
                            photoobj=employees.getJSONObject(i);

                            ticketdate[i]=photoobj.getString("createddate");

                            if(ticketdate[i].equalsIgnoreCase("no data available")) {
                                ticketdate[i] = photoobj.getString("assigneddate");
                            }else{
                                ticketdate[i] = photoobj.getString("createddate");
                            }

                            if(ticketdate[i].equalsIgnoreCase("no data available")) {
                                alldate[i] = photoobj.getString("assigneddate");
                            }else{
                                alldate[i] = photoobj.getString("createddate");
                            }
                            all_issuecount[i]="0";

                            newticket[i]=photoobj.getString("newcount");

                            assignticket[i]=photoobj.getString("assigncount");

                            underticket[i]=photoobj.getString("underprogresscount");

                            completeticket[i]=photoobj.getString("completecount");

                            incompleteticket[i]=photoobj.getString("incompletecount");


                            all_newticket[i]=photoobj.getString("newcount");

                            all_assignticket[i]=photoobj.getString("assigncount");

                            all_underticket[i]=photoobj.getString("underprogresscount");

                            all_completeticket[i]=photoobj.getString("completecount");

                            all_incompleteticket[i]=photoobj.getString("incompletecount");


                        }

                    }


                    return json.getString(EMP_MESSAGE);


                }

                else if(success==0){

                    return json.getString(EMP_MESSAGE);

                }

                else if(success==2){

                    return json.getString(EMP_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();



            if(issuedate!=null || ticketdate!=null)
            {
               /* list1.removeAll(list2);
                list2.addAll(list1);*/


                if (issuedate != null && ticketdate != null) {



                    all_issuecount=null;
                    all_newticket=null;
                    all_assignticket=null;
                    all_underticket=null;
                    all_completeticket=null;
                    all_incompleteticket=null;

                    ArrayList<String> issuelist = new ArrayList<String>( Arrays.asList(issuedate));
                    ArrayList<String> ticketlist =new ArrayList<String>( Arrays.asList(ticketdate));

                    issuelist.removeAll(ticketlist);
                    ticketlist.addAll(issuelist);

                    DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

                    alldate = ticketlist.toArray(new String[ticketlist.size()]);

                    Log.e("alldate length",String.valueOf(alldate.length));

                    Date[] arrayOfDates = new Date[alldate.length];
                    for (int index = 0; index < alldate.length; index++) {
                        try {
                            arrayOfDates[index] = sdf.parse(alldate[index]);
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }

                    Arrays.sort(arrayOfDates);
                    for (int index = 0; index < alldate.length; index++) {
                        alldate[index] = sdf.format(arrayOfDates[index]);
                        Log.e("alldatefinal "+String.valueOf(index),alldate[index]);
                    }

                    all_issuecount=new String[alldate.length];
                    all_newticket=new String[alldate.length];
                    all_assignticket=new String[alldate.length];
                    all_underticket=new String[alldate.length];
                    all_completeticket=new String[alldate.length];
                    all_incompleteticket=new String[alldate.length];


                    for(int i=0;i<alldate.length;i++)
                    {
                        all_issuecount[i]="0";
                        all_newticket[i]="0";
                        all_assignticket[i]="0";
                        all_underticket[i]="0";
                        all_completeticket[i]="0";
                        all_incompleteticket[i]="0";
                    }

                    for(int i=0;i<alldate.length;i++)
                    {
                        for(int j=0;j<issuedate.length;j++) {
                            if (alldate[i].equalsIgnoreCase(issuedate[j]))
                            {
                                all_issuecount[i]=issuecount[j];
                            }
                        }
                    }


                    for(int i=0;i<alldate.length;i++)
                    {
                        for(int j=0;j<ticketdate.length;j++) {
                            if (alldate[i].equalsIgnoreCase(ticketdate[j]))
                            {
                                all_newticket[i]=newticket[j];
                                all_assignticket[i]=assignticket[j];
                                all_underticket[i]=underticket[j];
                                all_completeticket[i]=completeticket[j];
                                all_incompleteticket[i]=incompleteticket[j];
                            }
                        }
                    }


                    ticketreportadapter adapter =new

                            ticketreportadapter(TicketReportDaily.this,alldate,all_issuecount,all_newticket,all_assignticket,all_underticket,all_completeticket,all_incompleteticket);


                    attendancelv.setAdapter(adapter);

                    chart.setVisible(true);

                }

                else if (issuedate != null && ticketdate == null) {

                    ticketreportadapter adapter =new

                            ticketreportadapter(TicketReportDaily.this,alldate,all_issuecount,all_newticket,all_assignticket,all_underticket,all_completeticket,all_incompleteticket);


                    attendancelv.setAdapter(adapter);

                    chart.setVisible(true);
                }


                else if (issuedate == null && ticketdate != null) {

                    ticketreportadapter adapter =new

                            ticketreportadapter(TicketReportDaily.this,alldate,all_issuecount,all_newticket,all_assignticket,all_underticket,all_completeticket,all_incompleteticket);


                    attendancelv.setAdapter(adapter);

                    chart.setVisible(true);

                }




            }


            else{

                result.setVisibility(View.VISIBLE);
                result.setText("No Results!!");
                chart.setVisible(false);
                attendancelv.setVisibility(View.GONE);

            }

        }
    }


//////////////////////////////////////////////////////



    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.chart, menu);

        chart = menu.findItem(R.id.chart);

        chart.setVisible(false);

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        switch(id)
        {
            case R.id.chart:
                setContentView(R.layout.activity_ticketchart);

                LineChart lineChart = (LineChart) findViewById(R.id.chart);


                ArrayList<Entry> group1 = new ArrayList<>();
                for(int i=0;i<all_issuecount.length;i++)
                {
                    group1.add(new BarEntry((float) Double.parseDouble(all_issuecount[i]), i));
                }




                ArrayList<Entry> group2 = new ArrayList<>();

                for(int i=0;i<all_newticket.length;i++)
                {
                    group2.add(new BarEntry((float) Double.parseDouble(all_newticket[i]), i));
                }


                ArrayList<Entry> group3 = new ArrayList<>();

                for(int i=0;i<all_assignticket.length;i++)
                {
                    group3.add(new BarEntry((float) Double.parseDouble(all_assignticket[i]), i));
                }

                ArrayList<Entry> group4 = new ArrayList<>();

                for(int i=0;i<all_underticket.length;i++)
                {
                    group4.add(new BarEntry((float) Double.parseDouble(all_underticket[i]), i));
                }

                ArrayList<Entry> group5 = new ArrayList<>();

                for(int i=0;i<all_completeticket.length;i++)
                {
                    group5.add(new BarEntry((float) Double.parseDouble(all_completeticket[i]), i));
                }


                ArrayList<Entry> group6 = new ArrayList<>();

                for(int i=0;i<all_incompleteticket.length;i++)
                {
                    group6.add(new BarEntry((float) Double.parseDouble(all_incompleteticket[i]), i));
                }




                LineDataSet DataSet1 = new LineDataSet(group1, "Issue");
                DataSet1.setColor(Color.rgb(155, 0, 0));
                DataSet1.setDrawCubic(true);
                //  dataset.setDrawFilled(true);
                // DataSet1.setColors(ColorTemplate.COLORFUL_COLORS);

                LineDataSet DataSet2 = new LineDataSet(group2, "New");
                DataSet2.setColor(Color.rgb(0, 0, 155));
                DataSet2.setDrawCubic(true);


                LineDataSet DataSet3 = new LineDataSet(group3, "Assigned");
                DataSet3.setColor(Color.rgb(131, 226, 43));
                DataSet3.setDrawCubic(true);


                LineDataSet DataSet4 = new LineDataSet(group4, "Underprogressed");
                DataSet4.setColor(Color.rgb(138, 43, 226));
                DataSet4.setDrawCubic(true);


                LineDataSet DataSet5 = new LineDataSet(group5, "Completed");
                DataSet5.setColor(Color.rgb(0, 155, 0));
                DataSet5.setDrawCubic(true);


                LineDataSet DataSet6 = new LineDataSet(group6, "InComplete");
                DataSet6.setColor(Color.rgb(0, 155, 155));
                DataSet6.setDrawCubic(true);


                // dataset.setDrawFilled(true);
                //DataSet2.setColors(ColorTemplate.COLORFUL_COLORS);

                List<ILineDataSet> dataSets = new ArrayList<>();
                dataSets.add(DataSet1);
                dataSets.add(DataSet2);
                dataSets.add(DataSet3);
                dataSets.add(DataSet4);
                dataSets.add(DataSet5);
                dataSets.add(DataSet6);


                LineData data = new LineData(getXAxisValues(), dataSets);
                lineChart.setData(data);
                lineChart.setDescription("Tickets");
                lineChart.animateY(5000);
                // lineChart.animateXY(2000, 2000);
                lineChart.invalidate();




                break;

            default:
                break;
        }
        // Activate the navigation drawer toggle

        return super.onOptionsItemSelected(item);
    }

    private ArrayList<String> getXAxisValues() {
        ArrayList<String> labels = new ArrayList<>();

        for(int i=0;i<alldate.length;i++)
        {
            labels.add(alldate[i]);

        }
        return labels;
    }



}
