package com.b2lmobitech.fieldcloudplus.serviceold;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;

import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


public class TicketReportonDate extends AppCompatActivity {

    private Context mycontext;


    private ProgressDialog pDialog;


    JSONArray tickets = null;

    JSONParser jsonParser = new JSONParser();


    private static final String ALL_ISSUE_URL ="http://fieldcloud.in/App/get_issuescount.php";

    private static final String ALL_TICKET_URL ="http://fieldcloud.in/App/get_ticketscount.php";



    private static final String TICKET_SUCCESS = "success";
    private static final String TICKET_MESSAGE = "message";



    JSONArray products = null;



    String registeredcompany,registeredemailid;



    TextView title;

    TextView tv1;
    TextView issues;
    ImageView issues_next;

    String issuesvalue="0";
    int issuescount=0;

    TextView tv2;
    TextView newticket;
    ImageView newticket_next;

    String newcount="0";

    TextView tv3;
    TextView assigned;
    ImageView assigned_next;

    String assigncount="0";

    TextView tv4;
    TextView underprogressed;
    ImageView underprogressed_next;

    String underprogresscount="0";

    TextView tv5;
    TextView completed;
    ImageView completed_next;

    String completecount="0";

    TextView tv6;
    TextView incompleted;
    ImageView incompleted_next;

    String incompletecount="0";

    RelativeLayout img2,img4,img6,img8,img10,img12;

    RelativeLayout iss,open,assign,under,complete,incomplete;

    String[] ticketnumber;
    String[] customername;
    String[] facility;
    String[] emailid;
    String[] question;
    String[] answer;
    String[] latitude;
    String[] longitude;
    String[] location;
    String[] questionmode;
    String[] questiontype;
    String[] combinationname;
    String[] typename;


String searchdate;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_ticketsummaryondate);

        mycontext = this;


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        Intent intent = getIntent();

        searchdate=intent.getStringExtra("date");



        title=(TextView)findViewById(R.id.hometv);

        title.setText(searchdate+" Tickets");

        tv1=(TextView)findViewById(R.id.tv1);
        issues=(TextView)findViewById(R.id.issues);
        issues_next=(ImageView)findViewById(R.id.issues_next);


        tv2=(TextView)findViewById(R.id.tv2);
        newticket=(TextView)findViewById(R.id.newticket);
        newticket_next=(ImageView)findViewById(R.id.newticket_next);

        tv3=(TextView)findViewById(R.id.tv3);
        assigned=(TextView)findViewById(R.id.assigned);
        assigned_next=(ImageView)findViewById(R.id.assigned_next);



        tv4=(TextView)findViewById(R.id.tv4);
        underprogressed=(TextView)findViewById(R.id.underprogressed);
        underprogressed_next=(ImageView)findViewById(R.id.underprogressed_next);



        tv5=(TextView)findViewById(R.id.tv5);
        completed=(TextView)findViewById(R.id.completed);
        completed_next=(ImageView)findViewById(R.id.completed_next);


        tv6=(TextView)findViewById(R.id.tv6);
        incompleted=(TextView)findViewById(R.id.incompleted);
        incompleted_next=(ImageView)findViewById(R.id.incompleted_next);


        img2=(RelativeLayout) findViewById(R.id.img2);

        img4=(RelativeLayout) findViewById(R.id.img4);

        img6=(RelativeLayout) findViewById(R.id.img6);

        img8=(RelativeLayout) findViewById(R.id.img8);

        img10=(RelativeLayout) findViewById(R.id.img10);

        img12=(RelativeLayout) findViewById(R.id.img12);


        iss=(RelativeLayout) findViewById(R.id.iss);

        open=(RelativeLayout) findViewById(R.id.open);

        assign=(RelativeLayout) findViewById(R.id.assign);

        under=(RelativeLayout) findViewById(R.id.under);

        complete=(RelativeLayout) findViewById(R.id.complete);

        incomplete=(RelativeLayout) findViewById(R.id.incomplete);

        DisplayMetrics displaymetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);

        int width = displaymetrics.widthPixels;
        int txtwidth=(width)/4;

        int twidth=(width-60)/3;


        img2.setMinimumWidth(txtwidth);
        img4.setMinimumWidth(txtwidth);
        img6.setMinimumWidth(txtwidth);
        img8.setMinimumWidth(txtwidth);
        img10.setMinimumWidth(txtwidth);
        img12.setMinimumWidth(txtwidth);



        tv1.setWidth(twidth);
        tv2.setWidth(twidth);
        tv3.setWidth(twidth);
        tv4.setWidth(twidth);
        tv5.setWidth(twidth);
        tv6.setWidth(twidth);


        issues_next.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {

                Intent main = new Intent(TicketReportonDate.this, IssuesListonDate.class);
                main.putExtra("ticketnumber", ticketnumber);
                main.putExtra("customername", customername);
                main.putExtra("facility", facility);
                main.putExtra("emailid", emailid);
                main.putExtra("question", question);
                main.putExtra("answer", answer);
                main.putExtra("latitude", latitude);
                main.putExtra("longitude", longitude);
                main.putExtra("location", location);
                main.putExtra("questionmode", questionmode);
                main.putExtra("questiontype", questiontype);
                main.putExtra("combinationname", combinationname);
                main.putExtra("typename", typename);
                main.putExtra("date", searchdate);
                startActivity(main);
            }
        });


        newticket_next.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent main = new Intent(TicketReportonDate.this, TicketListonDate.class);
                main.putExtra("ticketstatus", "new");
                main.putExtra("date", searchdate);
                startActivity(main);
            }
        });


        assigned_next.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent main = new Intent(TicketReportonDate.this, TicketListonDate.class);
                main.putExtra("ticketstatus", "assigned");
                main.putExtra("date", searchdate);
                startActivity(main);
            }
        });


        underprogressed_next.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent main = new Intent(TicketReportonDate.this, TicketListonDate.class);
                main.putExtra("ticketstatus", "underprogress");
                main.putExtra("date", searchdate);
                startActivity(main);
            }
        });

        completed_next.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent main = new Intent(TicketReportonDate.this, TicketListonDate.class);
                main.putExtra("ticketstatus", "complete");
                main.putExtra("date", searchdate);
                startActivity(main);
            }
        });

        incompleted_next.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent main = new Intent(TicketReportonDate.this, TicketListonDate.class);
                main.putExtra("ticketstatus", "incomplete");
                main.putExtra("date", searchdate);
                startActivity(main);
            }
        });


        if(isNetworkAvailable())
        {

            new GetAllIssues().execute();
        }
        else
        {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();
        }

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }



    class GetAllIssues extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketReportonDate.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;


            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",searchdate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_ISSUE_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {


                        ticketnumber=new String[count];
                        customername=new String[count];
                        facility=new String[count];
                        emailid=new String[count];
                        question=new String[count];
                        answer=new String[count];
                        latitude=new String[count];
                        longitude=new String[count];
                        location=new String[count];
                        questionmode=new String[count];
                        questiontype=new String[count];
                        combinationname=new String[count];
                        typename=new String[count];


                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);

                            ticketnumber[i]=photoobj.getString("ticketnumber");
                            customername[i]=photoobj.getString("customername");
                            facility[i]=photoobj.getString("atmid");
                            emailid[i]=photoobj.getString("emailid");
                            question[i]=photoobj.getString("question");
                            answer[i]=photoobj.getString("answer");
                            latitude[i]=photoobj.getString("latitude");
                            longitude[i]=photoobj.getString("longitude");
                            location[i]=photoobj.getString("location");
                            questionmode[i]=photoobj.getString("questionmode");
                            questiontype[i]=photoobj.getString("questiontype");
                            combinationname[i]=photoobj.getString("combinationname");
                            typename[i]=photoobj.getString("typename");



                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            if(ticketnumber!=null)
            {

                issuescount=ticketnumber.length;

            }

            new GetTicketsCount().execute();

        }
    }

    class GetTicketsCount extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketReportonDate.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;



            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",searchdate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_TICKET_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();

                    Log.e("ticketscount",String.valueOf(count));

                    if(count>=1)
                    {

                        for (int i = 0; i <count; i++) {
                            photoobj = tickets.getJSONObject(i);

                            newcount = photoobj.getString("newcount");
                            assigncount = photoobj.getString("assigncount");
                            underprogresscount = photoobj.getString("underprogresscount");
                            completecount = photoobj.getString("completecount");
                            incompletecount = photoobj.getString("incompletecount");
                        }


                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            issues.setText(String.valueOf(issuescount));
            if(newcount.equalsIgnoreCase("null"))
            {
                newticket.setText("0");
                assigned.setText("0");
                underprogressed.setText("0");
                completed.setText("0");
                incompleted.setText("0");
            }
            else{
                newticket.setText(newcount);
                assigned.setText(assigncount);
                underprogressed.setText(underprogresscount);
                completed.setText(completecount);
                incompleted.setText(incompletecount);
            }


            if(issuescount==0)
            {
                issues_next.setVisibility(View.GONE);
            }
            if(newcount.equalsIgnoreCase("0")||newcount.equalsIgnoreCase("null"))
            {
                newticket_next.setVisibility(View.GONE);
            }
            if(assigncount.equalsIgnoreCase("0")||assigncount.equalsIgnoreCase("null"))
            {
                assigned_next.setVisibility(View.GONE);
            }
            if(underprogresscount.equalsIgnoreCase("0")||underprogresscount.equalsIgnoreCase("null"))
            {
                underprogressed_next.setVisibility(View.GONE);
            }
            if(completecount.equalsIgnoreCase("0")||completecount.equalsIgnoreCase("null"))
            {
                completed_next.setVisibility(View.GONE);
            }
            if(incompletecount.equalsIgnoreCase("0")||incompletecount.equalsIgnoreCase("null"))
            {
                incompleted_next.setVisibility(View.GONE);
            }


        }
    }





}
