package com.b2lmobitech.fieldcloudplus.serviceold;


import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import android.view.View;

import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.hcm.AverageCheckin;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.ticketadapter;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


public class TicketSummary extends AppCompatActivity {

    private Context mycontext;


    private ProgressDialog pDialog;


    JSONArray tickets = null;

    JSONParser jsonParser = new JSONParser();


    private static final String ALL_ISSUE_URL ="http://fieldcloud.in/App/get_issuescount.php";

    private static final String ALL_TICKET_URL ="http://fieldcloud.in/App/get_ticketscount.php";

    private static final String ALL_REVENUE_URL ="http://fieldcloud.in/App/get_revenueamount.php";

    private static final String ALL_EXPENSE_URL ="http://fieldcloud.in/App/get_expenseamount.php";

    private static final String ALL_SERVICE_URL ="http://fieldcloud.in/App/get_servicecallcount.php";

    private static final String ALL_CHECKIN_URL ="http://fieldcloud.in/App/get_allcheckintime.php";



    private static final String TICKET_SUCCESS = "success";
    private static final String TICKET_MESSAGE = "message";



    JSONArray products = null;



    String registeredcompany,registeredemailid;





    String issuesvalue="0";
    int issuescount=0;


    String newcount="0";

    String assigncount="0";

    String underprogresscount="0";

    String completecount="0";

    String incompletecount="0";


    String[] ticketnumber;
    String[] customername;
    String[] facility;
    String[] emailid;
    String[] question;
    String[] answer;
    String[] latitude;
    String[] longitude;
    String[] location;
    String[] questionmode;
    String[] questiontype;
    String[] combinationname;
    String[] typename;


    String[] empname;
    String[] checkin;
    String[] duration;
     long[] diff;

String revenueamount="0";
String expenseamount="0";

    String servicecallcount="0";
    String averagecheckin="0";

    int totalemployees=0;

    GridView gridview;

    int[] imageId = {
            R.drawable.issue,R.drawable.ticket,
            R.drawable.revenue, R.drawable.expense,
            R.drawable.servicecall,R.drawable.average

    };
String[] values;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_ticketsummary);

        mycontext = this;


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");

        gridview = (GridView) findViewById(R.id.gridview);

        gridview.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View v,
                                    int position, long id) {
                //Toast.makeText(dashboard.this,"You Clicked at " +feature[+ position], Toast.LENGTH_SHORT).show();
                if (position == 0) {
if(issuescount==0)
{
    Toast.makeText(getApplicationContext(),"No Issues Raised today",Toast.LENGTH_SHORT).show();

}else {
    Intent main = new Intent(TicketSummary.this, IssuesList.class);
    main.putExtra("ticketnumber", ticketnumber);
    main.putExtra("customername", customername);
    main.putExtra("facility", facility);
    main.putExtra("emailid", emailid);
    main.putExtra("question", question);
    main.putExtra("answer", answer);
    main.putExtra("latitude", latitude);
    main.putExtra("longitude", longitude);
    main.putExtra("location", location);
    main.putExtra("questionmode", questionmode);
    main.putExtra("questiontype", questiontype);
    main.putExtra("combinationname", combinationname);
    main.putExtra("typename", typename);
    startActivity(main);
}

                } else if (position == 1) {
                    int totalticket=Integer.parseInt(newcount)+Integer.parseInt(assigncount)+Integer.parseInt(underprogresscount)+Integer.parseInt(completecount)+Integer.parseInt(incompletecount);

                    if(totalticket==0)
                    {
                        Toast.makeText(getApplicationContext(),"No Tickets Created today",Toast.LENGTH_SHORT).show();

                    }else {

                        Intent intent = new Intent(mycontext, TicketSummaryDetail.class);
                        intent.putExtra("newcount", newcount);
                        intent.putExtra("assigncount", assigncount);
                        intent.putExtra("underprogresscount", underprogresscount);
                        intent.putExtra("completecount", completecount);
                        intent.putExtra("incompletecount", incompletecount);
                        startActivity(intent);
                    }

                } else if (position == 2) {
                    if(revenueamount.equalsIgnoreCase("0"))
                    {
                        Toast.makeText(getApplicationContext(),"Empty!",Toast.LENGTH_SHORT).show();

                    }
                    else {
                    Intent intent = new Intent(mycontext, RevenueDetail.class);
                    startActivity(intent);
                    }
                } else if (position == 3) {
                    if(expenseamount.equalsIgnoreCase("0"))
                    {
                        Toast.makeText(getApplicationContext(),"Empty!",Toast.LENGTH_SHORT).show();

                    }
                    else {
                    Intent intent = new Intent(mycontext, ExpenseDetail.class);
                    startActivity(intent);
                    }
                } else if (position == 4) {

                    if(servicecallcount.equalsIgnoreCase("0"))
                    {
                        Toast.makeText(getApplicationContext(),"Empty!",Toast.LENGTH_SHORT).show();

                    }
                   else {
                    Intent intent = new Intent(mycontext, ServiceCallDetail.class);
                    startActivity(intent);
                    }

                } else if (position == 5) {

                    if(averagecheckin.equalsIgnoreCase("0"))
                    {
                        Toast.makeText(getApplicationContext(),"Empty!",Toast.LENGTH_SHORT).show();

                    }
                    else {
                    Intent intent = new Intent(mycontext, AverageCheckin.class);
                        intent.putExtra("empname", empname);
                        intent.putExtra("checkin", checkin);
                        intent.putExtra("duration", duration);
                    startActivity(intent);
                    }
                }
            }
        });




        if(isNetworkAvailable())
        {

            new GetRevenueAmount().execute();

         //  new GetAllIssues().execute();
        }
        else
        {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

            alertdialog.setTitle("No Internet Connection");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("Try Again!!");
            alertdialog.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            finish();
                        }
                    }).create();

            alertdialog.show();
        }

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }

    class GetRevenueAmount extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketSummary.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_REVENUE_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {

                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);

                            revenueamount=photoobj.getString("revenueamount");

                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            new GetExpenseAmount().execute();

        }
    }



    class GetExpenseAmount extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketSummary.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_EXPENSE_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {

                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);

                            expenseamount=photoobj.getString("expenseamount");

                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            new GetServiceCall().execute();

        }
    }




    class GetServiceCall extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketSummary.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_SERVICE_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {

                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);

                            servicecallcount=photoobj.getString("servicecount");

                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            new GetAverageCheckin().execute();

        }
    }




    class GetAverageCheckin extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketSummary.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_CHECKIN_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();

totalemployees=count;

                    if(count>=1)
                    {

                        empname=new String[count];
                        checkin=new String[count];
                        duration=new String[count];
                        diff=new long[count];

                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);


                            empname[i]=photoobj.getString("emailid");
                            checkin[i]=photoobj.getString("checkintime");

                            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                            String currenttime= df.format(c.getTime());

                            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");

                            Date d1 = null;
                            Date d2 = null;

                            try {
                                d1 = format.parse(checkin[i]);
                                d2 = format.parse(currenttime);

                                //in milliseconds
                                 diff[i] = (d2.getTime() - d1.getTime());

                                long diffSeconds = diff[i] / 1000 % 60;
                                long diffMinutes = diff[i] / (60 * 1000) % 60;
                                long diffHours = diff[i] / (60 * 60 * 1000) % 24;

                                duration[i]=diffHours + "h "+diffMinutes + "m "+diffSeconds+ "s";


                            } catch (Exception e) {
                                e.printStackTrace();
                            }


                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

            new GetAllIssues().execute();

        }
    }

    class GetAllIssues extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketSummary.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_ISSUE_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {


                        ticketnumber=new String[count];
                        customername=new String[count];
                        facility=new String[count];
                        emailid=new String[count];
                        question=new String[count];
                        answer=new String[count];
                        latitude=new String[count];
                        longitude=new String[count];
                        location=new String[count];
                        questionmode=new String[count];
                        questiontype=new String[count];
                        combinationname=new String[count];
                        typename=new String[count];


                        for (int i = 0; i <count; i++) {
                            photoobj=tickets.getJSONObject(i);

                            ticketnumber[i]=photoobj.getString("ticketnumber");
                            customername[i]=photoobj.getString("customername");
                            facility[i]=photoobj.getString("atmid");
                            emailid[i]=photoobj.getString("emailid");
                            question[i]=photoobj.getString("question");
                            answer[i]=photoobj.getString("answer");
                            latitude[i]=photoobj.getString("latitude");
                            longitude[i]=photoobj.getString("longitude");
                            location[i]=photoobj.getString("location");
                            questionmode[i]=photoobj.getString("questionmode");
                            questiontype[i]=photoobj.getString("questiontype");
                            combinationname[i]=photoobj.getString("combinationname");
                            typename[i]=photoobj.getString("typename");



                        }

                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();

          if(ticketnumber!=null)
            {

            issuescount=ticketnumber.length;

            }

            new GetTicketsCount().execute();

        }
    }

    class GetTicketsCount extends AsyncTask<String, String, String> {

        /**
         * Before starting background thread Show Progress Dialog
         * */


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pDialog = new ProgressDialog(TicketSummary.this);
            pDialog.setMessage("Loading...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
        }

        @Override
        protected String doInBackground(String... args) {
            // TODO Auto-generated method stub
            // Check for success tag
            int success;

            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate= df1.format(c.getTime());

            try {
                // Building Parameters
                List<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add(new BasicNameValuePair("companyname",registeredcompany ));
                params.add(new BasicNameValuePair("date",todaydate ));


                //Posting user data to script
                final JSONObject json = jsonParser.makeHttpRequest(
                        ALL_TICKET_URL, "GET", params);


                success = json.getInt(TICKET_SUCCESS);
                if (success == 1) {


                    tickets = json.getJSONArray("tickets");

                    JSONObject photoobj;
                    int count=tickets.length();



                    if(count>=1)
                    {

                        for (int i = 0; i <count; i++) {
                            photoobj = tickets.getJSONObject(i);

                            newcount = photoobj.getString("newcount");
                            assigncount = photoobj.getString("assigncount");
                            underprogresscount = photoobj.getString("underprogresscount");
                            completecount = photoobj.getString("completecount");
                            incompletecount = photoobj.getString("incompletecount");
                        }


                    }


                    return json.getString(TICKET_MESSAGE);


                }

                else if(success==0){

                    return json.getString(TICKET_MESSAGE);

                }

                else if(success==2){

                    return json.getString(TICKET_MESSAGE);

                }

                else{

                    String error="no success";
                    return error;

                }

            } catch (JSONException e) {
                e.printStackTrace();
                String error="php error";
                return error;
            }



        }
        /**
         * After completing background task Dismiss the progress dialog
         * **/
        protected void onPostExecute(String file_url) {
            // dismiss the dialog once product deleted
            pDialog.dismiss();


            if(newcount.equalsIgnoreCase("null"))
            {
               newcount ="0";
                assigncount="0";
                underprogresscount="0";
                completecount="0";
                incompletecount="0";

            }

            if(revenueamount.equalsIgnoreCase("null"))
            {
                revenueamount="0";
            }

            if(expenseamount.equalsIgnoreCase("null"))
            {
                expenseamount="0";
            }

            if(servicecallcount.equalsIgnoreCase("null"))
            {
                servicecallcount="0";
            }

            if(diff==null)
            {
                averagecheckin="0";
            }
            else{
                long totaltime=0;
                for(int i=0;i<diff.length;i++)
                {
                    totaltime+=diff[i];
                }

                long average=totaltime/totalemployees;


                long diffSeconds = average/ 1000 % 60;
                long diffMinutes = average / (60 * 1000) % 60;
                long diffHours =average / (60 * 60 * 1000) % 24;

                averagecheckin=diffHours + " h "+diffMinutes + " m "+diffSeconds+ " s ";
            }


            values=new String[6];
            values[0]="Issues: "+String.valueOf(issuescount);
            values[1]="Tickets: "+String.valueOf(Integer.parseInt(newcount)+Integer.parseInt(assigncount)+Integer.parseInt(underprogresscount)+Integer.parseInt(completecount)+Integer.parseInt(incompletecount));
            values[2]="Service Revenue: Rs "+revenueamount;
            values[3]="Expenses Claim: Rs "+expenseamount;
            values[4]="Service Calls: "+servicecallcount;
            values[5]="Avg Productivity: "+averagecheckin;


            ticketadapter adapter = new ticketadapter(getApplicationContext(),  imageId, values);
            gridview.setAdapter(adapter);

        }
    }





}
