package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.b2lmobitech.fieldcloudplus.serviceold.ATMlistactivity;
import com.b2lmobitech.fieldcloudplus.serviceold.CategoryList_Offline;
import com.b2lmobitech.fieldcloudplus.serviceold.Product_CategoryList;
import com.b2lmobitech.fieldcloudplus.R;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

/**
 * Created by HP on 03-02-2017.
 */

public class atmlistadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> atmids,atmaddress,atmphonenumbers,atmqrcode,atmlatitude,atmlongitude;
    public static String wantedqrcode="";
    public static Double wantedlatitude=0.0,wantedlongitude=0.0;
    private String customername,customertype,question,combination,combinationtype;
    private Bitmap customericon;
    private sqldatabase mDbHelper;

    public atmlistadapter(Context context, ArrayList<String> atmids, ArrayList<String> atmaddress, ArrayList<String> atmphonenumbers, ArrayList<String> atmqrcode, ArrayList<String> atmlatitude, ArrayList<String> atmlongitude, String customername, Bitmap customericon,String customertype,String question,String combination,String combinationtype) {

        super(context, R.layout.custom_atmlistactivity, atmids);
        this.mycontext = context;
        this.atmids = atmids;
       this.atmaddress = atmaddress;
        this.atmphonenumbers = atmphonenumbers;
        this.atmqrcode = atmqrcode;
        this.atmlatitude = atmlatitude;
        this.atmlongitude = atmlongitude;
        this.customername = customername;
        this.customericon = customericon;
        this.customertype = customertype;
        this.question = question;
        this.combination = combination;
        this.combinationtype = combinationtype;

        mDbHelper = new sqldatabase(mycontext);

            }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_atmlistactivity, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.atm = (TextView) convertView.findViewById(R.id.atm);
            myholder.customericon = (ImageView) convertView.findViewById(R.id.customersicon);
            myholder.Address = (TextView) convertView.findViewById(R.id.Address);
            myholder.scan = (ImageView) convertView.findViewById(R.id.scan);
            myholder.scan.setVisibility(convertView.GONE);
            myholder.qrcodevalue = (TextView) convertView.findViewById(R.id.qrcodevalue);
            myholder.qrcodelatitude = (TextView) convertView.findViewById(R.id.qrcodelatitude);
            myholder.qrcodelongitude = (TextView) convertView.findViewById(R.id.qrcodelongitude);
            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }

        myholder.atm.setText(atmids.get(position));
        if(customericon==null)
        {
            myholder.customericon.setImageResource(R.drawable.ic_action_help);
        }
        else
        {
            myholder.customericon.setImageBitmap(customericon);
        }

        myholder.Address.setText(atmaddress.get(position));
        myholder.qrcodevalue.setText(atmqrcode.get(position));
        myholder.qrcodelatitude.setText(atmlatitude.get(position));
        myholder.qrcodelongitude.setText(atmlongitude.get(position));

        final TextView atmid = (TextView) convertView.findViewById(R.id.atm);
        final ImageView scanqrcode = (ImageView) convertView.findViewById(R.id.scan);
        final TextView scanqrcodevalue = (TextView) convertView.findViewById(R.id.qrcodevalue);
        final TextView scanqrcodelatitude = (TextView) convertView.findViewById(R.id.qrcodelatitude);
        final TextView scanqrcodelongitude = (TextView) convertView.findViewById(R.id.qrcodelongitude);

        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                /*Intent intent = new Intent(mycontext, Product_CategoryList.class);

                intent.putExtra("customername", customername);
                intent.putExtra("customertype", customertype);
                intent.putExtra("facility", atmids.get(position));
                intent.putExtra("combinationname",combination);
                intent.putExtra("combinationtype",combinationtype);
                intent.putExtra("questionmode",question);

                mycontext.startActivity(intent);*/

                Cursor questionlocal = mDbHelper.get_dynamicquestions_combination(combination,combinationtype, customertype,question,customername,atmids.get(position));
                if(questionlocal==null)
                {
                    Intent intent = new Intent(mycontext, Product_CategoryList.class);

                    intent.putExtra("customername", customername);
                    intent.putExtra("customertype", customertype);
                    intent.putExtra("facility", atmids.get(position));
                    intent.putExtra("combinationname",combination);
                    intent.putExtra("combinationtype",combinationtype);
                    intent.putExtra("questionmode",question);

                    mycontext.startActivity(intent);
                }
                else{

                    SimpleDateFormat dateFormatter = new SimpleDateFormat
                            ("yyyy-MM-dd");
                    String todaydate = dateFormatter.format(new Date());

                    Cursor inspectionlocal = mDbHelper.get_dynamicquestions_combination_date(combination,combinationtype, customertype,question,customername,atmids.get(position),todaydate);




                    if(inspectionlocal!=null) {

                        Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                        intent.putExtra("combinationname",combination);
                        intent.putExtra("combinationtype",combinationtype);
                        intent.putExtra("questionmode",question);
                        intent.putExtra("customertype",customertype);
                        intent.putExtra("customername", customername);
                        intent.putExtra("facility",atmids.get(position));
                        mycontext.startActivity(intent);



                    }

                    else{

                        AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                        alertdialog.setTitle("Backup");
                        alertdialog.setIcon(R.drawable.ic_action_backup);
                        alertdialog.setMessage("You Have Old Downloads Do You Want to Continue?");
                        alertdialog.setPositiveButton("Continue",
                                new DialogInterface.OnClickListener() {
                                    public void onClick(DialogInterface dialog, int whichButton)
                                    {

                                        Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                                        intent.putExtra("combinationname",combination);
                                        intent.putExtra("combinationtype",combinationtype);
                                        intent.putExtra("questionmode",question);
                                        intent.putExtra("customertype",customertype);
                                        intent.putExtra("customername", customername);
                                        intent.putExtra("facility",atmids.get(position));
                                        mycontext.startActivity(intent);



                                    }
                                });
                        alertdialog.setNegativeButton("Discard", new DialogInterface.OnClickListener() {

                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                // TODO Auto-generated method stub
                                //////////////////////////////////////////////////////////////////////////////////////////////////////

                                AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                                alertdialog.setTitle("Are you sure?");
                                alertdialog.setIcon(R.drawable.ic_action_delete);
                                alertdialog.setMessage("Erase all data from local inspections");
                                alertdialog.setPositiveButton("Yes",
                                        new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int whichButton)
                                            {

                                                mDbHelper.delete_dynamicquestions_local_all();
                                                mDbHelper.delete_answers_local_all();

                                                Intent intent = new Intent(mycontext, Product_CategoryList.class);

                                                intent.putExtra("customername", customername);
                                                intent.putExtra("customertype", customertype);
                                                intent.putExtra("facility", atmids.get(position));
                                                intent.putExtra("combinationname",combination);
                                                intent.putExtra("combinationtype",combinationtype);
                                                intent.putExtra("questionmode",question);

                                                mycontext.startActivity(intent);


                                            }
                                        });
                                alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        // TODO Auto-generated method stub

                                    }
                                }).create();
                                alertdialog.show();


                                /////////////////////////////////////////////////////////////////////////////////////////////////
                            }
                        }).create();
                        alertdialog.show();
                    }
                }

            }
        });
              /*  scanqrcode.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                wantedqrcode = scanqrcodevalue.getText().toString();
                wantedlatitude = Double.valueOf(scanqrcodelatitude.getText().toString());
                wantedlongitude = Double.valueOf(scanqrcodelongitude.getText().toString());
                //--
                SharedPreferences.Editor editor = globalvariables.Logoutsharedpreference.edit();
                editor.putString(globalvariables.logout_customername, customername);
                editor.putString(globalvariables.logout_atmid, atmid.getText().toString());
                editor.commit();
                alertdialog_forauthentication();

            }
        });*/

           return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
   private static class holder {

        TextView atm,Address,qrcodevalue,qrcodelatitude,qrcodelongitude;
        ImageView scan,customericon;

          }
    public void alertdialog_forauthentication()
    {

        AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

        alertdialog.setTitle("QRCode");
        alertdialog.setIcon(R.drawable.ic_action_qrcode);
        alertdialog.setMessage("Authenticate ATM presence with QR Code");
        alertdialog.setPositiveButton("OK",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton)
                    {
                        //findlocation();
                        qrcode();
                    }
                }).create();
        alertdialog.show();
    }
    public void qrcode()
    {
        if(isNetworkAvailable()){
            try {
                Intent intent = new Intent("com.google.zxing.client.android.SCAN");
                intent.putExtra("SCAN_MODE", "QR_CODE_MODE");// "PRODUCT_MODE for bar codes

                ((Activity) ATMlistactivity.atmlistactivitycontext).startActivityForResult(intent, 0);
            } catch (Exception e) {
                // TODO Auto-generated catch block
//			e.printStackTrace();
                Uri marketUri = Uri.parse("market://details?id=com.google.zxing.client.android");
                Intent marketIntent = new Intent(Intent.ACTION_VIEW,marketUri);
                mycontext.startActivity(marketIntent);
            }
        }
        else
        {
            Toast.makeText(mycontext,"Please connect the internet", Toast.LENGTH_LONG).show();
        }
    }
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) mycontext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            if( cm.getNetworkInfo(ConnectivityManager.TYPE_WIFI).isConnectedOrConnecting() ) {
                // do your stuff
//			    Log.d("wifi connectivity", "connected");
            }else {
//			    	   Log.d("wifi connectivity", "wifi not connected");

            }

            return true;
        }
        return false;
    }
}
