package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;


import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.hcm.Employee_Timesheet;
import com.b2lmobitech.fieldcloudplus.R;


public class attendancesummaryadapter extends ArrayAdapter<String>{

    private final Activity context;

    private final String[] type;
    private final String[] mail;
    private final String[] status;
    private final String[] intime;
    private final String[] permissiontime;
    private final String[] reason;
    private final String[] name;
    private final String[] designation;




    public attendancesummaryadapter(Activity context, String[] mail,String[] type, String[] intime,String[] permissiontime,String[] reason,
                                    String[] status,String[] name,String[] designation) {

        super(context, R.layout.activity_attendancelistitem, mail);

        this.context = context;
        this.intime =intime;
        this.type =type;
        this.permissiontime =permissiontime;
        this.reason =reason;
        this.mail =mail;
        this.status =status;
        this.name =name;
        this.designation =designation;

    }

    @Override

    public View getView(final int position, View view, ViewGroup parent) {

        ViewHolder viewHolder;

        LayoutInflater inflater = context.getLayoutInflater();
        View rowView= inflater.inflate(R.layout.activity_attendancelistitem,null);


        DisplayMetrics displaymetrics = new DisplayMetrics();
        ((Activity) getContext()).getWindowManager()
                .getDefaultDisplay()
                .getMetrics(displaymetrics);

        int width = displaymetrics.widthPixels;

        int txtwidth=(width-200)/2;

        TextView txtname = (TextView) rowView.findViewById(R.id.name);

        TextView txtmail = (TextView) rowView.findViewById(R.id.mail);

        TextView txtdesignation = (TextView) rowView.findViewById(R.id.designation);

        TextView txttype = (TextView) rowView.findViewById(R.id.type);

        TextView txtreason = (TextView) rowView.findViewById(R.id.reason);

        ImageView txtstatus = (ImageView) rowView.findViewById(R.id.status);


        txtmail.setWidth(txtwidth);
        txtname.setWidth(txtwidth);
        txtdesignation.setWidth(txtwidth);
        txttype.setWidth(txtwidth);

        txtmail.setText(mail[position]);
        txttype.setText(type[position]);
        txtname.setText(name[position]);
        txtdesignation.setText(designation[position]);

        if(type[position].equalsIgnoreCase("present"))
        {
            txtreason.setText("( "+intime[position]+" )");
            txtstatus.setVisibility(View.VISIBLE);
            txtstatus.setImageResource(R.drawable.time_sheet);
            txttype.setTextColor(Color.parseColor("#009900"));

        }
        else if(type[position].equalsIgnoreCase("permission"))
        {
            txtreason.setText("( "+permissiontime[position]+"minutes )");
            txtstatus.setVisibility(View.VISIBLE);

            txttype.setTextColor(Color.parseColor("#0028ff"));

            if(status[position].equalsIgnoreCase("accepted"))
            {
                txtstatus.setImageResource(R.drawable.accept);

            }
            else if(status[position].equalsIgnoreCase("rejected"))
            {
                txtstatus.setImageResource(R.drawable.decline);

            }

            else if(status[position].equalsIgnoreCase("pending"))
            {
                txtstatus.setImageResource(R.drawable.unassign);

            }
        }

        else if(type[position].equalsIgnoreCase("absent"))
        {
            txtreason.setText("Not Informed");
            txtstatus.setVisibility(View.VISIBLE);
            txttype.setTextColor(Color.parseColor("#ff0000"));
            txtstatus.setImageResource(R.drawable.absent);

        }
        else{

            txtreason.setText("( "+reason[position]+" )");
            txtstatus.setVisibility(View.VISIBLE);
            txttype.setTextColor(Color.parseColor("#f00000"));

            if(status[position].equalsIgnoreCase("accepted"))
            {
                txtstatus.setImageResource(R.drawable.accept);

            }
            else if(status[position].equalsIgnoreCase("rejected"))
            {
                txtstatus.setImageResource(R.drawable.decline);

            }

            else if(status[position].equalsIgnoreCase("pending"))
            {
                txtstatus.setImageResource(R.drawable.unassign);

            }
        }

        rowView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(type[position].equalsIgnoreCase("present"))
                {
                    Intent intent = new Intent(context, Employee_Timesheet.class);
                    intent.putExtra("emp_mail", mail[position]);
                    context.startActivity(intent);
                }
            }});





        return rowView;

    }

    public class ViewHolder {

        Button button;
    }


}
