package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.serviceold.CategoryList;
import com.b2lmobitech.fieldcloudplus.serviceold.CategoryList_Offline;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.serviceold.CombinationDetails;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

/**
 * Created by HP on 03-02-2017.
 */

public class combinationlistadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> name,type;
    private String question,customer;

    private sqldatabase mDbHelper;

    String registeredcustomername;

    public combinationlistadapter(Context context, ArrayList<String> name,ArrayList<String> type,String question,String customer) {

        super(context, R.layout.custom_customercombination, name);
        this.mycontext = context;
        this.name = name;
        this.type = type;
        this.question=question;
        this.customer=customer;

        mDbHelper = new sqldatabase(mycontext);
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_customercombination, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.cname = (TextView) convertView.findViewById(R.id.c_name);
            myholder.ctype = (TextView) convertView.findViewById(R.id.c_type);
            myholder.next = (ImageView) convertView.findViewById(R.id.next);
            myholder.details = (TextView) convertView.findViewById(R.id.details);
            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }

        myholder.cname.setText(name.get(position));

        char[] ch=type.get(position).toCharArray();

        StringBuilder sb=new StringBuilder();
        sb.append("Company");
        for(int i=0;i<ch.length;i++) {
            if(ch[i]=='o')
            {
                sb.append("#@CustomerMode");
            }
            else if(ch[i]=='c')
            {
                sb.append("#@CustomerName");
            }
            else if(ch[i]=='f')
            {
                sb.append("#@Facility");
            }
            else if(ch[i]=='b')
            {
                sb.append("#@Brand");
            }
            else if(ch[i]=='p')
            {
                sb.append("#@Product");
            }
            else if(ch[i]=='m')
            {
                sb.append("#@Module");
            }
            else if(ch[i]=='n')
            {
                sb.append("#@SerialNumber");
            }
            else if(ch[i]=='r')
            {
                sb.append("#@Designation");
            }
            else if(ch[i]=='g')
            {
                sb.append("#@Group");
            }
            else if(ch[i]=='s')
            {
                sb.append("#@SubGroup");
            }
            else if(ch[i]=='t')
            {
                sb.append("#@Team");
            }
            else if(ch[i]=='z')
            {
                sb.append("#@Custom");
            }
        }

            myholder.ctype.setText(sb.toString());
      //  final  ImageView donetoday = (ImageView) convertView.findViewById(R.id.done);
        final  TextView combinationname = (TextView) convertView.findViewById(R.id.c_name);
        final  RelativeLayout listlayout = (RelativeLayout) convertView.findViewById(R.id.listlayout);

        myholder.next.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                 /*   Intent intent = new Intent(mycontext, CategoryList.class);
//                    Bundle extras = new Bundle();
//                    extras.putString("Categoryname", catgeoryname.getText().toString());
                    intent.putExtra("combinationname",combinationname.getText().toString());
                    intent.putExtra("combinationtype",type.get(position));
                    intent.putExtra("questionmode",question);
                    intent.putExtra("customertype",customer);
                    mycontext.startActivity(intent);*/

                    String[] name_array=combinationname.getText().toString().split("#@");
                     registeredcustomername=name_array[2];

                    Cursor questionlocal = mDbHelper.get_dynamicquestions_combination(combinationname.getText().toString(),type.get(position),customer,question,registeredcustomername,"no data available");
                    if(questionlocal==null)
                    {
                        Intent intent = new Intent(mycontext, CategoryList.class);
//                    Bundle extras = new Bundle();
//                    extras.putString("Categoryname", catgeoryname.getText().toString());
                        intent.putExtra("combinationname",combinationname.getText().toString());
                        intent.putExtra("combinationtype",type.get(position));
                        intent.putExtra("questionmode",question);
                        intent.putExtra("customertype",customer);
                        mycontext.startActivity(intent);

                    }
                    else{

                        SimpleDateFormat dateFormatter = new SimpleDateFormat
                                ("yyyy-MM-dd");
                       String todaydate = dateFormatter.format(new Date());

                        Cursor inspectionlocal = mDbHelper.get_dynamicquestions_combination_date(combinationname.getText().toString(),type.get(position),customer,question,registeredcustomername,"no data available",todaydate);

                        if(inspectionlocal!=null) {

                            Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                            intent.putExtra("combinationname", combinationname.getText().toString());
                            intent.putExtra("combinationtype", type.get(position));
                            intent.putExtra("questionmode", question);
                            intent.putExtra("customertype", customer);
                            intent.putExtra("customername", registeredcustomername);
                            intent.putExtra("facility", "no data available");
                            mycontext.startActivity(intent);
                        }

                        else{

                            AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                            alertdialog.setTitle("Backup");
                            alertdialog.setIcon(R.drawable.ic_action_backup);
                            alertdialog.setMessage("You Have Old Downloads Do You Want to Continue?");
                            alertdialog.setPositiveButton("Continue",
                                    new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int whichButton)
                                        {

                                            Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                                            intent.putExtra("combinationname", combinationname.getText().toString());
                                            intent.putExtra("combinationtype", type.get(position));
                                            intent.putExtra("questionmode", question);
                                            intent.putExtra("customertype", customer);
                                            intent.putExtra("customername", registeredcustomername);
                                            intent.putExtra("facility", "no data available");
                                            mycontext.startActivity(intent);

                                        }
                                    });
                            alertdialog.setNegativeButton("Discard", new DialogInterface.OnClickListener() {

                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    // TODO Auto-generated method stub
                                     //////////////////////////////////////////////////////////////////////////////////////////////////////

                                    AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                                    alertdialog.setTitle("Are you sure?");
                                    alertdialog.setIcon(R.drawable.ic_action_delete);
                                    alertdialog.setMessage("Erase all data from local inspections");
                                    alertdialog.setPositiveButton("Yes",
                                            new DialogInterface.OnClickListener() {
                                                public void onClick(DialogInterface dialog, int whichButton)
                                                {

                                                    mDbHelper.delete_dynamicquestions_local_all();
                                                    mDbHelper.delete_answers_local_all();

                                                    Intent intent = new Intent(mycontext, CategoryList.class);
//
                                                    intent.putExtra("combinationname",combinationname.getText().toString());
                                                    intent.putExtra("combinationtype",type.get(position));
                                                    intent.putExtra("questionmode",question);
                                                    intent.putExtra("customertype",customer);
                                                    mycontext.startActivity(intent);


                                                }
                                            });
                                    alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

                                        @Override
                                        public void onClick(DialogInterface dialog, int which) {
                                            // TODO Auto-generated method stub

                                        }
                                    }).create();
                                    alertdialog.show();


                                    /////////////////////////////////////////////////////////////////////////////////////////////////
                                }
                            }).create();
                            alertdialog.show();
                        }

                    }

                }
            });

        myholder.details.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Intent intent = new Intent(mycontext, CombinationDetails.class);
//                    Bundle extras = new Bundle();
//                    extras.putString("Categoryname", catgeoryname.getText().toString());
                intent.putExtra("combinationname",combinationname.getText().toString());
                intent.putExtra("combinationtype",type.get(position));
                intent.putExtra("customertype",customer);
                intent.putExtra("questionmode","customer");

                mycontext.startActivity(intent);
            }
        });


//        listlayout.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                Intent intent = new Intent(mycontext, Subcategory.class);
//                Bundle extras = new Bundle();
//                extras.putString("Categoryname", catgeoryname.getText().toString());
//                intent.putExtras(extras);
//                mycontext.startActivity(intent);
//            }
//        });


        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    private static class holder {

        TextView cname;
        TextView ctype;

        ImageView next;
        TextView details;

    }
}
