package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by HP on 30-01-2017.
 */

public class emp_timesheetadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> timesheetdate,team,from,to,activity;
    private SimpleDateFormat onlydate,fulldate;
    private Date date;

    public emp_timesheetadapter(Context context, ArrayList<String> timesheetdate, ArrayList<String> team, ArrayList<String> from, ArrayList<String> to, ArrayList<String> activity) {

        super(context, R.layout.custom_timesheet, team);
        this.mycontext = context;
        this.timesheetdate=timesheetdate;
        this.team =team;
        this.from = from;
        this.to = to;
        this.activity = activity;
        fulldate = new SimpleDateFormat("dd MMMM yyyy,EEEE");
        onlydate = new SimpleDateFormat("yyyy-MM-dd");

    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_timesheet, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.
            myholder.timesheetdate = (TextView) convertView.findViewById(R.id.timesheetdate);
            myholder.team = (TextView) convertView.findViewById(R.id.team);
            myholder.from = (TextView) convertView.findViewById(R.id.from);
            myholder.to = (TextView) convertView.findViewById(R.id.to);
            myholder.activity = (TextView) convertView.findViewById(R.id.activity);

            convertView.setTag(myholder);
            //convertView.setBackgroundColor(position % 2 == 0 ? Color.WHITE : Color.parseColor("#FEFCFF"));

        } else {
            myholder = (holder) convertView.getTag();

        }
        try {
            date = onlydate.parse(timesheetdate.get(position));
        } catch (ParseException E) {

        }
        myholder.timesheetdate.setText(fulldate.format(date));
        myholder.team.setText(team.get(position));
        myholder.from.setText(from.get(position));
        myholder.to.setText(to.get(position));
        myholder.activity.setText(activity.get(position));
        final RelativeLayout headinglayout = (RelativeLayout) convertView.findViewById(R.id.headinglayout);
        if(position!=0)
        {
            if(timesheetdate.get(position).equalsIgnoreCase(timesheetdate.get(position-1)))
            {
                headinglayout.setVisibility(convertView.GONE);
            }
            else
            {
                headinglayout.setVisibility(convertView.VISIBLE);
            }
        }
        else
        {
            headinglayout.setVisibility(convertView.VISIBLE);
        }

        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {
        TextView timesheetdate,team,from,to,activity;
    }


}
