package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.serviceold.CategoryList_Offline;
import com.b2lmobitech.fieldcloudplus.serviceold.Facility_ATMlistactivity;
import com.b2lmobitech.fieldcloudplus.serviceold.Facility_CategoryList;
import com.b2lmobitech.fieldcloudplus.R;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;

/**
 * Created by HP on 03-02-2017.
 */

public class facility_customerlistadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> Customers;
    private ArrayList<String> Customertype;
    private ArrayList<String> Customeraddress;
    private ArrayList<Bitmap> customerimage;
    String question,combination,combinationtype;

    private sqldatabase mDbHelper;

    public facility_customerlistadapter(Context context, ArrayList<String> Customers,ArrayList<Bitmap> customerimage, ArrayList<String> Customertype,ArrayList<String> Customeraddress,String question,String combination,String combinationtype) {

        super(context, R.layout.custom_facilitycustomerlist, Customers);
        this.mycontext = context;
        this.Customers = Customers;
        this.customerimage = customerimage;
        this.Customertype = Customertype;
        this.Customeraddress=Customeraddress;
        this.question = question;
        this.combination = combination;
        this.combinationtype = combinationtype;

        mDbHelper = new sqldatabase(mycontext);

    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_facilitycustomerlist, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.customer = (TextView) convertView.findViewById(R.id.customername);
            myholder.address = (TextView) convertView.findViewById(R.id.customeraddress);
            myholder.icon = (ImageView) convertView.findViewById(R.id.customericon);

            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }

        myholder.customer.setText(Customers.get(position));
        myholder.address.setText(Customeraddress.get(position));
        if(customerimage.get(position)==null)
        {
            myholder.icon.setImageResource(R.drawable.ic_action_help);
        }
        else {
            myholder.icon.setImageBitmap(customerimage.get(position));
        }

        final RelativeLayout content_customerlist = (RelativeLayout) convertView.findViewById(R.id.content_customerlist);
        final TextView customername = (TextView) convertView.findViewById(R.id.customername);
        content_customerlist.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {


                if(customerimage.get(position)==null)
                {
                    if(Customertype.get(position).equalsIgnoreCase("individual"))
                    {
                      /*  Intent intent = new Intent(mycontext, Facility_CategoryList.class);

                        intent.putExtra("customername", customername.getText().toString());
                        intent.putExtra("customertype", Customertype.get(position));
                        intent.putExtra("facility", "no data available");
                        intent.putExtra("combinationname",combination);
                        intent.putExtra("combinationtype",combinationtype);
                        intent.putExtra("questionmode",question);

                        mycontext.startActivity(intent);*/

                        Cursor questionlocal = mDbHelper.get_dynamicquestions_combination(combination,combinationtype, Customertype.get(position),question,customername.getText().toString(),"no data available");
                        if(questionlocal==null)
                        {
                            Intent intent = new Intent(mycontext, Facility_CategoryList.class);

                            intent.putExtra("customername", customername.getText().toString());
                            intent.putExtra("customertype", Customertype.get(position));
                            intent.putExtra("facility", "no data available");
                            intent.putExtra("combinationname",combination);
                            intent.putExtra("combinationtype",combinationtype);
                            intent.putExtra("questionmode",question);

                            mycontext.startActivity(intent);
                        }
                        else{

                            SimpleDateFormat dateFormatter = new SimpleDateFormat
                                    ("yyyy-MM-dd");
                            String todaydate = dateFormatter.format(new Date());

                            Cursor inspectionlocal = mDbHelper.get_dynamicquestions_combination_date(combination,combinationtype, Customertype.get(position),question,customername.getText().toString(),"no data available",todaydate);




                            if(inspectionlocal!=null) {

                                Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                                intent.putExtra("combinationname",combination);
                                intent.putExtra("combinationtype",combinationtype);
                                intent.putExtra("questionmode",question);
                                intent.putExtra("customertype", Customertype.get(position));
                                intent.putExtra("customername", customername.getText().toString());
                                intent.putExtra("facility","no data available");
                                mycontext.startActivity(intent);

                            }

                            else{

                                AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                                alertdialog.setTitle("Backup");
                                alertdialog.setIcon(R.drawable.ic_action_backup);
                                alertdialog.setMessage("You Have Old Downloads Do You Want to Continue?");
                                alertdialog.setPositiveButton("Continue",
                                        new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int whichButton)
                                            {

                                                Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                                                intent.putExtra("combinationname",combination);
                                                intent.putExtra("combinationtype",combinationtype);
                                                intent.putExtra("questionmode",question);
                                                intent.putExtra("customertype", Customertype.get(position));
                                                intent.putExtra("customername", customername.getText().toString());
                                                intent.putExtra("facility","no data available");
                                                mycontext.startActivity(intent);


                                            }
                                        });
                                alertdialog.setNegativeButton("Discard", new DialogInterface.OnClickListener() {

                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        // TODO Auto-generated method stub
                                        //////////////////////////////////////////////////////////////////////////////////////////////////////

                                        AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                                        alertdialog.setTitle("Are you sure?");
                                        alertdialog.setIcon(R.drawable.ic_action_delete);
                                        alertdialog.setMessage("Erase all data from local inspections");
                                        alertdialog.setPositiveButton("Yes",
                                                new DialogInterface.OnClickListener() {
                                                    public void onClick(DialogInterface dialog, int whichButton)
                                                    {

                                                        mDbHelper.delete_dynamicquestions_local_all();
                                                        mDbHelper.delete_answers_local_all();

                                                        Intent intent = new Intent(mycontext, Facility_CategoryList.class);

                                                        intent.putExtra("customername", customername.getText().toString());
                                                        intent.putExtra("customertype", Customertype.get(position));
                                                        intent.putExtra("facility", "no data available");
                                                        intent.putExtra("combinationname",combination);
                                                        intent.putExtra("combinationtype",combinationtype);
                                                        intent.putExtra("questionmode",question);

                                                        mycontext.startActivity(intent);


                                                    }
                                                });
                                        alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

                                            @Override
                                            public void onClick(DialogInterface dialog, int which) {
                                                // TODO Auto-generated method stub

                                            }
                                        }).create();
                                        alertdialog.show();


                                        /////////////////////////////////////////////////////////////////////////////////////////////////
                                    }
                                }).create();
                                alertdialog.show();
                            }

                        }

                    }
                    else {
                        Intent intent = new Intent(mycontext, Facility_ATMlistactivity.class);
                        intent.putExtra("Customername", customername.getText().toString());
                        intent.putExtra("Customertype", Customertype.get(position));
                        intent.putExtra("Customericon", "");
                        intent.putExtra("combinationname",combination);
                        intent.putExtra("combinationtype",combinationtype);
                        intent.putExtra("questionmode",question);

                        mycontext.startActivity(intent);
                    }
                }
                else
                {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    customerimage.get(position).compress(Bitmap.CompressFormat.PNG, 100, stream);
                    byte[] byteArray = stream.toByteArray();

                    if(Customertype.get(position).equalsIgnoreCase("individual"))
                    {
                        Cursor questionlocal = mDbHelper.get_dynamicquestions_combination(combination,combinationtype, Customertype.get(position),question,customername.getText().toString(),"no data available");
                        if(questionlocal==null)
                        {
                            Intent intent = new Intent(mycontext, Facility_CategoryList.class);

                            intent.putExtra("customername", customername.getText().toString());
                            intent.putExtra("customertype", Customertype.get(position));
                            intent.putExtra("facility", "no data available");
                            intent.putExtra("combinationname",combination);
                            intent.putExtra("combinationtype",combinationtype);
                            intent.putExtra("questionmode",question);

                            mycontext.startActivity(intent);
                        }
                        else{

                            SimpleDateFormat dateFormatter = new SimpleDateFormat
                                    ("yyyy-MM-dd");
                            String todaydate = dateFormatter.format(new Date());

                            Cursor inspectionlocal = mDbHelper.get_dynamicquestions_combination_date(combination,combinationtype, Customertype.get(position),question,customername.getText().toString(),"no data available",todaydate);




                            if(inspectionlocal!=null) {

                                Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                                intent.putExtra("combinationname",combination);
                                intent.putExtra("combinationtype",combinationtype);
                                intent.putExtra("questionmode",question);
                                intent.putExtra("customertype", Customertype.get(position));
                                intent.putExtra("customername", customername.getText().toString());
                                intent.putExtra("facility","no data available");
                                mycontext.startActivity(intent);

                            }

                            else{

                                AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                                alertdialog.setTitle("Backup");
                                alertdialog.setIcon(R.drawable.ic_action_backup);
                                alertdialog.setMessage("You Have Old Downloads Do You Want to Continue?");
                                alertdialog.setPositiveButton("Continue",
                                        new DialogInterface.OnClickListener() {
                                            public void onClick(DialogInterface dialog, int whichButton)
                                            {

                                                Intent intent = new Intent(mycontext, CategoryList_Offline.class);

                                                intent.putExtra("combinationname",combination);
                                                intent.putExtra("combinationtype",combinationtype);
                                                intent.putExtra("questionmode",question);
                                                intent.putExtra("customertype", Customertype.get(position));
                                                intent.putExtra("customername", customername.getText().toString());
                                                intent.putExtra("facility","no data available");
                                                mycontext.startActivity(intent);


                                            }
                                        });
                                alertdialog.setNegativeButton("Discard", new DialogInterface.OnClickListener() {

                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        // TODO Auto-generated method stub
                                        //////////////////////////////////////////////////////////////////////////////////////////////////////

                                        AlertDialog.Builder alertdialog = new AlertDialog.Builder(mycontext);

                                        alertdialog.setTitle("Are you sure?");
                                        alertdialog.setIcon(R.drawable.ic_action_delete);
                                        alertdialog.setMessage("Erase all data from local inspections");
                                        alertdialog.setPositiveButton("Yes",
                                                new DialogInterface.OnClickListener() {
                                                    public void onClick(DialogInterface dialog, int whichButton)
                                                    {

                                                        mDbHelper.delete_dynamicquestions_local_all();
                                                        mDbHelper.delete_answers_local_all();

                                                        Intent intent = new Intent(mycontext, Facility_CategoryList.class);

                                                        intent.putExtra("customername", customername.getText().toString());
                                                        intent.putExtra("customertype", Customertype.get(position));
                                                        intent.putExtra("facility", "no data available");
                                                        intent.putExtra("combinationname",combination);
                                                        intent.putExtra("combinationtype",combinationtype);
                                                        intent.putExtra("questionmode",question);

                                                        mycontext.startActivity(intent);


                                                    }
                                                });
                                        alertdialog.setNegativeButton("No", new DialogInterface.OnClickListener() {

                                            @Override
                                            public void onClick(DialogInterface dialog, int which) {
                                                // TODO Auto-generated method stub

                                            }
                                        }).create();
                                        alertdialog.show();


                                        /////////////////////////////////////////////////////////////////////////////////////////////////
                                    }
                                }).create();
                                alertdialog.show();
                            }

                        }
                    }
                    else {
                        Intent intent = new Intent(mycontext, Facility_ATMlistactivity.class);
                        intent.putExtra("Customername", customername.getText().toString());
                        intent.putExtra("Customertype", Customertype.get(position));
                        intent.putExtra("Customericon", byteArray);
                        intent.putExtra("combinationname",combination);
                        intent.putExtra("combinationtype",combinationtype);
                        intent.putExtra("questionmode",question);

                        mycontext.startActivity(intent);
                    }
                }


            }
        });



        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    private static class holder {

        TextView customer,address;
        ImageView icon;

    }
}
