package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import java.util.ArrayList;

/**
 * Created by HP on 30-01-2017.
 */

public class helpcenteradapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> headings, explanations, picturetitles;
    private  ArrayList<Bitmap> pictures;

    public helpcenteradapter(Context context, ArrayList<String> headings,ArrayList<String> explanations,ArrayList<String> picturetitles,ArrayList<Bitmap> pictures) {

        super(context, R.layout.custom_helpcenter, headings);
        this.mycontext = context;
        this.headings = headings;
        this.explanations = explanations;
        this.picturetitles = picturetitles;
        this.pictures = pictures;



    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_helpcenter, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.picture = (ImageView) convertView.findViewById(R.id.picture);
            myholder.picturetitle = (TextView) convertView.findViewById(R.id.picturetitle);
            myholder.heading = (TextView) convertView.findViewById(R.id.title);
            myholder.explanation = (TextView) convertView.findViewById(R.id.explanation);
            myholder.icon = (ImageView) convertView.findViewById(R.id.icon);
            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }


        myholder.picturetitle.setText(picturetitles.get(position));
        myholder.heading.setText(headings.get(position));
        myholder.explanation.setText(explanations.get(position));
        if(pictures.get(position)!=null) {
            myholder.picture.setImageBitmap(pictures.get(position));
        }
        else
        {
            myholder.picture.setImageResource(R.drawable.fieldclouddesk);
        }
       // Toast.makeText(mycontext,picturetitles.get(position),Toast.LENGTH_LONG).show();

        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {

        TextView picturetitle, heading, explanation;
        ImageView picture,icon;


    }
}
