package com.b2lmobitech.fieldcloudplus.serviceold.adapterclass;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by HP on 30-01-2017.
 */

public class inspectionadapter extends ArrayAdapter<String> {
    private Context mycontext;
    private ArrayList<String> subcategory,questionnumbers,questions,answers,typeofquestion,image;
    private String companyname,customername,atmid,emailid,category,todaydate;
    private String typeofselection="";
    private SimpleDateFormat dateFormatter;

    public inspectionadapter(Context context, String companyname,String customername,String atmid,String emailid,String category,ArrayList<String> subcategory, ArrayList<String> questionnumbers, ArrayList<String> questions,ArrayList<String> answers,ArrayList<String> typeofquestion,ArrayList<String> image) {

        super(context, R.layout.custom_inspection, questions);
        this.mycontext = context;
        this.companyname = companyname;
        this.customername = customername;
        this.atmid = atmid;
        this.emailid = emailid;
        this.category = category;
        this.subcategory = subcategory;
        this.questionnumbers = questionnumbers;
        this.questions = questions;
        this.answers = answers;
        this.typeofquestion = typeofquestion;
        this.image = image;
        dateFormatter = new SimpleDateFormat
                ("yyyy-MM-dd HH:mm:ss");
        todaydate = dateFormatter.format(new Date());
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        holder myholder = new holder();
        LayoutInflater inf = (LayoutInflater) mycontext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);// Instantiates
        // a layout
        // XML file
        // corresponding
        // View
        // objects

        if (convertView == null) {
            convertView = inf.inflate(R.layout.custom_inspection, parent, false);// Inflate
            // a
            // new
            // view
            // hierarchy
            // from
            // the
            // specified
            // xml
            // resource.

            myholder.heading = (TextView) convertView.findViewById(R.id.heading);
            myholder.question = (TextView) convertView.findViewById(R.id.question);
            myholder.answer = (TextView) convertView.findViewById(R.id.answer);

            myholder.signatureimage = (ImageView) convertView.findViewById(R.id.signatureimage);
            myholder.questionnumber = (TextView) convertView.findViewById(R.id.questionnumber);

            convertView.setTag(myholder);


        } else {
            myholder = (holder) convertView.getTag();

        }

        if(subcategory.get(position).equalsIgnoreCase(""))
        {
            myholder.heading.setText(category);
        }else {
            myholder.heading.setText(subcategory.get(position));
        }
        if (position != 0) {
            if (subcategory.get(position).equalsIgnoreCase(
                    subcategory.get(position - 1))) {
                myholder.heading.setVisibility(convertView.GONE);
            } else {
                myholder.heading.setVisibility(convertView.VISIBLE);
            }
        } else {
            myholder.heading.setVisibility(convertView.VISIBLE);
        }




        if(typeofquestion.get(position).equals("signature")||typeofquestion.get(position).equals("image"))
        {

            myholder.signatureimage.setVisibility(convertView.VISIBLE);
            myholder.answer.setVisibility(convertView.GONE);

            myholder.answer.setText("");
            myholder.question.setText(questions.get(position));
            myholder.questionnumber.setText(questionnumbers.get(position)+")");

            byte [] encodeByte= Base64.decode(image.get(position),Base64.DEFAULT);
           Bitmap bitmap=BitmapFactory.decodeByteArray(encodeByte, 0, encodeByte.length);
                myholder.signatureimage.setImageBitmap(bitmap);



        }
        else
        {

            myholder.signatureimage.setVisibility(convertView.GONE);
            myholder.answer.setVisibility(convertView.VISIBLE);

            myholder.question.setText(questions.get(position));
            myholder.questionnumber.setText(questionnumbers.get(position)+")");
            myholder.answer.setText(answers.get(position));

            myholder.signatureimage.setImageBitmap(null);


        }




        return convertView;
    }

    /**
     * This class holds reference to all the views inflated in the getView
     * method.
     **/
    static class holder {

        TextView question,answer,heading,questionnumber;
        ImageView signatureimage;


    }



}
